/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core.mapping;

import java.lang.reflect.Constructor;
import org.springframework.beans.BeanUtils;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.mapping.context.MappingContextEvent;
import org.springframework.data.solr.core.schema.SolrPersistentEntitySchemaCreator;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class SolrMappingEventPublisher
implements ApplicationEventPublisher {
    static final String SPRING_42_PAYLOAD_APPLICATION_EVENT_CLASS_NAME = "org.springframework.context.PayloadApplicationEvent";
    static final boolean SPRING_42_PAYLOAD_APPLICATION_EVENT_PRESENT = ClassUtils.isPresent((String)"org.springframework.context.PayloadApplicationEvent", null);
    SolrPersistentEntitySchemaCreator schmeaCreator;

    public SolrMappingEventPublisher(SolrPersistentEntitySchemaCreator schemaCreator) {
        this.schmeaCreator = schemaCreator;
    }

    public void publishEvent(ApplicationEvent event) {
        if (event instanceof MappingContextEvent) {
            this.schmeaCreator.onApplicationEvent((MappingContextEvent)event);
        }
    }

    public void publishEvent(Object event) {
        Assert.notNull((Object)event, (String)"Event to publish must not be null!");
        this.publishEvent(this.initGenericApplicationEvent(event));
    }

    private ApplicationEvent initGenericApplicationEvent(Object event) {
        ApplicationEvent applicationEvent = null;
        if (event instanceof ApplicationEvent) {
            applicationEvent = (ApplicationEvent)event;
        }
        if (SPRING_42_PAYLOAD_APPLICATION_EVENT_PRESENT) {
            try {
                Constructor ctor = ClassUtils.getConstructorIfAvailable((Class)ClassUtils.forName((String)SPRING_42_PAYLOAD_APPLICATION_EVENT_CLASS_NAME, (ClassLoader)this.getClass().getClassLoader()), (Class[])new Class[]{Object.class, Object.class});
                applicationEvent = (ApplicationEvent)BeanUtils.instantiateClass((Constructor)ctor, (Object[])new Object[]{this, event});
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (applicationEvent == null) {
            applicationEvent = new ApplicationEvent(event){};
        }
        return applicationEvent;
    }
}

