/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core.query;

import java.util.Arrays;
import org.springframework.data.solr.core.query.AbstractFunction;
import org.springframework.data.solr.core.query.Field;
import org.springframework.data.solr.core.query.Function;
import org.springframework.util.Assert;

public class DefaultValueFunction
extends AbstractFunction {
    private static final String OPERATION = "def";

    private DefaultValueFunction(Object fieldName, Object defaultValue) {
        super(Arrays.asList(fieldName, defaultValue));
    }

    public static DefaultValueFunction defaultValue(String fieldName, Object defaultValue) {
        Assert.hasText((String)fieldName, (String)"Fieldname must not be 'empty' for default value operation.");
        Assert.notNull((Object)defaultValue, (String)"DefaultValue must not be 'null'.");
        return new DefaultValueFunction(fieldName, defaultValue);
    }

    public static DefaultValueFunction defaultValue(Field field, Object defaultValue) {
        Assert.notNull((Object)field, (String)"Field must not be 'null' for default value operation.");
        return DefaultValueFunction.defaultValue(field.getName(), defaultValue);
    }

    public static DefaultValueFunction defaultValue(Function function, Object defaultValue) {
        Assert.notNull((Object)function, (String)"Function must not be 'null' for default value operation.");
        Assert.notNull((Object)defaultValue, (String)"DefaultValue must not be 'null'.");
        return new DefaultValueFunction(function, defaultValue);
    }

    @Override
    public String getOperation() {
        return OPERATION;
    }
}

