/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.core.config;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import lombok.NonNull;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.rest.core.config.Projection;
import org.springframework.data.rest.core.projection.ProjectionDefinitions;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class ProjectionDefinitionConfiguration
implements ProjectionDefinitions {
    private static final String PROJECTION_ANNOTATION_NOT_FOUND = "Projection annotation not found on %s! Either add the annotation or hand source type to the registration manually!";
    private static final String DEFAULT_PROJECTION_PARAMETER_NAME = "projection";
    private final Set<ProjectionDefinition> projectionDefinitions = new HashSet<ProjectionDefinition>();
    private String parameterName = "projection";

    @Override
    public String getParameterName() {
        return this.parameterName;
    }

    public void setParameterName(String parameterName) {
        this.parameterName = StringUtils.hasText((String)parameterName) ? parameterName : DEFAULT_PROJECTION_PARAMETER_NAME;
    }

    public ProjectionDefinitionConfiguration addProjection(Class<?> projectionType) {
        Assert.notNull(projectionType, (String)"Projection type must not be null!");
        Projection annotation = (Projection)AnnotationUtils.findAnnotation(projectionType, Projection.class);
        if (annotation == null) {
            throw new IllegalArgumentException(String.format(PROJECTION_ANNOTATION_NOT_FOUND, projectionType));
        }
        String name = annotation.name();
        Class<?>[] sourceTypes = annotation.types();
        return StringUtils.hasText((String)name) ? this.addProjection(projectionType, name, sourceTypes) : this.addProjection(projectionType, sourceTypes);
    }

    public ProjectionDefinitionConfiguration addProjection(Class<?> projectionType, Class<?> ... sourceTypes) {
        Assert.notNull(projectionType, (String)"Projection type must not be null!");
        return this.addProjection(projectionType, StringUtils.uncapitalize((String)projectionType.getSimpleName()), sourceTypes);
    }

    public ProjectionDefinitionConfiguration addProjection(Class<?> projectionType, String name, Class<?> ... sourceTypes) {
        Assert.notNull(projectionType, (String)"Projection type must not be null!");
        Assert.hasText((String)name, (String)"Name must not be null or empty!");
        Assert.notEmpty((Object[])sourceTypes, (String)"Source types must not be null!");
        for (Class<?> sourceType : sourceTypes) {
            this.projectionDefinitions.add(ProjectionDefinition.of(sourceType, projectionType, name));
        }
        return this;
    }

    @Override
    public Class<?> getProjectionType(Class<?> sourceType, String name) {
        return this.getProjectionsFor(sourceType).get(name);
    }

    @Override
    public boolean hasProjectionFor(Class<?> sourceType) {
        for (ProjectionDefinition definition : this.projectionDefinitions) {
            if (!definition.sourceType.isAssignableFrom(sourceType)) continue;
            return true;
        }
        return false;
    }

    public Map<String, Class<?>> getProjectionsFor(Class<?> sourceType) {
        Assert.notNull(sourceType, (String)"Source type must not be null!");
        Class userType = ClassUtils.getUserClass(sourceType);
        HashMap<String, ProjectionDefinition> byName = new HashMap<String, ProjectionDefinition>();
        HashMap result = new HashMap();
        for (ProjectionDefinition entry : this.projectionDefinitions) {
            ProjectionDefinition existing;
            if (!entry.sourceType.isAssignableFrom(userType) || (existing = (ProjectionDefinition)byName.get(entry.name)) != null && !ProjectionDefinitionConfiguration.isSubTypeOf(entry.sourceType, existing.sourceType)) continue;
            byName.put(entry.name, entry);
            result.put(entry.name, entry.targetType);
        }
        return result;
    }

    private static boolean isSubTypeOf(Class<?> left, Class<?> right) {
        return right.isAssignableFrom(left) && !left.equals(right);
    }

    static final class ProjectionDefinition {
        @NonNull
        private final Class<?> sourceType;
        @NonNull
        private final Class<?> targetType;
        @NonNull
        private final String name;

        static ProjectionDefinition of(Class<?> sourceType, Class<?> targetType, String name) {
            Assert.hasText((String)name, (String)"Name must not be null or empty!");
            return new ProjectionDefinition(sourceType, targetType, name);
        }

        @NonNull
        public Class<?> getSourceType() {
            return this.sourceType;
        }

        @NonNull
        public Class<?> getTargetType() {
            return this.targetType;
        }

        @NonNull
        public String getName() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ProjectionDefinition)) {
                return false;
            }
            ProjectionDefinition other = (ProjectionDefinition)o;
            Class<?> this$sourceType = this.getSourceType();
            Class<?> other$sourceType = other.getSourceType();
            if (this$sourceType == null ? other$sourceType != null : !this$sourceType.equals(other$sourceType)) {
                return false;
            }
            Class<?> this$targetType = this.getTargetType();
            Class<?> other$targetType = other.getTargetType();
            if (this$targetType == null ? other$targetType != null : !this$targetType.equals(other$targetType)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Class<?> $sourceType = this.getSourceType();
            result = result * 59 + ($sourceType == null ? 43 : $sourceType.hashCode());
            Class<?> $targetType = this.getTargetType();
            result = result * 59 + ($targetType == null ? 43 : $targetType.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        public String toString() {
            return "ProjectionDefinitionConfiguration.ProjectionDefinition(sourceType=" + this.getSourceType() + ", targetType=" + this.getTargetType() + ", name=" + this.getName() + ")";
        }

        private ProjectionDefinition(@NonNull Class<?> sourceType, @NonNull Class<?> targetType, @NonNull String name) {
            if (sourceType == null) {
                throw new IllegalArgumentException("sourceType is marked @NonNull but is null");
            }
            if (targetType == null) {
                throw new IllegalArgumentException("targetType is marked @NonNull but is null");
            }
            if (name == null) {
                throw new IllegalArgumentException("name is marked @NonNull but is null");
            }
            this.sourceType = sourceType;
            this.targetType = targetType;
            this.name = name;
        }
    }
}

