/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.core.support;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.ConversionService;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.SimpleAssociationHandler;
import org.springframework.data.mapping.SimplePropertyHandler;
import org.springframework.data.mapping.model.ConvertingPropertyAccessor;
import org.springframework.data.repository.support.Repositories;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class DomainObjectMerger {
    private final Repositories repositories;
    private final ConversionService conversionService;

    @Autowired
    public DomainObjectMerger(Repositories repositories, ConversionService conversionService) {
        Assert.notNull((Object)repositories, (String)"Repositories must not be null!");
        Assert.notNull((Object)conversionService, (String)"ConversionService must not be null!");
        this.repositories = repositories;
        this.conversionService = conversionService;
    }

    public void merge(Object from, Object target, NullHandlingPolicy nullPolicy) {
        if (from == null || target == null) {
            return;
        }
        PersistentEntity sourceEntity = this.repositories.getPersistentEntity(from.getClass());
        ConvertingPropertyAccessor sourceWrapper = new ConvertingPropertyAccessor(sourceEntity.getPropertyAccessor(from), this.conversionService);
        PersistentEntity targetEntity = this.repositories.getPersistentEntity(from.getClass());
        ConvertingPropertyAccessor targetWrapper = new ConvertingPropertyAccessor(targetEntity.getPropertyAccessor(target), this.conversionService);
        targetEntity.doWithProperties(new SimplePropertyHandler((PersistentPropertyAccessor)sourceWrapper, (PersistentPropertyAccessor)targetWrapper, targetEntity, nullPolicy){
            final /* synthetic */ PersistentPropertyAccessor val$sourceWrapper;
            final /* synthetic */ PersistentPropertyAccessor val$targetWrapper;
            final /* synthetic */ PersistentEntity val$targetEntity;
            final /* synthetic */ NullHandlingPolicy val$nullPolicy;
            {
                this.val$sourceWrapper = persistentPropertyAccessor;
                this.val$targetWrapper = persistentPropertyAccessor2;
                this.val$targetEntity = persistentEntity;
                this.val$nullPolicy = nullHandlingPolicy;
            }

            public void doWithPersistentProperty(PersistentProperty<?> persistentProperty) {
                Object sourceValue = this.val$sourceWrapper.getProperty(persistentProperty);
                Object targetValue = this.val$targetWrapper.getProperty(persistentProperty);
                if (this.val$targetEntity.isIdProperty(persistentProperty)) {
                    return;
                }
                if (sourceValue != null && sourceValue.equals(targetValue)) {
                    return;
                }
                if (this.val$nullPolicy == NullHandlingPolicy.APPLY_NULLS || sourceValue != null) {
                    this.val$targetWrapper.setProperty(persistentProperty, sourceValue);
                }
            }
        });
        targetEntity.doWithAssociations(new SimpleAssociationHandler((PersistentPropertyAccessor)sourceWrapper, (PersistentPropertyAccessor)targetWrapper){
            final /* synthetic */ PersistentPropertyAccessor val$sourceWrapper;
            final /* synthetic */ PersistentPropertyAccessor val$targetWrapper;
            {
                this.val$sourceWrapper = persistentPropertyAccessor;
                this.val$targetWrapper = persistentPropertyAccessor2;
            }

            public void doWithAssociation(Association<? extends PersistentProperty<?>> association) {
                PersistentProperty persistentProperty = association.getInverse();
                Object fromVal = this.val$sourceWrapper.getProperty(persistentProperty);
                if (!DomainObjectMerger.isNullOrEmpty(fromVal) && !fromVal.equals(this.val$targetWrapper.getProperty(persistentProperty))) {
                    this.val$targetWrapper.setProperty(persistentProperty, fromVal);
                }
            }
        });
    }

    static boolean isNullOrEmpty(Object source) {
        if (source == null) {
            return true;
        }
        if (source instanceof Iterable) {
            return !((Iterable)source).iterator().hasNext();
        }
        if (ObjectUtils.isArray((Object)source)) {
            return ObjectUtils.isEmpty((Object[])((Object[])source));
        }
        return false;
    }

    public static enum NullHandlingPolicy {
        APPLY_NULLS,
        IGNORE_NULLS;

    }
}

