/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.core.mapping;

import java.lang.reflect.Modifier;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.rest.core.annotation.RepositoryRestResource;
import org.springframework.data.rest.core.annotation.RestResource;

public interface RepositoryDetectionStrategy {
    public boolean isExported(RepositoryMetadata var1);

    public static enum RepositoryDetectionStrategies implements RepositoryDetectionStrategy
    {
        ALL{

            @Override
            public boolean isExported(RepositoryMetadata metadata) {
                return true;
            }
        }
        ,
        DEFAULT{

            @Override
            public boolean isExported(RepositoryMetadata metadata) {
                return RepositoryDetectionStrategies.isExplicitlyExported(metadata.getRepositoryInterface(), RepositoryDetectionStrategies.isExplicitlyExported(metadata.getDomainType(), 2.VISIBILITY.isExported(metadata)));
            }
        }
        ,
        VISIBILITY{

            @Override
            public boolean isExported(RepositoryMetadata metadata) {
                return Modifier.isPublic(metadata.getRepositoryInterface().getModifiers());
            }
        }
        ,
        ANNOTATED{

            @Override
            public boolean isExported(RepositoryMetadata metadata) {
                return RepositoryDetectionStrategies.isExplicitlyExported(metadata.getRepositoryInterface(), false);
            }
        }
        ,
        EXPLICIT_METHOD_ANNOTATED{

            @Override
            public boolean isExported(RepositoryMetadata metadata) {
                return RepositoryDetectionStrategies.isExplicitlyExported(metadata.getRepositoryInterface(), false);
            }
        };


        private static boolean isExplicitlyExported(Class<?> type, boolean fallback) {
            RepositoryRestResource restResource = (RepositoryRestResource)AnnotationUtils.findAnnotation(type, RepositoryRestResource.class);
            if (restResource != null) {
                return restResource.exported();
            }
            RestResource resource = (RestResource)AnnotationUtils.findAnnotation(type, RestResource.class);
            if (resource != null) {
                return resource.exported();
            }
            return fallback;
        }
    }
}

