/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.jedis;

import java.beans.ConstructorProperties;
import lombok.NonNull;
import org.springframework.data.redis.connection.RedisHyperLogLogCommands;
import org.springframework.data.redis.connection.jedis.JedisConnection;
import org.springframework.data.redis.connection.jedis.JedisResult;
import org.springframework.util.Assert;

class JedisHyperLogLogCommands
implements RedisHyperLogLogCommands {
    @NonNull
    private final JedisConnection connection;

    @Override
    public Long pfAdd(byte[] key, byte[] ... values) {
        Assert.notEmpty((Object[])values, (String)"PFADD requires at least one non 'null' value.");
        Assert.noNullElements((Object[])values, (String)"Values for PFADD must not contain 'null'.");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().pfadd(key, values)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().pfadd(key, values)));
                return null;
            }
            return this.connection.getJedis().pfadd(key, values);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long pfCount(byte[] ... keys) {
        Assert.notEmpty((Object[])keys, (String)"PFCOUNT requires at least one non 'null' key.");
        Assert.noNullElements((Object[])keys, (String)"Keys for PFCOUNT must not contain 'null'.");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().pfcount(keys)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().pfcount(keys)));
                return null;
            }
            return this.connection.getJedis().pfcount(keys);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void pfMerge(byte[] destinationKey, byte[] ... sourceKeys) {
        Assert.notNull((Object)destinationKey, (String)"Destination key must not be null");
        Assert.notNull((Object)sourceKeys, (String)"Source keys must not be null");
        Assert.noNullElements((Object[])sourceKeys, (String)"Keys for PFMERGE must not contain 'null'.");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().pfmerge(destinationKey, sourceKeys)));
                return;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().pfmerge(destinationKey, sourceKeys)));
                return;
            }
            this.connection.getJedis().pfmerge(destinationKey, sourceKeys);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    private boolean isPipelined() {
        return this.connection.isPipelined();
    }

    private void pipeline(JedisResult result) {
        this.connection.pipeline(result);
    }

    private boolean isQueueing() {
        return this.connection.isQueueing();
    }

    private void transaction(JedisResult result) {
        this.connection.transaction(result);
    }

    private RuntimeException convertJedisAccessException(Exception ex) {
        return this.connection.convertJedisAccessException(ex);
    }

    @ConstructorProperties(value={"connection"})
    public JedisHyperLogLogCommands(@NonNull JedisConnection connection) {
        if (connection == null) {
            throw new NullPointerException("connection");
        }
        this.connection = connection;
    }
}

