/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.jredis;

import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.jredis.JRedis;
import org.jredis.connector.Connection;
import org.jredis.connector.ConnectionSpec;
import org.jredis.ri.alphazero.JRedisClient;
import org.jredis.ri.alphazero.connection.DefaultConnectionSpec;
import org.springframework.data.redis.connection.Pool;
import org.springframework.data.redis.connection.PoolException;
import org.springframework.util.StringUtils;

public class JredisPool
implements Pool<JRedis> {
    private final GenericObjectPool<JRedis> internalPool;

    public JredisPool(String hostName, int port) {
        this(hostName, port, 0, null, 0, new GenericObjectPoolConfig());
    }

    public JredisPool(String hostName, int port, GenericObjectPoolConfig poolConfig) {
        this(hostName, port, 0, null, 0, poolConfig);
    }

    public JredisPool(ConnectionSpec connectionSpec) {
        this.internalPool = new GenericObjectPool((PooledObjectFactory)new JredisFactory(connectionSpec), new GenericObjectPoolConfig());
    }

    public JredisPool(ConnectionSpec connectionSpec, GenericObjectPoolConfig poolConfig) {
        this.internalPool = new GenericObjectPool((PooledObjectFactory)new JredisFactory(connectionSpec), poolConfig);
    }

    public JredisPool(String hostName, int port, int dbIndex, String password, int timeout) {
        this(hostName, port, dbIndex, password, timeout, new GenericObjectPoolConfig());
    }

    public JredisPool(String hostName, int port, int dbIndex, String password, int timeout, GenericObjectPoolConfig poolConfig) {
        ConnectionSpec connectionSpec = DefaultConnectionSpec.newSpec((String)hostName, (int)port, (int)dbIndex, null);
        connectionSpec.setConnectionFlag(Connection.Flag.RELIABLE, Boolean.valueOf(false));
        if (StringUtils.hasLength((String)password)) {
            connectionSpec.setCredentials(password);
        }
        if (timeout > 0) {
            connectionSpec.setSocketProperty(Connection.Socket.Property.SO_TIMEOUT, Integer.valueOf(timeout));
        }
        this.internalPool = new GenericObjectPool((PooledObjectFactory)new JredisFactory(connectionSpec), poolConfig);
    }

    @Override
    public JRedis getResource() {
        try {
            return (JRedis)this.internalPool.borrowObject();
        }
        catch (Exception e) {
            throw new PoolException("Could not get a resource from the pool", e);
        }
    }

    @Override
    public void returnBrokenResource(JRedis resource) {
        try {
            this.internalPool.invalidateObject((Object)resource);
        }
        catch (Exception e) {
            throw new PoolException("Could not invalidate the broken resource", e);
        }
    }

    @Override
    public void returnResource(JRedis resource) {
        try {
            this.internalPool.returnObject((Object)resource);
        }
        catch (Exception e) {
            throw new PoolException("Could not return the resource to the pool", e);
        }
    }

    @Override
    public void destroy() {
        try {
            this.internalPool.close();
        }
        catch (Exception e) {
            throw new PoolException("Could not destroy the pool", e);
        }
    }

    private static class JredisFactory
    extends BasePooledObjectFactory<JRedis> {
        private final ConnectionSpec connectionSpec;

        public JredisFactory(ConnectionSpec connectionSpec) {
            this.connectionSpec = connectionSpec;
        }

        public void destroyObject(PooledObject<JRedis> obj) throws Exception {
            try {
                ((JRedis)obj.getObject()).quit();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public boolean validateObject(PooledObject<JRedis> obj) {
            try {
                ((JRedis)obj.getObject()).ping();
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }

        public JRedis create() throws Exception {
            return new JRedisClient(this.connectionSpec);
        }

        public PooledObject<JRedis> wrap(JRedis obj) {
            return new DefaultPooledObject((Object)obj);
        }
    }
}

