/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.listener;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.SmartLifecycle;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.core.task.TaskExecutor;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.Subscription;
import org.springframework.data.redis.connection.util.ByteArrayWrapper;
import org.springframework.data.redis.listener.ChannelTopic;
import org.springframework.data.redis.listener.PatternTopic;
import org.springframework.data.redis.listener.Topic;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.scheduling.SchedulingAwareRunnable;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ErrorHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RedisMessageListenerContainer
implements InitializingBean,
DisposableBean,
BeanNameAware,
SmartLifecycle {
    protected final Log logger = LogFactory.getLog(this.getClass());
    public static final String DEFAULT_THREAD_NAME_PREFIX = ClassUtils.getShortName(RedisMessageListenerContainer.class) + "-";
    private long initWait = TimeUnit.SECONDS.toMillis(5L);
    private Executor subscriptionExecutor;
    private Executor taskExecutor;
    private RedisConnectionFactory connectionFactory;
    private String beanName;
    private ErrorHandler errorHandler;
    private final Object monitor = new Object();
    private volatile boolean running = false;
    private volatile boolean initialized = false;
    private volatile boolean listening = false;
    private volatile boolean manageExecutor = false;
    private final Map<ByteArrayWrapper, Collection<MessageListener>> patternMapping = new ConcurrentHashMap<ByteArrayWrapper, Collection<MessageListener>>();
    private final Map<ByteArrayWrapper, Collection<MessageListener>> channelMapping = new ConcurrentHashMap<ByteArrayWrapper, Collection<MessageListener>>();
    private final SubscriptionTask subscriptionTask = new SubscriptionTask();
    private volatile RedisSerializer<String> serializer = new StringRedisSerializer();

    public void afterPropertiesSet() {
        if (this.taskExecutor == null) {
            this.manageExecutor = true;
            this.taskExecutor = this.createDefaultTaskExecutor();
        }
        if (this.subscriptionExecutor == null) {
            this.subscriptionExecutor = this.taskExecutor;
        }
        this.initialized = true;
    }

    protected TaskExecutor createDefaultTaskExecutor() {
        String threadNamePrefix = this.beanName != null ? this.beanName + "-" : DEFAULT_THREAD_NAME_PREFIX;
        return new SimpleAsyncTaskExecutor(threadNamePrefix);
    }

    public void destroy() throws Exception {
        this.initialized = false;
        this.stop();
        if (this.manageExecutor && this.taskExecutor instanceof DisposableBean) {
            ((DisposableBean)this.taskExecutor).destroy();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Stopped internally-managed task executor");
            }
        }
    }

    public boolean isAutoStartup() {
        return true;
    }

    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }

    public int getPhase() {
        return Integer.MAX_VALUE;
    }

    public boolean isRunning() {
        return this.running;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (!this.running) {
            this.running = true;
            Object object = this.monitor;
            synchronized (object) {
                this.lazyListen();
                try {
                    this.monitor.wait(this.initWait);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Started RedisMessageListenerContainer");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this.isRunning()) {
            this.running = false;
            Object object = this.monitor;
            synchronized (object) {
                boolean shouldWait = this.listening;
                this.subscriptionTask.cancel();
                if (shouldWait) {
                    try {
                        this.monitor.wait(this.initWait);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Stopped RedisMessageListenerContainer");
        }
    }

    protected void processMessage(MessageListener listener, Message message, byte[] pattern) {
        this.executeListener(listener, message, pattern);
    }

    protected void executeListener(MessageListener listener, Message message, byte[] pattern) {
        try {
            listener.onMessage(message, pattern);
        }
        catch (Throwable ex) {
            this.handleListenerException(ex);
        }
    }

    public final boolean isActive() {
        return this.initialized;
    }

    protected void handleListenerException(Throwable ex) {
        if (this.isActive()) {
            this.invokeErrorHandler(ex);
        } else {
            this.logger.debug((Object)"Listener exception after container shutdown", ex);
        }
    }

    protected void invokeErrorHandler(Throwable ex) {
        if (this.errorHandler != null) {
            this.errorHandler.handleError(ex);
        } else if (this.logger.isWarnEnabled()) {
            this.logger.warn((Object)"Execution of JMS message listener failed, and no ErrorHandler has been set.", ex);
        }
    }

    public RedisConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(RedisConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public void setTaskExecutor(Executor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    public void setSubscriptionExecutor(Executor subscriptionExecutor) {
        this.subscriptionExecutor = subscriptionExecutor;
    }

    public void setTopicSerializer(RedisSerializer<String> serializer) {
        this.serializer = serializer;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void setMessageListeners(Map<? extends MessageListener, Collection<? extends Topic>> listeners) {
        this.initMapping(listeners);
    }

    public void addMessageListener(MessageListener listener, Collection<? extends Topic> topics) {
        this.addListener(listener, topics);
        this.lazyListen();
    }

    public void addMessageListener(MessageListener listener, Topic topic) {
        this.addMessageListener(listener, Collections.singleton(topic));
    }

    private void initMapping(Map<? extends MessageListener, Collection<? extends Topic>> listeners) {
        if (this.isRunning()) {
            this.stop();
        }
        this.patternMapping.clear();
        this.channelMapping.clear();
        if (!CollectionUtils.isEmpty(listeners)) {
            for (Map.Entry<? extends MessageListener, Collection<? extends Topic>> entry : listeners.entrySet()) {
                this.addListener(entry.getKey(), entry.getValue());
            }
        }
        if (this.initialized) {
            this.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lazyListen() {
        boolean debug = this.logger.isDebugEnabled();
        boolean started = false;
        if (this.isRunning() && !this.listening) {
            Object object = this.monitor;
            synchronized (object) {
                if (!(this.listening || this.channelMapping.size() <= 0 && this.patternMapping.size() <= 0)) {
                    this.subscriptionExecutor.execute((Runnable)((Object)this.subscriptionTask));
                    this.listening = true;
                    started = true;
                }
            }
            if (debug) {
                if (started) {
                    this.logger.debug((Object)"Started listening for Redis messages");
                } else {
                    this.logger.debug((Object)"Postpone listening for Redis messages until actual listeners are added");
                }
            }
        }
    }

    private void addListener(MessageListener listener, Collection<? extends Topic> topics) {
        ArrayList<byte[]> channels = new ArrayList<byte[]>(topics.size());
        ArrayList<byte[]> patterns = new ArrayList<byte[]>(topics.size());
        boolean trace = this.logger.isTraceEnabled();
        for (Topic topic : topics) {
            Collection<MessageListener> collection;
            ByteArrayWrapper holder = new ByteArrayWrapper(this.serializer.serialize(topic.getTopic()));
            if (topic instanceof ChannelTopic) {
                collection = this.channelMapping.get(holder);
                if (collection == null) {
                    collection = new CopyOnWriteArraySet<MessageListener>();
                    this.channelMapping.put(holder, collection);
                }
                collection.add(listener);
                channels.add(holder.getArray());
                if (!trace) continue;
                this.logger.trace((Object)("Adding listener '" + listener + "' on channel '" + topic.getTopic() + "'"));
                continue;
            }
            if (topic instanceof PatternTopic) {
                collection = this.patternMapping.get(holder);
                if (collection == null) {
                    collection = new CopyOnWriteArraySet<MessageListener>();
                    this.patternMapping.put(holder, collection);
                }
                collection.add(listener);
                patterns.add(holder.getArray());
                if (!trace) continue;
                this.logger.trace((Object)("Adding listener '" + listener + "' for pattern '" + topic.getTopic() + "'"));
                continue;
            }
            throw new IllegalArgumentException("Unknown topic type '" + topic.getClass() + "'");
        }
        if (this.listening) {
            this.subscriptionTask.subscribeChannel((byte[][])channels.toArray((T[])new byte[channels.size()][]));
            this.subscriptionTask.subscribePattern((byte[][])patterns.toArray((T[])new byte[patterns.size()][]));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DispatchMessageListener
    implements MessageListener {
        private DispatchMessageListener() {
        }

        @Override
        public void onMessage(Message message, byte[] pattern) {
            byte[] channel = message.getChannel();
            Collection ch = (Collection)RedisMessageListenerContainer.this.channelMapping.get(new ByteArrayWrapper(channel));
            Collection pt = null;
            if (pattern != null && pattern.length > 0) {
                pt = (Collection)RedisMessageListenerContainer.this.patternMapping.get(new ByteArrayWrapper(pattern));
            }
            if (!CollectionUtils.isEmpty((Collection)ch)) {
                this.dispatchChannels(ch, message);
            }
            if (!CollectionUtils.isEmpty(pt)) {
                this.dispatchPatterns(pt, message, pattern);
            }
        }

        private void dispatchChannels(Collection<MessageListener> ch, final Message message) {
            for (final MessageListener messageListener : ch) {
                RedisMessageListenerContainer.this.taskExecutor.execute(new Runnable(){

                    public void run() {
                        RedisMessageListenerContainer.this.processMessage(messageListener, message, null);
                    }
                });
            }
        }

        private void dispatchPatterns(Collection<MessageListener> pt, final Message message, final byte[] pattern) {
            for (final MessageListener messageListener : pt) {
                RedisMessageListenerContainer.this.taskExecutor.execute(new Runnable(){

                    public void run() {
                        RedisMessageListenerContainer.this.processMessage(messageListener, message, (byte[])pattern.clone());
                    }
                });
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SubscriptionTask
    implements SchedulingAwareRunnable {
        private volatile RedisConnection connection;
        private final Object localMonitor = new Object();

        private SubscriptionTask() {
        }

        public boolean isLongLived() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object;
            this.connection = RedisMessageListenerContainer.this.connectionFactory.getConnection();
            try {
                if (this.connection.isSubscribed()) {
                    throw new IllegalStateException("Retrieved connection is already subscribed; aborting listening");
                }
                object = RedisMessageListenerContainer.this.monitor;
                synchronized (object) {
                    RedisMessageListenerContainer.this.monitor.notify();
                }
                if (!RedisMessageListenerContainer.this.channelMapping.isEmpty()) {
                    if (!RedisMessageListenerContainer.this.patternMapping.isEmpty()) {
                        RedisMessageListenerContainer.this.subscriptionExecutor.execute((Runnable)((Object)new PatternSubscriptionTask()));
                    }
                    this.connection.subscribe(new DispatchMessageListener(), this.unwrap(RedisMessageListenerContainer.this.channelMapping.keySet()));
                } else {
                    this.connection.pSubscribe(new DispatchMessageListener(), this.unwrap(RedisMessageListenerContainer.this.patternMapping.keySet()));
                }
            }
            finally {
                RedisMessageListenerContainer.this.listening = false;
                if (this.connection != null) {
                    object = this.localMonitor;
                    synchronized (object) {
                        if (this.connection != null) {
                            this.connection.close();
                            this.connection = null;
                        }
                    }
                }
                object = RedisMessageListenerContainer.this.monitor;
                synchronized (object) {
                    RedisMessageListenerContainer.this.monitor.notify();
                }
            }
        }

        private byte[][] unwrap(Collection<ByteArrayWrapper> holders) {
            if (CollectionUtils.isEmpty(holders)) {
                return new byte[0][];
            }
            byte[][] unwrapped = new byte[holders.size()][];
            int index = 0;
            for (ByteArrayWrapper arrayHolder : holders) {
                unwrapped[index++] = arrayHolder.getArray();
            }
            return unwrapped;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void cancel() {
            if (this.connection != null) {
                Object object = this.localMonitor;
                synchronized (object) {
                    Subscription sub;
                    if (this.connection != null && (sub = this.connection.getSubscription()) != null) {
                        sub.pUnsubscribe();
                        sub.unsubscribe();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void subscribeChannel(byte[] ... channels) {
            if (channels != null && channels.length > 0 && this.connection != null) {
                Object object = this.localMonitor;
                synchronized (object) {
                    Subscription sub;
                    if (this.connection != null && (sub = this.connection.getSubscription()) != null) {
                        sub.subscribe(channels);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void subscribePattern(byte[] ... patterns) {
            if (patterns != null && patterns.length > 0 && this.connection != null) {
                Object object = this.localMonitor;
                synchronized (object) {
                    Subscription sub;
                    if (this.connection != null && (sub = this.connection.getSubscription()) != null) {
                        sub.pSubscribe(patterns);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void unsubscribeChannel(byte[] ... channels) {
            if (channels != null && channels.length > 0 && this.connection != null) {
                Object object = this.localMonitor;
                synchronized (object) {
                    Subscription sub;
                    if (this.connection != null && (sub = this.connection.getSubscription()) != null) {
                        sub.unsubscribe(channels);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void unsubscribePattern(byte[] ... patterns) {
            if (patterns != null && patterns.length > 0 && this.connection != null) {
                Object object = this.localMonitor;
                synchronized (object) {
                    Subscription sub;
                    if (this.connection != null && (sub = this.connection.getSubscription()) != null) {
                        sub.pUnsubscribe(patterns);
                    }
                }
            }
        }

        private class PatternSubscriptionTask
        implements SchedulingAwareRunnable {
            private long WAIT = 500L;
            private long ROUNDS = 3L;

            private PatternSubscriptionTask() {
            }

            public boolean isLongLived() {
                return false;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                boolean done = false;
                int i = 0;
                while ((long)i < this.ROUNDS || done) {
                    if (SubscriptionTask.this.connection != null) {
                        Object object = SubscriptionTask.this.localMonitor;
                        synchronized (object) {
                            if (SubscriptionTask.this.connection != null && SubscriptionTask.this.connection.isSubscribed()) {
                                done = true;
                                SubscriptionTask.this.connection.getSubscription().pSubscribe(SubscriptionTask.this.unwrap(RedisMessageListenerContainer.this.patternMapping.keySet()));
                            } else {
                                try {
                                    Thread.sleep(this.WAIT);
                                }
                                catch (InterruptedException ex) {
                                    done = true;
                                }
                            }
                        }
                    }
                    ++i;
                }
            }
        }
    }
}

