/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.jedis;

import java.io.IOException;
import java.io.StringReader;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.redis.RedisConnectionFailureException;
import org.springframework.data.redis.RedisSystemException;
import org.springframework.data.redis.connection.DefaultTuple;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.RedisListCommands;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.connection.SortParameters;
import org.springframework.data.redis.connection.jedis.JedisMessageListener;
import org.springframework.util.Assert;
import redis.clients.jedis.BinaryClient;
import redis.clients.jedis.BinaryJedisPubSub;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.SortingParams;
import redis.clients.jedis.Tuple;
import redis.clients.jedis.exceptions.JedisConnectionException;
import redis.clients.jedis.exceptions.JedisDataException;
import redis.clients.jedis.exceptions.JedisException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JedisUtils {
    private static final String OK_CODE = "OK";
    private static final String OK_MULTI_CODE = "+OK";
    private static final byte[] ONE = new byte[]{1};
    private static final byte[] ZERO = new byte[]{0};

    public static DataAccessException convertJedisAccessException(JedisException ex) {
        if (ex instanceof JedisDataException) {
            return new InvalidDataAccessApiUsageException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof JedisConnectionException) {
            return new RedisConnectionFailureException(ex.getMessage(), (Throwable)ex);
        }
        return new InvalidDataAccessApiUsageException(ex.getMessage(), (Throwable)ex);
    }

    public static DataAccessException convertJedisAccessException(RuntimeException ex) {
        if (ex instanceof JedisException) {
            return JedisUtils.convertJedisAccessException((JedisException)ex);
        }
        return new RedisSystemException("Unknown exception", ex);
    }

    static DataAccessException convertJedisAccessException(IOException ex) {
        if (ex instanceof UnknownHostException) {
            return new RedisConnectionFailureException("Unknown host " + ex.getMessage(), ex);
        }
        return new RedisConnectionFailureException("Could not connect to Redis server", ex);
    }

    static DataAccessException convertJedisAccessException(TimeoutException ex) {
        throw new RedisConnectionFailureException("Jedis pool timed out. Could not get Redis Connection", ex);
    }

    static boolean isStatusOk(String status) {
        return status != null && (OK_CODE.equals(status) || OK_MULTI_CODE.equals(status));
    }

    static Boolean convertCodeReply(Number code) {
        return code != null ? Boolean.valueOf(code.intValue() == 1) : null;
    }

    static Set<RedisZSetCommands.Tuple> convertJedisTuple(Set<Tuple> tuples) {
        LinkedHashSet<RedisZSetCommands.Tuple> value = new LinkedHashSet<RedisZSetCommands.Tuple>(tuples.size());
        for (Tuple tuple : tuples) {
            value.add(new DefaultTuple(tuple.getBinaryElement(), tuple.getScore()));
        }
        return value;
    }

    static byte[][] convert(Map<byte[], byte[]> hgetAll) {
        byte[][] result = new byte[hgetAll.size() * 2][];
        int index = 0;
        for (Map.Entry<byte[], byte[]> entry : hgetAll.entrySet()) {
            result[index++] = entry.getKey();
            result[index++] = entry.getValue();
        }
        return result;
    }

    static Map<String, String> convert(String[] fields, String[] values) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(fields.length);
        for (int i = 0; i < values.length; ++i) {
            result.put(fields[i], values[i]);
        }
        return result;
    }

    static String[] arrange(String[] keys, String[] values) {
        String[] result = new String[keys.length * 2];
        for (int i = 0; i < keys.length; ++i) {
            int index = i << 1;
            result[index] = keys[i];
            result[index + 1] = values[i];
        }
        return result;
    }

    static SortingParams convertSortParams(SortParameters params) {
        SortingParams jedisParams = null;
        if (params != null) {
            Boolean isAlpha;
            SortParameters.Order order;
            SortParameters.Range limit;
            byte[][] getPattern;
            jedisParams = new SortingParams();
            byte[] byPattern = params.getByPattern();
            if (byPattern != null) {
                jedisParams.by(params.getByPattern());
            }
            if ((getPattern = params.getGetPattern()) != null) {
                jedisParams.get(getPattern);
            }
            if ((limit = params.getLimit()) != null) {
                jedisParams.limit((int)limit.getStart(), (int)limit.getCount());
            }
            if ((order = params.getOrder()) != null && order.equals((Object)SortParameters.Order.DESC)) {
                jedisParams.desc();
            }
            if ((isAlpha = params.isAlphabetic()) != null && isAlpha.booleanValue()) {
                jedisParams.alpha();
            }
        }
        return jedisParams;
    }

    static byte[] asBit(boolean value) {
        return value ? ONE : ZERO;
    }

    static BinaryClient.LIST_POSITION convertPosition(RedisListCommands.Position where) {
        Assert.notNull((Object)"list positions are mandatory");
        return RedisListCommands.Position.AFTER.equals((Object)where) ? BinaryClient.LIST_POSITION.AFTER : BinaryClient.LIST_POSITION.BEFORE;
    }

    static Properties info(String string) {
        Properties info = new Properties();
        StringReader stringReader = new StringReader(string);
        try {
            info.load(stringReader);
        }
        catch (Exception ex) {
            throw new RedisSystemException("Cannot read Redis info", ex);
        }
        finally {
            stringReader.close();
        }
        return info;
    }

    static BinaryJedisPubSub adaptPubSub(MessageListener listener) {
        return new JedisMessageListener(listener);
    }

    static String[] convert(byte[] ... raw) {
        String[] result = new String[raw.length];
        for (int i = 0; i < raw.length; ++i) {
            result[i] = new String(raw[i]);
        }
        return result;
    }

    static byte[][] bXPopArgs(int timeout, byte[] ... keys) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        for (byte[] arg : keys) {
            args.add(arg);
        }
        args.add(Protocol.toByteArray((int)timeout));
        return (byte[][])args.toArray((T[])new byte[args.size()][]);
    }
}

