/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.BasicDBObject;
import com.mongodb.CommandResult;
import com.mongodb.Cursor;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.MapReduceCommand;
import com.mongodb.MapReduceOutput;
import com.mongodb.Mongo;
import com.mongodb.MongoException;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.WriteResult;
import com.mongodb.util.JSON;
import com.mongodb.util.JSONParseException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import org.bson.BSONObject;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.data.authentication.UserCredentials;
import org.springframework.data.convert.EntityReader;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.GeoResult;
import org.springframework.data.geo.GeoResults;
import org.springframework.data.geo.Metric;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.ConvertingPropertyAccessor;
import org.springframework.data.mapping.model.MappingException;
import org.springframework.data.mongodb.MongoDbFactory;
import org.springframework.data.mongodb.core.CollectionCallback;
import org.springframework.data.mongodb.core.CollectionOptions;
import org.springframework.data.mongodb.core.CursorPreparer;
import org.springframework.data.mongodb.core.DbCallback;
import org.springframework.data.mongodb.core.DefaultIndexOperations;
import org.springframework.data.mongodb.core.DefaultScriptOperations;
import org.springframework.data.mongodb.core.DocumentCallbackHandler;
import org.springframework.data.mongodb.core.FindAndModifyOptions;
import org.springframework.data.mongodb.core.GeoCommandStatistics;
import org.springframework.data.mongodb.core.IndexOperations;
import org.springframework.data.mongodb.core.MongoAction;
import org.springframework.data.mongodb.core.MongoActionOperation;
import org.springframework.data.mongodb.core.MongoDataIntegrityViolationException;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.ReflectiveDbInvoker;
import org.springframework.data.mongodb.core.ReflectiveMapReduceInvoker;
import org.springframework.data.mongodb.core.ReflectiveWriteResultInvoker;
import org.springframework.data.mongodb.core.ScriptOperations;
import org.springframework.data.mongodb.core.SimpleMongoDbFactory;
import org.springframework.data.mongodb.core.WriteConcernResolver;
import org.springframework.data.mongodb.core.WriteResultChecking;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.aggregation.TypeBasedAggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.TypedAggregation;
import org.springframework.data.mongodb.core.convert.DefaultDbRefResolver;
import org.springframework.data.mongodb.core.convert.MappingMongoConverter;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.convert.MongoWriter;
import org.springframework.data.mongodb.core.convert.QueryMapper;
import org.springframework.data.mongodb.core.convert.UpdateMapper;
import org.springframework.data.mongodb.core.index.MongoMappingEventPublisher;
import org.springframework.data.mongodb.core.index.MongoPersistentEntityIndexCreator;
import org.springframework.data.mongodb.core.mapping.MongoMappingContext;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.mongodb.core.mapping.MongoSimpleTypes;
import org.springframework.data.mongodb.core.mapping.event.AfterConvertEvent;
import org.springframework.data.mongodb.core.mapping.event.AfterDeleteEvent;
import org.springframework.data.mongodb.core.mapping.event.AfterLoadEvent;
import org.springframework.data.mongodb.core.mapping.event.AfterSaveEvent;
import org.springframework.data.mongodb.core.mapping.event.BeforeConvertEvent;
import org.springframework.data.mongodb.core.mapping.event.BeforeDeleteEvent;
import org.springframework.data.mongodb.core.mapping.event.BeforeSaveEvent;
import org.springframework.data.mongodb.core.mapping.event.MongoMappingEvent;
import org.springframework.data.mongodb.core.mapreduce.GroupBy;
import org.springframework.data.mongodb.core.mapreduce.GroupByResults;
import org.springframework.data.mongodb.core.mapreduce.MapReduceOptions;
import org.springframework.data.mongodb.core.mapreduce.MapReduceResults;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.NearQuery;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.SerializationUtils;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.util.MongoClientVersion;
import org.springframework.data.util.CloseableIterator;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ResourceUtils;
import org.springframework.util.StringUtils;

public class MongoTemplate
implements MongoOperations,
ApplicationContextAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoTemplate.class);
    private static final String ID_FIELD = "_id";
    private static final WriteResultChecking DEFAULT_WRITE_RESULT_CHECKING = WriteResultChecking.NONE;
    private static final Collection<String> ITERABLE_CLASSES;
    private final MongoConverter mongoConverter;
    private final MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext;
    private final MongoDbFactory mongoDbFactory;
    private final PersistenceExceptionTranslator exceptionTranslator;
    private final QueryMapper queryMapper;
    private final UpdateMapper updateMapper;
    private WriteConcern writeConcern;
    private WriteConcernResolver writeConcernResolver = DefaultWriteConcernResolver.INSTANCE;
    private WriteResultChecking writeResultChecking = WriteResultChecking.NONE;
    private ReadPreference readPreference;
    private ApplicationEventPublisher eventPublisher;
    private ResourceLoader resourceLoader;
    private MongoPersistentEntityIndexCreator indexCreator;

    public MongoTemplate(Mongo mongo, String databaseName) {
        this(new SimpleMongoDbFactory(mongo, databaseName), null);
    }

    public MongoTemplate(Mongo mongo, String databaseName, UserCredentials userCredentials) {
        this(new SimpleMongoDbFactory(mongo, databaseName, userCredentials));
    }

    public MongoTemplate(MongoDbFactory mongoDbFactory) {
        this(mongoDbFactory, null);
    }

    public MongoTemplate(MongoDbFactory mongoDbFactory, MongoConverter mongoConverter) {
        Assert.notNull((Object)mongoDbFactory);
        this.mongoDbFactory = mongoDbFactory;
        this.exceptionTranslator = mongoDbFactory.getExceptionTranslator();
        this.mongoConverter = mongoConverter == null ? MongoTemplate.getDefaultMongoConverter(mongoDbFactory) : mongoConverter;
        this.queryMapper = new QueryMapper(this.mongoConverter);
        this.updateMapper = new UpdateMapper(this.mongoConverter);
        this.mappingContext = this.mongoConverter.getMappingContext();
        if (null != this.mappingContext && this.mappingContext instanceof MongoMappingContext) {
            this.indexCreator = new MongoPersistentEntityIndexCreator((MongoMappingContext)this.mappingContext, mongoDbFactory);
            this.eventPublisher = new MongoMappingEventPublisher(this.indexCreator);
            if (this.mappingContext instanceof ApplicationEventPublisherAware) {
                ((ApplicationEventPublisherAware)this.mappingContext).setApplicationEventPublisher(this.eventPublisher);
            }
        }
    }

    public void setWriteResultChecking(WriteResultChecking resultChecking) {
        this.writeResultChecking = resultChecking == null ? DEFAULT_WRITE_RESULT_CHECKING : resultChecking;
    }

    public void setWriteConcern(WriteConcern writeConcern) {
        this.writeConcern = writeConcern;
    }

    public void setWriteConcernResolver(WriteConcernResolver writeConcernResolver) {
        this.writeConcernResolver = writeConcernResolver;
    }

    public void setReadPreference(ReadPreference readPreference) {
        this.readPreference = readPreference;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.prepareIndexCreator(applicationContext);
        this.eventPublisher = applicationContext;
        if (this.mappingContext instanceof ApplicationEventPublisherAware) {
            ((ApplicationEventPublisherAware)this.mappingContext).setApplicationEventPublisher(this.eventPublisher);
        }
        this.resourceLoader = applicationContext;
    }

    private void prepareIndexCreator(ApplicationContext context) {
        String[] indexCreators;
        for (String creator : indexCreators = context.getBeanNamesForType(MongoPersistentEntityIndexCreator.class)) {
            MongoPersistentEntityIndexCreator creatorBean = (MongoPersistentEntityIndexCreator)context.getBean(creator, MongoPersistentEntityIndexCreator.class);
            if (!creatorBean.isIndexCreatorFor(this.mappingContext)) continue;
            return;
        }
        if (context instanceof ConfigurableApplicationContext) {
            ((ConfigurableApplicationContext)context).addApplicationListener((ApplicationListener)this.indexCreator);
        }
    }

    @Override
    public MongoConverter getConverter() {
        return this.mongoConverter;
    }

    @Override
    public <T> CloseableIterator<T> stream(final Query query, final Class<T> entityType) {
        return (CloseableIterator)this.execute(entityType, new CollectionCallback<CloseableIterator<T>>(){

            @Override
            public CloseableIterator<T> doInCollection(DBCollection collection) throws MongoException, DataAccessException {
                MongoPersistentEntity persistentEntity = (MongoPersistentEntity)MongoTemplate.this.mappingContext.getPersistentEntity(entityType);
                DBObject mappedFields = MongoTemplate.this.queryMapper.getMappedFields(query.getFieldsObject(), persistentEntity);
                DBObject mappedQuery = MongoTemplate.this.queryMapper.getMappedObject(query.getQueryObject(), persistentEntity);
                DBCursor cursor = collection.find(mappedQuery, mappedFields);
                QueryCursorPreparer cursorPreparer = new QueryCursorPreparer(query, entityType);
                ReadDbObjectCallback<Object> readCallback = new ReadDbObjectCallback<Object>(MongoTemplate.this.mongoConverter, entityType, collection.getName());
                return new CloseableIterableCursorAdapter<Object>((Cursor)cursorPreparer.prepare(cursor), MongoTemplate.this.exceptionTranslator, readCallback);
            }
        });
    }

    @Override
    public String getCollectionName(Class<?> entityClass) {
        return this.determineCollectionName(entityClass);
    }

    @Override
    public CommandResult executeCommand(String jsonCommand) {
        return this.executeCommand((DBObject)JSON.parse((String)jsonCommand));
    }

    @Override
    public CommandResult executeCommand(final DBObject command) {
        CommandResult result = this.execute(new DbCallback<CommandResult>(){

            @Override
            public CommandResult doInDB(DB db) throws MongoException, DataAccessException {
                return db.command(command);
            }
        });
        this.logCommandExecutionError(command, result);
        return result;
    }

    @Override
    @Deprecated
    public CommandResult executeCommand(DBObject command, int options) {
        return this.executeCommand(command, (options & 4) != 0 ? ReadPreference.secondaryPreferred() : ReadPreference.primary());
    }

    @Override
    public CommandResult executeCommand(final DBObject command, final ReadPreference readPreference) {
        Assert.notNull((Object)command, (String)"Command must not be null!");
        CommandResult result = this.execute(new DbCallback<CommandResult>(){

            @Override
            public CommandResult doInDB(DB db) throws MongoException, DataAccessException {
                return readPreference != null ? db.command(command, readPreference) : db.command(command);
            }
        });
        this.logCommandExecutionError(command, result);
        return result;
    }

    protected void logCommandExecutionError(DBObject command, CommandResult result) {
        String error = result.getErrorMessage();
        if (error != null) {
            LOGGER.warn("Command execution of " + command.toString() + " failed: " + error);
        }
    }

    @Override
    public void executeQuery(Query query, String collectionName, DocumentCallbackHandler dch) {
        this.executeQuery(query, collectionName, dch, new QueryCursorPreparer(query, null));
    }

    protected void executeQuery(Query query, String collectionName, DocumentCallbackHandler dch, CursorPreparer preparer) {
        Assert.notNull((Object)query);
        DBObject queryObject = this.queryMapper.getMappedObject(query.getQueryObject(), null);
        DBObject sortObject = query.getSortObject();
        DBObject fieldsObject = query.getFieldsObject();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Executing query: %s sort: %s fields: %s in collection: %s", SerializationUtils.serializeToJsonSafely(queryObject), sortObject, fieldsObject, collectionName));
        }
        this.executeQueryInternal(new FindCallback(queryObject, fieldsObject), preparer, dch, collectionName);
    }

    @Override
    public <T> T execute(DbCallback<T> action) {
        Assert.notNull(action);
        try {
            DB db = this.getDb();
            return action.doInDB(db);
        }
        catch (RuntimeException e) {
            throw MongoTemplate.potentiallyConvertRuntimeException(e, this.exceptionTranslator);
        }
    }

    @Override
    public <T> T execute(Class<?> entityClass, CollectionCallback<T> callback) {
        return this.execute(this.determineCollectionName(entityClass), callback);
    }

    @Override
    public <T> T execute(String collectionName, CollectionCallback<T> callback) {
        Assert.notNull(callback);
        try {
            DBCollection collection = this.getAndPrepareCollection(this.getDb(), collectionName);
            return callback.doInCollection(collection);
        }
        catch (RuntimeException e) {
            throw MongoTemplate.potentiallyConvertRuntimeException(e, this.exceptionTranslator);
        }
    }

    @Override
    @Deprecated
    public <T> T executeInSession(final DbCallback<T> action) {
        return this.execute(new DbCallback<T>(){

            @Override
            public T doInDB(DB db) throws MongoException, DataAccessException {
                try {
                    ReflectiveDbInvoker.requestStart(db);
                    Object t = action.doInDB(db);
                    return t;
                }
                finally {
                    ReflectiveDbInvoker.requestDone(db);
                }
            }
        });
    }

    @Override
    public <T> DBCollection createCollection(Class<T> entityClass) {
        return this.createCollection(this.determineCollectionName(entityClass));
    }

    @Override
    public <T> DBCollection createCollection(Class<T> entityClass, CollectionOptions collectionOptions) {
        return this.createCollection(this.determineCollectionName(entityClass), collectionOptions);
    }

    @Override
    public DBCollection createCollection(String collectionName) {
        return this.doCreateCollection(collectionName, (DBObject)new BasicDBObject());
    }

    @Override
    public DBCollection createCollection(String collectionName, CollectionOptions collectionOptions) {
        return this.doCreateCollection(collectionName, this.convertToDbObject(collectionOptions));
    }

    @Override
    public DBCollection getCollection(final String collectionName) {
        return this.execute(new DbCallback<DBCollection>(){

            @Override
            public DBCollection doInDB(DB db) throws MongoException, DataAccessException {
                return db.getCollection(collectionName);
            }
        });
    }

    @Override
    public <T> boolean collectionExists(Class<T> entityClass) {
        return this.collectionExists(this.determineCollectionName(entityClass));
    }

    @Override
    public boolean collectionExists(final String collectionName) {
        return this.execute(new DbCallback<Boolean>(){

            @Override
            public Boolean doInDB(DB db) throws MongoException, DataAccessException {
                return db.collectionExists(collectionName);
            }
        });
    }

    @Override
    public <T> void dropCollection(Class<T> entityClass) {
        this.dropCollection(this.determineCollectionName(entityClass));
    }

    @Override
    public void dropCollection(String collectionName) {
        this.execute(collectionName, new CollectionCallback<Void>(){

            @Override
            public Void doInCollection(DBCollection collection) throws MongoException, DataAccessException {
                collection.drop();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Dropped collection [" + collection.getFullName() + "]");
                }
                return null;
            }
        });
    }

    @Override
    public IndexOperations indexOps(String collectionName) {
        return new DefaultIndexOperations(this, collectionName);
    }

    @Override
    public IndexOperations indexOps(Class<?> entityClass) {
        return new DefaultIndexOperations(this, this.determineCollectionName(entityClass));
    }

    @Override
    public ScriptOperations scriptOps() {
        return new DefaultScriptOperations(this);
    }

    @Override
    public <T> T findOne(Query query, Class<T> entityClass) {
        return this.findOne(query, entityClass, this.determineCollectionName(entityClass));
    }

    @Override
    public <T> T findOne(Query query, Class<T> entityClass, String collectionName) {
        if (query.getSortObject() == null) {
            return this.doFindOne(collectionName, query.getQueryObject(), query.getFieldsObject(), entityClass);
        }
        query.limit(1);
        List<T> results = this.find(query, entityClass, collectionName);
        return results.isEmpty() ? null : (T)results.get(0);
    }

    @Override
    public boolean exists(Query query, Class<?> entityClass) {
        return this.exists(query, entityClass, this.determineCollectionName(entityClass));
    }

    @Override
    public boolean exists(Query query, String collectionName) {
        return this.exists(query, null, collectionName);
    }

    @Override
    public boolean exists(Query query, Class<?> entityClass, String collectionName) {
        if (query == null) {
            throw new InvalidDataAccessApiUsageException("Query passed in to exist can't be null");
        }
        DBObject mappedQuery = this.queryMapper.getMappedObject(query.getQueryObject(), this.getPersistentEntity(entityClass));
        return this.execute(collectionName, new FindCallback(mappedQuery)).hasNext();
    }

    @Override
    public <T> List<T> find(Query query, Class<T> entityClass) {
        return this.find(query, entityClass, this.determineCollectionName(entityClass));
    }

    @Override
    public <T> List<T> find(Query query, Class<T> entityClass, String collectionName) {
        if (query == null) {
            return this.findAll(entityClass, collectionName);
        }
        return this.doFind(collectionName, query.getQueryObject(), query.getFieldsObject(), entityClass, new QueryCursorPreparer(query, entityClass));
    }

    @Override
    public <T> T findById(Object id, Class<T> entityClass) {
        return this.findById(id, entityClass, this.determineCollectionName(entityClass));
    }

    @Override
    public <T> T findById(Object id, Class<T> entityClass, String collectionName) {
        MongoPersistentEntity persistentEntity = (MongoPersistentEntity)this.mappingContext.getPersistentEntity(entityClass);
        MongoPersistentProperty idProperty = persistentEntity == null ? null : (MongoPersistentProperty)persistentEntity.getIdProperty();
        String idKey = idProperty == null ? ID_FIELD : idProperty.getName();
        return this.doFindOne(collectionName, (DBObject)new BasicDBObject(idKey, id), null, entityClass);
    }

    @Override
    public <T> GeoResults<T> geoNear(NearQuery near, Class<T> entityClass) {
        return this.geoNear(near, entityClass, this.determineCollectionName(entityClass));
    }

    @Override
    public <T> GeoResults<T> geoNear(NearQuery near, Class<T> entityClass, String collectionName) {
        CommandResult commandResult;
        List results;
        if (near == null) {
            throw new InvalidDataAccessApiUsageException("NearQuery must not be null!");
        }
        if (entityClass == null) {
            throw new InvalidDataAccessApiUsageException("Entity class must not be null!");
        }
        String collection = StringUtils.hasText((String)collectionName) ? collectionName : this.determineCollectionName(entityClass);
        DBObject nearDbObject = near.toDBObject();
        BasicDBObject command = new BasicDBObject("geoNear", (Object)collection);
        command.putAll((BSONObject)nearDbObject);
        if (nearDbObject.containsField("query")) {
            DBObject query = (DBObject)nearDbObject.get("query");
            command.put("query", (Object)this.queryMapper.getMappedObject(query, this.getPersistentEntity(entityClass)));
        }
        results = (results = (List)(commandResult = this.executeCommand((DBObject)command, this.readPreference)).get("results")) == null ? Collections.emptyList() : results;
        GeoNearResultDbObjectCallback<Object> callback = new GeoNearResultDbObjectCallback<Object>(new ReadDbObjectCallback<Object>(this.mongoConverter, entityClass, collectionName), near.getMetric());
        ArrayList result = new ArrayList(results.size());
        int index = 0;
        int elementsToSkip = near.getSkip() != null ? near.getSkip() : 0;
        for (Object element : results) {
            if (index >= elementsToSkip) {
                result.add(callback.doWith((DBObject)element));
            }
            ++index;
        }
        if (elementsToSkip > 0) {
            return new GeoResults(result, near.getMetric());
        }
        GeoCommandStatistics stats = GeoCommandStatistics.from((DBObject)commandResult);
        return new GeoResults(result, new Distance(stats.getAverageDistance(), near.getMetric()));
    }

    @Override
    public <T> T findAndModify(Query query, Update update, Class<T> entityClass) {
        return this.findAndModify(query, update, new FindAndModifyOptions(), entityClass, this.determineCollectionName(entityClass));
    }

    @Override
    public <T> T findAndModify(Query query, Update update, Class<T> entityClass, String collectionName) {
        return this.findAndModify(query, update, new FindAndModifyOptions(), entityClass, collectionName);
    }

    @Override
    public <T> T findAndModify(Query query, Update update, FindAndModifyOptions options, Class<T> entityClass) {
        return this.findAndModify(query, update, options, entityClass, this.determineCollectionName(entityClass));
    }

    @Override
    public <T> T findAndModify(Query query, Update update, FindAndModifyOptions options, Class<T> entityClass, String collectionName) {
        return this.doFindAndModify(collectionName, query.getQueryObject(), query.getFieldsObject(), this.getMappedSortObject(query, entityClass), entityClass, update, options);
    }

    @Override
    public <T> T findAndRemove(Query query, Class<T> entityClass) {
        return this.findAndRemove(query, entityClass, this.determineCollectionName(entityClass));
    }

    @Override
    public <T> T findAndRemove(Query query, Class<T> entityClass, String collectionName) {
        return this.doFindAndRemove(collectionName, query.getQueryObject(), query.getFieldsObject(), this.getMappedSortObject(query, entityClass), entityClass);
    }

    @Override
    public long count(Query query, Class<?> entityClass) {
        Assert.notNull(entityClass);
        return this.count(query, entityClass, this.determineCollectionName(entityClass));
    }

    @Override
    public long count(Query query, String collectionName) {
        return this.count(query, null, collectionName);
    }

    @Override
    public long count(Query query, Class<?> entityClass, String collectionName) {
        Assert.hasText((String)collectionName);
        final DBObject dbObject = query == null ? null : this.queryMapper.getMappedObject(query.getQueryObject(), entityClass == null ? null : (MongoPersistentEntity)this.mappingContext.getPersistentEntity(entityClass));
        return this.execute(collectionName, new CollectionCallback<Long>(){

            @Override
            public Long doInCollection(DBCollection collection) throws MongoException, DataAccessException {
                return collection.count(dbObject);
            }
        });
    }

    @Override
    public void insert(Object objectToSave) {
        this.ensureNotIterable(objectToSave);
        this.insert(objectToSave, this.determineEntityCollectionName(objectToSave));
    }

    @Override
    public void insert(Object objectToSave, String collectionName) {
        this.ensureNotIterable(objectToSave);
        this.doInsert(collectionName, objectToSave, this.mongoConverter);
    }

    protected void ensureNotIterable(Object o) {
        if (null != o && (o.getClass().isArray() || ITERABLE_CLASSES.contains(o.getClass().getName()))) {
            throw new IllegalArgumentException("Cannot use a collection here.");
        }
    }

    protected void prepareCollection(DBCollection collection) {
        if (this.readPreference != null) {
            collection.setReadPreference(this.readPreference);
        }
    }

    protected WriteConcern prepareWriteConcern(MongoAction mongoAction) {
        WriteConcern wc = this.writeConcernResolver.resolve(mongoAction);
        return this.potentiallyForceAcknowledgedWrite(wc);
    }

    private WriteConcern potentiallyForceAcknowledgedWrite(WriteConcern wc) {
        if (ObjectUtils.nullSafeEquals((Object)((Object)WriteResultChecking.EXCEPTION), (Object)((Object)this.writeResultChecking)) && MongoClientVersion.isMongo3Driver() && (wc == null || wc.getWObject() == null || wc.getWObject() instanceof Number && ((Number)wc.getWObject()).intValue() < 1)) {
            return WriteConcern.ACKNOWLEDGED;
        }
        return wc;
    }

    protected <T> void doInsert(String collectionName, T objectToSave, MongoWriter<T> writer) {
        this.assertUpdateableIdIfNotSet(objectToSave);
        this.initializeVersionProperty(objectToSave);
        this.maybeEmitEvent(new BeforeConvertEvent<T>(objectToSave, collectionName));
        DBObject dbDoc = this.toDbObject(objectToSave, writer);
        this.maybeEmitEvent(new BeforeSaveEvent<T>(objectToSave, dbDoc, collectionName));
        Object id = this.insertDBObject(collectionName, dbDoc, objectToSave.getClass());
        this.populateIdIfNecessary(objectToSave, id);
        this.maybeEmitEvent(new AfterSaveEvent<T>(objectToSave, dbDoc, collectionName));
    }

    private <T> DBObject toDbObject(T objectToSave, MongoWriter<T> writer) {
        if (!(objectToSave instanceof String)) {
            BasicDBObject dbDoc = new BasicDBObject();
            writer.write(objectToSave, dbDoc);
            return dbDoc;
        }
        try {
            return (DBObject)JSON.parse((String)((String)objectToSave));
        }
        catch (JSONParseException e) {
            throw new MappingException("Could not parse given String to save into a JSON document!", (Throwable)e);
        }
    }

    private void initializeVersionProperty(Object entity) {
        MongoPersistentEntity<?> mongoPersistentEntity = this.getPersistentEntity(entity.getClass());
        if (mongoPersistentEntity != null && mongoPersistentEntity.hasVersionProperty()) {
            ConvertingPropertyAccessor accessor = new ConvertingPropertyAccessor(mongoPersistentEntity.getPropertyAccessor(entity), this.mongoConverter.getConversionService());
            accessor.setProperty(mongoPersistentEntity.getVersionProperty(), (Object)0);
        }
    }

    @Override
    public void insert(Collection<? extends Object> batchToSave, Class<?> entityClass) {
        this.doInsertBatch(this.determineCollectionName(entityClass), batchToSave, this.mongoConverter);
    }

    @Override
    public void insert(Collection<? extends Object> batchToSave, String collectionName) {
        this.doInsertBatch(collectionName, batchToSave, this.mongoConverter);
    }

    @Override
    public void insertAll(Collection<? extends Object> objectsToSave) {
        this.doInsertAll(objectsToSave, this.mongoConverter);
    }

    protected <T> void doInsertAll(Collection<? extends T> listToSave, MongoWriter<T> writer) {
        HashMap<String, ArrayList<T>> elementsByCollection = new HashMap<String, ArrayList<T>>();
        for (T t : listToSave) {
            if (t == null) continue;
            MongoPersistentEntity entity = (MongoPersistentEntity)this.mappingContext.getPersistentEntity(t.getClass());
            if (entity == null) {
                throw new InvalidDataAccessApiUsageException("No PersistentEntity information found for " + t.getClass());
            }
            String collection = entity.getCollection();
            ArrayList<T> collectionElements = (ArrayList<T>)elementsByCollection.get(collection);
            if (null == collectionElements) {
                collectionElements = new ArrayList<T>();
                elementsByCollection.put(collection, collectionElements);
            }
            collectionElements.add(t);
        }
        for (Map.Entry entry : elementsByCollection.entrySet()) {
            this.doInsertBatch((String)entry.getKey(), (Collection)entry.getValue(), this.mongoConverter);
        }
    }

    protected <T> void doInsertBatch(String collectionName, Collection<? extends T> batchToSave, MongoWriter<T> writer) {
        Assert.notNull(writer);
        ArrayList<DBObject> dbObjectList = new ArrayList<DBObject>();
        for (T o : batchToSave) {
            this.initializeVersionProperty(o);
            BasicDBObject dbDoc = new BasicDBObject();
            this.maybeEmitEvent(new BeforeConvertEvent<T>(o, collectionName));
            writer.write(o, dbDoc);
            this.maybeEmitEvent(new BeforeSaveEvent<T>(o, (DBObject)dbDoc, collectionName));
            dbObjectList.add((DBObject)dbDoc);
        }
        List<ObjectId> ids = this.insertDBObjectList(collectionName, dbObjectList);
        int i = 0;
        for (T obj : batchToSave) {
            if (i < ids.size()) {
                this.populateIdIfNecessary(obj, ids.get(i));
                this.maybeEmitEvent(new AfterSaveEvent<T>(obj, (DBObject)dbObjectList.get(i), collectionName));
            }
            ++i;
        }
    }

    @Override
    public void save(Object objectToSave) {
        Assert.notNull((Object)objectToSave);
        this.save(objectToSave, this.determineEntityCollectionName(objectToSave));
    }

    @Override
    public void save(Object objectToSave, String collectionName) {
        Assert.notNull((Object)objectToSave);
        Assert.hasText((String)collectionName);
        MongoPersistentEntity<?> mongoPersistentEntity = this.getPersistentEntity(objectToSave.getClass());
        if (mongoPersistentEntity == null || !mongoPersistentEntity.hasVersionProperty()) {
            this.doSave(collectionName, objectToSave, this.mongoConverter);
            return;
        }
        this.doSaveVersioned(objectToSave, mongoPersistentEntity, collectionName);
    }

    private <T> void doSaveVersioned(T objectToSave, MongoPersistentEntity<?> entity, String collectionName) {
        ConvertingPropertyAccessor convertingAccessor = new ConvertingPropertyAccessor(entity.getPropertyAccessor(objectToSave), this.mongoConverter.getConversionService());
        MongoPersistentProperty idProperty = (MongoPersistentProperty)entity.getIdProperty();
        MongoPersistentProperty versionProperty = (MongoPersistentProperty)entity.getVersionProperty();
        Object version = convertingAccessor.getProperty((PersistentProperty)versionProperty);
        Number versionNumber = (Number)convertingAccessor.getProperty((PersistentProperty)versionProperty, Number.class);
        if (version == null) {
            this.doInsert(collectionName, objectToSave, this.mongoConverter);
        } else {
            this.assertUpdateableIdIfNotSet(objectToSave);
            Object id = convertingAccessor.getProperty((PersistentProperty)idProperty);
            Query query = new Query(Criteria.where(idProperty.getName()).is(id).and(versionProperty.getName()).is(version));
            convertingAccessor.setProperty((PersistentProperty)versionProperty, (Object)(versionNumber.longValue() + 1L));
            BasicDBObject dbObject = new BasicDBObject();
            this.maybeEmitEvent(new BeforeConvertEvent<T>(objectToSave, collectionName));
            this.mongoConverter.write(objectToSave, dbObject);
            this.maybeEmitEvent(new BeforeSaveEvent<T>(objectToSave, (DBObject)dbObject, collectionName));
            Update update = Update.fromDBObject((DBObject)dbObject, ID_FIELD);
            this.doUpdate(collectionName, query, update, objectToSave.getClass(), false, false);
            this.maybeEmitEvent(new AfterSaveEvent<T>(objectToSave, (DBObject)dbObject, collectionName));
        }
    }

    protected <T> void doSave(String collectionName, T objectToSave, MongoWriter<T> writer) {
        this.assertUpdateableIdIfNotSet(objectToSave);
        this.maybeEmitEvent(new BeforeConvertEvent<T>(objectToSave, collectionName));
        DBObject dbDoc = this.toDbObject(objectToSave, writer);
        this.maybeEmitEvent(new BeforeSaveEvent<T>(objectToSave, dbDoc, collectionName));
        Object id = this.saveDBObject(collectionName, dbDoc, objectToSave.getClass());
        this.populateIdIfNecessary(objectToSave, id);
        this.maybeEmitEvent(new AfterSaveEvent<T>(objectToSave, dbDoc, collectionName));
    }

    protected Object insertDBObject(final String collectionName, final DBObject dbDoc, final Class<?> entityClass) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Inserting DBObject containing fields: " + dbDoc.keySet() + " in collection: " + collectionName);
        }
        return this.execute(collectionName, new CollectionCallback<Object>(){

            @Override
            public Object doInCollection(DBCollection collection) throws MongoException, DataAccessException {
                MongoAction mongoAction = new MongoAction(MongoTemplate.this.writeConcern, MongoActionOperation.INSERT, collectionName, entityClass, dbDoc, null);
                WriteConcern writeConcernToUse = MongoTemplate.this.prepareWriteConcern(mongoAction);
                WriteResult writeResult = writeConcernToUse == null ? collection.insert(new DBObject[]{dbDoc}) : collection.insert(dbDoc, writeConcernToUse);
                MongoTemplate.this.handleAnyWriteResultErrors(writeResult, dbDoc, MongoActionOperation.INSERT);
                return dbDoc.get(MongoTemplate.ID_FIELD);
            }
        });
    }

    protected List<ObjectId> insertDBObjectList(final String collectionName, final List<DBObject> dbDocList) {
        if (dbDocList.isEmpty()) {
            return Collections.emptyList();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Inserting list of DBObjects containing " + dbDocList.size() + " items");
        }
        this.execute(collectionName, new CollectionCallback<Void>(){

            @Override
            public Void doInCollection(DBCollection collection) throws MongoException, DataAccessException {
                MongoAction mongoAction = new MongoAction(MongoTemplate.this.writeConcern, MongoActionOperation.INSERT_LIST, collectionName, null, null, null);
                WriteConcern writeConcernToUse = MongoTemplate.this.prepareWriteConcern(mongoAction);
                WriteResult writeResult = writeConcernToUse == null ? collection.insert(dbDocList) : collection.insert(dbDocList.toArray((DBObject[])new BasicDBObject[dbDocList.size()]), writeConcernToUse);
                MongoTemplate.this.handleAnyWriteResultErrors(writeResult, null, MongoActionOperation.INSERT_LIST);
                return null;
            }
        });
        ArrayList<ObjectId> ids = new ArrayList<ObjectId>();
        for (DBObject dbo : dbDocList) {
            Object id = dbo.get(ID_FIELD);
            if (id instanceof ObjectId) {
                ids.add((ObjectId)id);
                continue;
            }
            ids.add(null);
        }
        return ids;
    }

    protected Object saveDBObject(final String collectionName, final DBObject dbDoc, final Class<?> entityClass) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Saving DBObject containing fields: " + dbDoc.keySet());
        }
        return this.execute(collectionName, new CollectionCallback<Object>(){

            @Override
            public Object doInCollection(DBCollection collection) throws MongoException, DataAccessException {
                MongoAction mongoAction = new MongoAction(MongoTemplate.this.writeConcern, MongoActionOperation.SAVE, collectionName, entityClass, dbDoc, null);
                WriteConcern writeConcernToUse = MongoTemplate.this.prepareWriteConcern(mongoAction);
                WriteResult writeResult = writeConcernToUse == null ? collection.save(dbDoc) : collection.save(dbDoc, writeConcernToUse);
                MongoTemplate.this.handleAnyWriteResultErrors(writeResult, dbDoc, MongoActionOperation.SAVE);
                return dbDoc.get(MongoTemplate.ID_FIELD);
            }
        });
    }

    @Override
    public WriteResult upsert(Query query, Update update, Class<?> entityClass) {
        return this.doUpdate(this.determineCollectionName(entityClass), query, update, entityClass, true, false);
    }

    @Override
    public WriteResult upsert(Query query, Update update, String collectionName) {
        return this.doUpdate(collectionName, query, update, null, true, false);
    }

    @Override
    public WriteResult upsert(Query query, Update update, Class<?> entityClass, String collectionName) {
        return this.doUpdate(collectionName, query, update, entityClass, true, false);
    }

    @Override
    public WriteResult updateFirst(Query query, Update update, Class<?> entityClass) {
        return this.doUpdate(this.determineCollectionName(entityClass), query, update, entityClass, false, false);
    }

    @Override
    public WriteResult updateFirst(Query query, Update update, String collectionName) {
        return this.doUpdate(collectionName, query, update, null, false, false);
    }

    @Override
    public WriteResult updateFirst(Query query, Update update, Class<?> entityClass, String collectionName) {
        return this.doUpdate(collectionName, query, update, entityClass, false, false);
    }

    @Override
    public WriteResult updateMulti(Query query, Update update, Class<?> entityClass) {
        return this.doUpdate(this.determineCollectionName(entityClass), query, update, entityClass, false, true);
    }

    @Override
    public WriteResult updateMulti(Query query, Update update, String collectionName) {
        return this.doUpdate(collectionName, query, update, null, false, true);
    }

    @Override
    public WriteResult updateMulti(Query query, Update update, Class<?> entityClass, String collectionName) {
        return this.doUpdate(collectionName, query, update, entityClass, false, true);
    }

    protected WriteResult doUpdate(final String collectionName, final Query query, final Update update, final Class<?> entityClass, final boolean upsert, final boolean multi) {
        return this.execute(collectionName, new CollectionCallback<WriteResult>(){

            @Override
            public WriteResult doInCollection(DBCollection collection) throws MongoException, DataAccessException {
                MongoAction mongoAction;
                WriteConcern writeConcernToUse;
                WriteResult writeResult;
                BasicDBObject updateObj;
                MongoPersistentEntity entity = entityClass == null ? null : MongoTemplate.this.getPersistentEntity(entityClass);
                MongoTemplate.this.increaseVersionForUpdateIfNecessary(entity, update);
                BasicDBObject queryObj = query == null ? new BasicDBObject() : MongoTemplate.this.queryMapper.getMappedObject(query.getQueryObject(), entity);
                Object object = updateObj = update == null ? new BasicDBObject() : MongoTemplate.this.updateMapper.getMappedObject(update.getUpdateObject(), entity);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(String.format("Calling update using query: %s and update: %s in collection: %s", SerializationUtils.serializeToJsonSafely(queryObj), SerializationUtils.serializeToJsonSafely(updateObj), collectionName));
                }
                WriteResult writeResult2 = writeResult = (writeConcernToUse = MongoTemplate.this.prepareWriteConcern(mongoAction = new MongoAction(MongoTemplate.this.writeConcern, MongoActionOperation.UPDATE, collectionName, entityClass, (DBObject)updateObj, (DBObject)queryObj))) == null ? collection.update((DBObject)queryObj, (DBObject)updateObj, upsert, multi) : collection.update((DBObject)queryObj, (DBObject)updateObj, upsert, multi, writeConcernToUse);
                if (entity != null && entity.hasVersionProperty() && !multi && ReflectiveWriteResultInvoker.wasAcknowledged(writeResult) && writeResult.getN() == 0 && MongoTemplate.this.dbObjectContainsVersionProperty((DBObject)queryObj, entity)) {
                    throw new OptimisticLockingFailureException("Optimistic lock exception on saving entity: " + updateObj.toMap().toString() + " to collection " + collectionName);
                }
                MongoTemplate.this.handleAnyWriteResultErrors(writeResult, (DBObject)queryObj, MongoActionOperation.UPDATE);
                return writeResult;
            }
        });
    }

    private void increaseVersionForUpdateIfNecessary(MongoPersistentEntity<?> persistentEntity, Update update) {
        String versionFieldName;
        if (persistentEntity != null && persistentEntity.hasVersionProperty() && !update.modifies(versionFieldName = ((MongoPersistentProperty)persistentEntity.getVersionProperty()).getFieldName())) {
            update.inc(versionFieldName, 1L);
        }
    }

    private boolean dbObjectContainsVersionProperty(DBObject dbObject, MongoPersistentEntity<?> persistentEntity) {
        if (persistentEntity == null || !persistentEntity.hasVersionProperty()) {
            return false;
        }
        return dbObject.containsField(((MongoPersistentProperty)persistentEntity.getVersionProperty()).getFieldName());
    }

    @Override
    public WriteResult remove(Object object) {
        if (object == null) {
            return null;
        }
        return this.remove(this.getIdQueryFor(object), object.getClass());
    }

    @Override
    public WriteResult remove(Object object, String collection) {
        Assert.hasText((String)collection);
        if (object == null) {
            return null;
        }
        return this.doRemove(collection, this.getIdQueryFor(object), object.getClass());
    }

    private Map.Entry<String, Object> extractIdPropertyAndValue(Object object) {
        MongoPersistentProperty idProp;
        Assert.notNull((Object)object, (String)"Id cannot be extracted from 'null'.");
        Class<?> objectType = object.getClass();
        if (object instanceof DBObject) {
            return Collections.singletonMap(ID_FIELD, ((DBObject)object).get(ID_FIELD)).entrySet().iterator().next();
        }
        MongoPersistentEntity entity = (MongoPersistentEntity)this.mappingContext.getPersistentEntity(objectType);
        MongoPersistentProperty mongoPersistentProperty = idProp = entity == null ? null : (MongoPersistentProperty)entity.getIdProperty();
        if (idProp == null || entity == null) {
            throw new MappingException("No id property found for object of type " + objectType);
        }
        Object idValue = entity.getPropertyAccessor(object).getProperty((PersistentProperty)idProp);
        return Collections.singletonMap(idProp.getFieldName(), idValue).entrySet().iterator().next();
    }

    private Query getIdQueryFor(Object object) {
        Map.Entry<String, Object> id = this.extractIdPropertyAndValue(object);
        return new Query(Criteria.where(id.getKey()).is(id.getValue()));
    }

    private Query getIdInQueryFor(Collection<?> objects) {
        Assert.notEmpty(objects, (String)"Cannot create Query for empty collection.");
        Iterator<?> it = objects.iterator();
        Map.Entry<String, Object> firstEntry = this.extractIdPropertyAndValue(it.next());
        ArrayList<Object> ids = new ArrayList<Object>(objects.size());
        ids.add(firstEntry.getValue());
        while (it.hasNext()) {
            ids.add(this.extractIdPropertyAndValue(it.next()).getValue());
        }
        return new Query(Criteria.where(firstEntry.getKey()).in(ids));
    }

    private void assertUpdateableIdIfNotSet(Object entity) {
        MongoPersistentProperty idProperty;
        MongoPersistentEntity persistentEntity = (MongoPersistentEntity)this.mappingContext.getPersistentEntity(entity.getClass());
        MongoPersistentProperty mongoPersistentProperty = idProperty = persistentEntity == null ? null : (MongoPersistentProperty)persistentEntity.getIdProperty();
        if (idProperty == null || persistentEntity == null) {
            return;
        }
        Object idValue = persistentEntity.getPropertyAccessor(entity).getProperty((PersistentProperty)idProperty);
        if (idValue == null && !MongoSimpleTypes.AUTOGENERATED_ID_TYPES.contains(idProperty.getType())) {
            throw new InvalidDataAccessApiUsageException(String.format("Cannot autogenerate id of type %s for entity of type %s!", idProperty.getType().getName(), entity.getClass().getName()));
        }
    }

    @Override
    public WriteResult remove(Query query, String collectionName) {
        return this.remove(query, null, collectionName);
    }

    @Override
    public WriteResult remove(Query query, Class<?> entityClass) {
        return this.remove(query, entityClass, this.determineCollectionName(entityClass));
    }

    @Override
    public WriteResult remove(Query query, Class<?> entityClass, String collectionName) {
        return this.doRemove(collectionName, query, entityClass);
    }

    protected <T> WriteResult doRemove(final String collectionName, Query query, final Class<T> entityClass) {
        if (query == null) {
            throw new InvalidDataAccessApiUsageException("Query passed in to remove can't be null!");
        }
        Assert.hasText((String)collectionName, (String)"Collection name must not be null or empty!");
        final DBObject queryObject = query.getQueryObject();
        final MongoPersistentEntity<?> entity = this.getPersistentEntity(entityClass);
        return this.execute(collectionName, new CollectionCallback<WriteResult>(){

            @Override
            public WriteResult doInCollection(DBCollection collection) throws MongoException, DataAccessException {
                MongoTemplate.this.maybeEmitEvent(new BeforeDeleteEvent(queryObject, entityClass, collectionName));
                DBObject dboq = MongoTemplate.this.queryMapper.getMappedObject(queryObject, entity);
                MongoAction mongoAction = new MongoAction(MongoTemplate.this.writeConcern, MongoActionOperation.REMOVE, collectionName, entityClass, null, queryObject);
                WriteConcern writeConcernToUse = MongoTemplate.this.prepareWriteConcern(mongoAction);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Remove using query: {} in collection: {}.", new Object[]{SerializationUtils.serializeToJsonSafely(dboq), collection.getName()});
                }
                WriteResult wr = writeConcernToUse == null ? collection.remove(dboq) : collection.remove(dboq, writeConcernToUse);
                MongoTemplate.this.handleAnyWriteResultErrors(wr, dboq, MongoActionOperation.REMOVE);
                MongoTemplate.this.maybeEmitEvent(new AfterDeleteEvent(queryObject, entityClass, collectionName));
                return wr;
            }
        });
    }

    @Override
    public <T> List<T> findAll(Class<T> entityClass) {
        return this.findAll(entityClass, this.determineCollectionName(entityClass));
    }

    @Override
    public <T> List<T> findAll(Class<T> entityClass, String collectionName) {
        return this.executeFindMultiInternal(new FindCallback(null), null, new ReadDbObjectCallback<Object>(this.mongoConverter, entityClass, collectionName), collectionName);
    }

    @Override
    public <T> MapReduceResults<T> mapReduce(String inputCollectionName, String mapFunction, String reduceFunction, Class<T> entityClass) {
        return this.mapReduce(null, inputCollectionName, mapFunction, reduceFunction, new MapReduceOptions().outputTypeInline(), entityClass);
    }

    @Override
    public <T> MapReduceResults<T> mapReduce(String inputCollectionName, String mapFunction, String reduceFunction, MapReduceOptions mapReduceOptions, Class<T> entityClass) {
        return this.mapReduce(null, inputCollectionName, mapFunction, reduceFunction, mapReduceOptions, entityClass);
    }

    @Override
    public <T> MapReduceResults<T> mapReduce(Query query, String inputCollectionName, String mapFunction, String reduceFunction, Class<T> entityClass) {
        return this.mapReduce(query, inputCollectionName, mapFunction, reduceFunction, new MapReduceOptions().outputTypeInline(), entityClass);
    }

    @Override
    public <T> MapReduceResults<T> mapReduce(Query query, String inputCollectionName, String mapFunction, String reduceFunction, MapReduceOptions mapReduceOptions, Class<T> entityClass) {
        String mapFunc = this.replaceWithResourceIfNecessary(mapFunction);
        String reduceFunc = this.replaceWithResourceIfNecessary(reduceFunction);
        DBCollection inputCollection = this.getCollection(inputCollectionName);
        MapReduceCommand command = new MapReduceCommand(inputCollection, mapFunc, reduceFunc, mapReduceOptions.getOutputCollection(), mapReduceOptions.getOutputType(), query == null || query.getQueryObject() == null ? null : this.queryMapper.getMappedObject(query.getQueryObject(), null));
        this.copyMapReduceOptionsToCommand(query, mapReduceOptions, command);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Executing MapReduce on collection [" + command.getInput() + "], mapFunction [" + mapFunc + "], reduceFunction [" + reduceFunc + "]");
        }
        MapReduceOutput mapReduceOutput = inputCollection.mapReduce(command);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("MapReduce command result = [{}]", (Object)SerializationUtils.serializeToJsonSafely(mapReduceOutput.results()));
        }
        ArrayList mappedResults = new ArrayList();
        ReadDbObjectCallback<Object> callback = new ReadDbObjectCallback<Object>(this.mongoConverter, entityClass, inputCollectionName);
        for (DBObject dbObject : mapReduceOutput.results()) {
            mappedResults.add(callback.doWith(dbObject));
        }
        return new MapReduceResults(mappedResults, mapReduceOutput);
    }

    @Override
    public <T> GroupByResults<T> group(String inputCollectionName, GroupBy groupBy, Class<T> entityClass) {
        return this.group(null, inputCollectionName, groupBy, entityClass);
    }

    @Override
    public <T> GroupByResults<T> group(Criteria criteria, String inputCollectionName, GroupBy groupBy, Class<T> entityClass) {
        Object initialObj;
        DBObject dbo = groupBy.getGroupByObject();
        dbo.put("ns", (Object)inputCollectionName);
        if (criteria == null) {
            dbo.put("cond", null);
        } else {
            dbo.put("cond", (Object)this.queryMapper.getMappedObject(criteria.getCriteriaObject(), null));
        }
        if (dbo.containsField("initial") && (initialObj = dbo.get("initial")) instanceof String) {
            String initialAsString = this.replaceWithResourceIfNecessary((String)initialObj);
            dbo.put("initial", JSON.parse((String)initialAsString));
        }
        if (dbo.containsField("$reduce")) {
            dbo.put("$reduce", (Object)this.replaceWithResourceIfNecessary(dbo.get("$reduce").toString()));
        }
        if (dbo.containsField("$keyf")) {
            dbo.put("$keyf", (Object)this.replaceWithResourceIfNecessary(dbo.get("$keyf").toString()));
        }
        if (dbo.containsField("finalize")) {
            dbo.put("finalize", (Object)this.replaceWithResourceIfNecessary(dbo.get("finalize").toString()));
        }
        BasicDBObject commandObject = new BasicDBObject("group", (Object)dbo);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Executing Group with DBObject [{}]", (Object)SerializationUtils.serializeToJsonSafely(commandObject));
        }
        CommandResult commandResult = this.executeCommand((DBObject)commandObject, this.getDb().getOptions());
        this.handleCommandError(commandResult, (DBObject)commandObject);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Group command result = [{}]", (Object)commandResult);
        }
        Iterable resultSet = (Iterable)commandResult.get("retval");
        ArrayList mappedResults = new ArrayList();
        ReadDbObjectCallback<Object> callback = new ReadDbObjectCallback<Object>(this.mongoConverter, entityClass, inputCollectionName);
        for (DBObject dbObject : resultSet) {
            mappedResults.add(callback.doWith(dbObject));
        }
        return new GroupByResults(mappedResults, (DBObject)commandResult);
    }

    @Override
    public <O> AggregationResults<O> aggregate(TypedAggregation<?> aggregation, Class<O> outputType) {
        return this.aggregate(aggregation, this.determineCollectionName(aggregation.getInputType()), outputType);
    }

    @Override
    public <O> AggregationResults<O> aggregate(TypedAggregation<?> aggregation, String inputCollectionName, Class<O> outputType) {
        Assert.notNull(aggregation, (String)"Aggregation pipeline must not be null!");
        TypeBasedAggregationOperationContext context = new TypeBasedAggregationOperationContext(aggregation.getInputType(), this.mappingContext, this.queryMapper);
        return this.aggregate(aggregation, inputCollectionName, outputType, context);
    }

    @Override
    public <O> AggregationResults<O> aggregate(Aggregation aggregation, Class<?> inputType, Class<O> outputType) {
        return this.aggregate(aggregation, this.determineCollectionName(inputType), outputType, new TypeBasedAggregationOperationContext(inputType, this.mappingContext, this.queryMapper));
    }

    @Override
    public <O> AggregationResults<O> aggregate(Aggregation aggregation, String collectionName, Class<O> outputType) {
        return this.aggregate(aggregation, collectionName, outputType, null);
    }

    @Override
    public <T> List<T> findAllAndRemove(Query query, String collectionName) {
        return (List)this.findAndRemove(query, null, collectionName);
    }

    @Override
    public <T> List<T> findAllAndRemove(Query query, Class<T> entityClass) {
        return this.findAllAndRemove(query, entityClass, this.determineCollectionName(entityClass));
    }

    @Override
    public <T> List<T> findAllAndRemove(Query query, Class<T> entityClass, String collectionName) {
        return this.doFindAndDelete(collectionName, query, entityClass);
    }

    protected <T> List<T> doFindAndDelete(String collectionName, Query query, Class<T> entityClass) {
        List<T> result = this.find(query, entityClass, collectionName);
        if (!CollectionUtils.isEmpty(result)) {
            this.remove(this.getIdInQueryFor(result), entityClass, collectionName);
        }
        return result;
    }

    protected <O> AggregationResults<O> aggregate(Aggregation aggregation, String collectionName, Class<O> outputType, AggregationOperationContext context) {
        Assert.hasText((String)collectionName, (String)"Collection name must not be null or empty!");
        Assert.notNull((Object)aggregation, (String)"Aggregation pipeline must not be null!");
        Assert.notNull(outputType, (String)"Output type must not be null!");
        AggregationOperationContext rootContext = context == null ? Aggregation.DEFAULT_CONTEXT : context;
        DBObject command = aggregation.toDbObject(collectionName, rootContext);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Executing aggregation: {}", (Object)SerializationUtils.serializeToJsonSafely(command));
        }
        CommandResult commandResult = this.executeCommand(command, this.readPreference);
        this.handleCommandError(commandResult, command);
        return new AggregationResults<O>(this.returnPotentiallyMappedResults(outputType, commandResult, collectionName), (DBObject)commandResult);
    }

    private <O> List<O> returnPotentiallyMappedResults(Class<O> outputType, CommandResult commandResult, String collectionName) {
        Iterable resultSet = (Iterable)commandResult.get("result");
        if (resultSet == null) {
            return Collections.emptyList();
        }
        UnwrapAndReadDbObjectCallback<Object> callback = new UnwrapAndReadDbObjectCallback<Object>(this.mongoConverter, outputType, collectionName);
        ArrayList mappedResults = new ArrayList();
        for (DBObject dbObject : resultSet) {
            mappedResults.add(callback.doWith(dbObject));
        }
        return mappedResults;
    }

    protected String replaceWithResourceIfNecessary(String function) {
        String func = function;
        if (this.resourceLoader != null && ResourceUtils.isUrl((String)function)) {
            Resource functionResource = this.resourceLoader.getResource(func);
            if (!functionResource.exists()) {
                throw new InvalidDataAccessApiUsageException(String.format("Resource %s not found!", function));
            }
            Scanner scanner = null;
            try {
                scanner = new Scanner(functionResource.getInputStream());
                String string = scanner.useDelimiter("\\A").next();
                return string;
            }
            catch (IOException e) {
                throw new InvalidDataAccessApiUsageException(String.format("Cannot read map-reduce file %s!", function), (Throwable)e);
            }
            finally {
                if (scanner != null) {
                    scanner.close();
                }
            }
        }
        return func;
    }

    private void copyMapReduceOptionsToCommand(Query query, MapReduceOptions mapReduceOptions, MapReduceCommand mapReduceCommand) {
        if (query != null) {
            if (query.getSkip() != 0 || query.getFieldsObject() != null) {
                throw new InvalidDataAccessApiUsageException("Can not use skip or field specification with map reduce operations");
            }
            if (query.getLimit() > 0 && mapReduceOptions.getLimit() == null) {
                mapReduceCommand.setLimit(query.getLimit());
            }
            if (query.getSortObject() != null) {
                mapReduceCommand.setSort(this.queryMapper.getMappedObject(query.getSortObject(), null));
            }
        }
        if (mapReduceOptions.getLimit() != null && mapReduceOptions.getLimit() > 0) {
            mapReduceCommand.setLimit(mapReduceOptions.getLimit().intValue());
        }
        if (mapReduceOptions.getJavaScriptMode() != null) {
            mapReduceCommand.setJsMode(Boolean.valueOf(true));
        }
        if (!mapReduceOptions.getExtraOptions().isEmpty()) {
            for (Map.Entry<String, Object> entry : mapReduceOptions.getExtraOptions().entrySet()) {
                ReflectiveMapReduceInvoker.addExtraOption(mapReduceCommand, entry.getKey(), entry.getValue());
            }
        }
        if (mapReduceOptions.getFinalizeFunction() != null) {
            mapReduceCommand.setFinalize(this.replaceWithResourceIfNecessary(mapReduceOptions.getFinalizeFunction()));
        }
        if (mapReduceOptions.getOutputDatabase() != null) {
            mapReduceCommand.setOutputDB(mapReduceOptions.getOutputDatabase());
        }
        if (!mapReduceOptions.getScopeVariables().isEmpty()) {
            mapReduceCommand.setScope(mapReduceOptions.getScopeVariables());
        }
    }

    @Override
    public Set<String> getCollectionNames() {
        return this.execute(new DbCallback<Set<String>>(){

            @Override
            public Set<String> doInDB(DB db) throws MongoException, DataAccessException {
                return db.getCollectionNames();
            }
        });
    }

    public DB getDb() {
        return this.mongoDbFactory.getDb();
    }

    protected <T> void maybeEmitEvent(MongoMappingEvent<T> event) {
        if (null != this.eventPublisher) {
            this.eventPublisher.publishEvent(event);
        }
    }

    protected DBCollection doCreateCollection(final String collectionName, final DBObject collectionOptions) {
        return this.execute(new DbCallback<DBCollection>(){

            @Override
            public DBCollection doInDB(DB db) throws MongoException, DataAccessException {
                DBCollection coll = db.createCollection(collectionName, collectionOptions);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Created collection [{}]", (Object)coll.getFullName());
                }
                return coll;
            }
        });
    }

    protected <T> T doFindOne(String collectionName, DBObject query, DBObject fields, Class<T> entityClass) {
        DBObject mappedFields;
        MongoPersistentEntity entity = (MongoPersistentEntity)this.mappingContext.getPersistentEntity(entityClass);
        DBObject mappedQuery = this.queryMapper.getMappedObject(query, entity);
        DBObject dBObject = mappedFields = fields == null ? null : this.queryMapper.getMappedObject(fields, entity);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("findOne using query: %s fields: %s for class: %s in collection: %s", SerializationUtils.serializeToJsonSafely(query), mappedFields, entityClass, collectionName));
        }
        return (T)this.executeFindOneInternal(new FindOneCallback(mappedQuery, mappedFields), new ReadDbObjectCallback<Object>(this.mongoConverter, entityClass, collectionName), collectionName);
    }

    protected <T> List<T> doFind(String collectionName, DBObject query, DBObject fields, Class<T> entityClass) {
        return this.doFind(collectionName, query, fields, entityClass, null, new ReadDbObjectCallback<Object>(this.mongoConverter, entityClass, collectionName));
    }

    protected <T> List<T> doFind(String collectionName, DBObject query, DBObject fields, Class<T> entityClass, CursorPreparer preparer) {
        return this.doFind(collectionName, query, fields, entityClass, preparer, new ReadDbObjectCallback<Object>(this.mongoConverter, entityClass, collectionName));
    }

    protected <S, T> List<T> doFind(String collectionName, DBObject query, DBObject fields, Class<S> entityClass, CursorPreparer preparer, DbObjectCallback<T> objectCallback) {
        MongoPersistentEntity entity = (MongoPersistentEntity)this.mappingContext.getPersistentEntity(entityClass);
        DBObject mappedFields = this.queryMapper.getMappedFields(fields, entity);
        DBObject mappedQuery = this.queryMapper.getMappedObject(query, entity);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("find using query: %s fields: %s for class: %s in collection: %s", SerializationUtils.serializeToJsonSafely(mappedQuery), mappedFields, entityClass, collectionName));
        }
        return this.executeFindMultiInternal(new FindCallback(mappedQuery, mappedFields), preparer, objectCallback, collectionName);
    }

    protected DBObject convertToDbObject(CollectionOptions collectionOptions) {
        BasicDBObject dbo = new BasicDBObject();
        if (collectionOptions != null) {
            if (collectionOptions.getCapped() != null) {
                dbo.put("capped", (Object)collectionOptions.getCapped());
            }
            if (collectionOptions.getSize() != null) {
                dbo.put("size", (Object)collectionOptions.getSize());
            }
            if (collectionOptions.getMaxDocuments() != null) {
                dbo.put("max", (Object)collectionOptions.getMaxDocuments());
            }
        }
        return dbo;
    }

    protected <T> T doFindAndRemove(String collectionName, DBObject query, DBObject fields, DBObject sort, Class<T> entityClass) {
        MongoConverter readerToUse = this.mongoConverter;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("findAndRemove using query: %s fields: %s sort: %s for class: %s in collection: %s", SerializationUtils.serializeToJsonSafely(query), fields, sort, entityClass, collectionName));
        }
        MongoPersistentEntity entity = (MongoPersistentEntity)this.mappingContext.getPersistentEntity(entityClass);
        return (T)this.executeFindOneInternal(new FindAndRemoveCallback(this.queryMapper.getMappedObject(query, entity), fields, sort), new ReadDbObjectCallback<Object>(readerToUse, entityClass, collectionName), collectionName);
    }

    protected <T> T doFindAndModify(String collectionName, DBObject query, DBObject fields, DBObject sort, Class<T> entityClass, Update update, FindAndModifyOptions options) {
        MongoConverter readerToUse = this.mongoConverter;
        if (options == null) {
            options = new FindAndModifyOptions();
        }
        MongoPersistentEntity entity = (MongoPersistentEntity)this.mappingContext.getPersistentEntity(entityClass);
        this.increaseVersionForUpdateIfNecessary(entity, update);
        DBObject mappedQuery = this.queryMapper.getMappedObject(query, entity);
        DBObject mappedUpdate = this.updateMapper.getMappedObject(update.getUpdateObject(), entity);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("findAndModify using query: %s fields: %s sort: %s for class: %s and update: %s in collection: %s", SerializationUtils.serializeToJsonSafely(mappedQuery), fields, sort, entityClass, SerializationUtils.serializeToJsonSafely(mappedUpdate), collectionName));
        }
        return (T)this.executeFindOneInternal(new FindAndModifyCallback(mappedQuery, fields, sort, mappedUpdate, options), new ReadDbObjectCallback<Object>(readerToUse, entityClass, collectionName), collectionName);
    }

    protected void populateIdIfNecessary(Object savedObject, Object id) {
        if (id == null) {
            return;
        }
        if (savedObject instanceof BasicDBObject) {
            DBObject dbObject = (DBObject)savedObject;
            dbObject.put(ID_FIELD, id);
            return;
        }
        MongoPersistentProperty idProp = this.getIdPropertyFor(savedObject.getClass());
        if (idProp == null) {
            return;
        }
        ConversionService conversionService = this.mongoConverter.getConversionService();
        MongoPersistentEntity entity = (MongoPersistentEntity)this.mappingContext.getPersistentEntity(savedObject.getClass());
        PersistentPropertyAccessor accessor = entity.getPropertyAccessor(savedObject);
        if (accessor.getProperty((PersistentProperty)idProp) != null) {
            return;
        }
        new ConvertingPropertyAccessor(accessor, conversionService).setProperty((PersistentProperty)idProp, id);
    }

    private DBCollection getAndPrepareCollection(DB db, String collectionName) {
        try {
            DBCollection collection = db.getCollection(collectionName);
            this.prepareCollection(collection);
            return collection;
        }
        catch (RuntimeException e) {
            throw MongoTemplate.potentiallyConvertRuntimeException(e, this.exceptionTranslator);
        }
    }

    private <T> T executeFindOneInternal(CollectionCallback<DBObject> collectionCallback, DbObjectCallback<T> objectCallback, String collectionName) {
        try {
            T result = objectCallback.doWith(collectionCallback.doInCollection(this.getAndPrepareCollection(this.getDb(), collectionName)));
            return result;
        }
        catch (RuntimeException e) {
            throw MongoTemplate.potentiallyConvertRuntimeException(e, this.exceptionTranslator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> List<T> executeFindMultiInternal(CollectionCallback<DBCursor> collectionCallback, CursorPreparer preparer, DbObjectCallback<T> objectCallback, String collectionName) {
        ArrayList<T> arrayList;
        block8: {
            DBCursor cursor = null;
            try {
                cursor = collectionCallback.doInCollection(this.getAndPrepareCollection(this.getDb(), collectionName));
                if (preparer != null) {
                    cursor = preparer.prepare(cursor);
                }
                ArrayList<T> result = new ArrayList<T>();
                while (cursor.hasNext()) {
                    DBObject object = cursor.next();
                    result.add(objectCallback.doWith(object));
                }
                arrayList = result;
                if (cursor == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (cursor != null) {
                        cursor.close();
                    }
                    throw throwable;
                }
                catch (RuntimeException e) {
                    throw MongoTemplate.potentiallyConvertRuntimeException(e, this.exceptionTranslator);
                }
            }
            cursor.close();
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeQueryInternal(CollectionCallback<DBCursor> collectionCallback, CursorPreparer preparer, DocumentCallbackHandler callbackHandler, String collectionName) {
        try {
            DBCursor cursor = null;
            try {
                cursor = collectionCallback.doInCollection(this.getAndPrepareCollection(this.getDb(), collectionName));
                if (preparer != null) {
                    cursor = preparer.prepare(cursor);
                }
                while (cursor.hasNext()) {
                    DBObject dbobject = cursor.next();
                    callbackHandler.processDocument(dbobject);
                }
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }
        catch (RuntimeException e) {
            throw MongoTemplate.potentiallyConvertRuntimeException(e, this.exceptionTranslator);
        }
    }

    private MongoPersistentEntity<?> getPersistentEntity(Class<?> type) {
        return type == null ? null : (MongoPersistentEntity)this.mappingContext.getPersistentEntity(type);
    }

    private MongoPersistentProperty getIdPropertyFor(Class<?> type) {
        MongoPersistentEntity persistentEntity = (MongoPersistentEntity)this.mappingContext.getPersistentEntity(type);
        return persistentEntity == null ? null : (MongoPersistentProperty)persistentEntity.getIdProperty();
    }

    private <T> String determineEntityCollectionName(T obj) {
        if (null != obj) {
            return this.determineCollectionName(obj.getClass());
        }
        return null;
    }

    String determineCollectionName(Class<?> entityClass) {
        if (entityClass == null) {
            throw new InvalidDataAccessApiUsageException("No class parameter provided, entity collection can't be determined!");
        }
        MongoPersistentEntity entity = (MongoPersistentEntity)this.mappingContext.getPersistentEntity(entityClass);
        if (entity == null) {
            throw new InvalidDataAccessApiUsageException("No Persitent Entity information found for the class " + entityClass.getName());
        }
        return entity.getCollection();
    }

    protected void handleAnyWriteResultErrors(WriteResult writeResult, DBObject query, MongoActionOperation operation) {
        String message;
        if (this.writeResultChecking == WriteResultChecking.NONE) {
            return;
        }
        String error = ReflectiveWriteResultInvoker.getError(writeResult);
        if (error == null) {
            return;
        }
        switch (operation) {
            case INSERT: 
            case SAVE: {
                message = String.format("Insert/Save for %s failed: %s", query, error);
                break;
            }
            case INSERT_LIST: {
                message = String.format("Insert list failed: %s", error);
                break;
            }
            default: {
                message = String.format("Execution of %s%s failed: %s", new Object[]{operation, query == null ? "" : " using query " + query.toString(), error});
            }
        }
        if (this.writeResultChecking == WriteResultChecking.EXCEPTION) {
            throw new MongoDataIntegrityViolationException(message, writeResult, operation);
        }
        LOGGER.error(message);
    }

    private void handleCommandError(CommandResult result, DBObject source) {
        try {
            result.throwOnError();
        }
        catch (MongoException ex) {
            String error = result.getErrorMessage();
            error = error == null ? "NO MESSAGE" : error;
            throw new InvalidDataAccessApiUsageException("Command execution failed:  Error [" + error + "], Command = " + source, (Throwable)ex);
        }
    }

    private static final MongoConverter getDefaultMongoConverter(MongoDbFactory factory) {
        DefaultDbRefResolver dbRefResolver = new DefaultDbRefResolver(factory);
        MappingMongoConverter converter = new MappingMongoConverter(dbRefResolver, (MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty>)new MongoMappingContext());
        converter.afterPropertiesSet();
        return converter;
    }

    private DBObject getMappedSortObject(Query query, Class<?> type) {
        if (query == null || query.getSortObject() == null) {
            return null;
        }
        return this.queryMapper.getMappedSort(query.getSortObject(), (MongoPersistentEntity)this.mappingContext.getPersistentEntity(type));
    }

    private static RuntimeException potentiallyConvertRuntimeException(RuntimeException ex, PersistenceExceptionTranslator exceptionTranslator) {
        DataAccessException resolved = exceptionTranslator.translateExceptionIfPossible(ex);
        return resolved == null ? ex : resolved;
    }

    static {
        HashSet<String> iterableClasses = new HashSet<String>();
        iterableClasses.add(List.class.getName());
        iterableClasses.add(Collection.class.getName());
        iterableClasses.add(Iterator.class.getName());
        ITERABLE_CLASSES = Collections.unmodifiableCollection(iterableClasses);
    }

    static class CloseableIterableCursorAdapter<T>
    implements CloseableIterator<T> {
        private volatile Cursor cursor;
        private PersistenceExceptionTranslator exceptionTranslator;
        private DbObjectCallback<T> objectReadCallback;

        public CloseableIterableCursorAdapter(Cursor cursor, PersistenceExceptionTranslator exceptionTranslator, DbObjectCallback<T> objectReadCallback) {
            this.cursor = cursor;
            this.exceptionTranslator = exceptionTranslator;
            this.objectReadCallback = objectReadCallback;
        }

        public boolean hasNext() {
            if (this.cursor == null) {
                return false;
            }
            try {
                return this.cursor.hasNext();
            }
            catch (RuntimeException ex) {
                throw MongoTemplate.potentiallyConvertRuntimeException(ex, this.exceptionTranslator);
            }
        }

        public T next() {
            if (this.cursor == null) {
                return null;
            }
            try {
                DBObject item = (DBObject)this.cursor.next();
                T converted = this.objectReadCallback.doWith(item);
                return converted;
            }
            catch (RuntimeException ex) {
                throw MongoTemplate.potentiallyConvertRuntimeException(ex, this.exceptionTranslator);
            }
        }

        public void close() {
            Cursor c = this.cursor;
            try {
                c.close();
            }
            catch (RuntimeException ex) {
                throw MongoTemplate.potentiallyConvertRuntimeException(ex, this.exceptionTranslator);
            }
            finally {
                this.cursor = null;
                this.exceptionTranslator = null;
                this.objectReadCallback = null;
            }
        }
    }

    static class GeoNearResultDbObjectCallback<T>
    implements DbObjectCallback<GeoResult<T>> {
        private final DbObjectCallback<T> delegate;
        private final Metric metric;

        public GeoNearResultDbObjectCallback(DbObjectCallback<T> delegate, Metric metric) {
            Assert.notNull(delegate);
            this.delegate = delegate;
            this.metric = metric;
        }

        @Override
        public GeoResult<T> doWith(DBObject object) {
            double distance = (Double)object.get("dis");
            DBObject content = (DBObject)object.get("obj");
            T doWith = this.delegate.doWith(content);
            return new GeoResult(doWith, new Distance(distance, this.metric));
        }
    }

    class QueryCursorPreparer
    implements CursorPreparer {
        private final Query query;
        private final Class<?> type;

        public QueryCursorPreparer(Query query, Class<?> type) {
            this.query = query;
            this.type = type;
        }

        @Override
        public DBCursor prepare(DBCursor cursor) {
            if (this.query == null) {
                return cursor;
            }
            if (this.query.getSkip() <= 0 && this.query.getLimit() <= 0 && this.query.getSortObject() == null && !StringUtils.hasText((String)this.query.getHint()) && !this.query.getMeta().hasValues()) {
                return cursor;
            }
            DBCursor cursorToUse = cursor.copy();
            try {
                if (this.query.getSkip() > 0) {
                    cursorToUse = cursorToUse.skip(this.query.getSkip());
                }
                if (this.query.getLimit() > 0) {
                    cursorToUse = cursorToUse.limit(this.query.getLimit());
                }
                if (this.query.getSortObject() != null) {
                    DBObject sortDbo = this.type != null ? MongoTemplate.this.getMappedSortObject(this.query, this.type) : this.query.getSortObject();
                    cursorToUse = cursorToUse.sort(sortDbo);
                }
                if (StringUtils.hasText((String)this.query.getHint())) {
                    cursorToUse = cursorToUse.hint(this.query.getHint());
                }
                if (this.query.getMeta().hasValues()) {
                    for (Map.Entry entry : this.query.getMeta().values()) {
                        cursorToUse = cursorToUse.addSpecial((String)entry.getKey(), entry.getValue());
                    }
                }
            }
            catch (RuntimeException e) {
                throw MongoTemplate.potentiallyConvertRuntimeException(e, MongoTemplate.this.exceptionTranslator);
            }
            return cursorToUse;
        }
    }

    private static enum DefaultWriteConcernResolver implements WriteConcernResolver
    {
        INSTANCE;


        @Override
        public WriteConcern resolve(MongoAction action) {
            return action.getDefaultWriteConcern();
        }
    }

    class UnwrapAndReadDbObjectCallback<T>
    extends ReadDbObjectCallback<T> {
        public UnwrapAndReadDbObjectCallback(EntityReader<? super T, DBObject> reader, Class<T> type, String collectionName) {
            super(reader, type, collectionName);
        }

        @Override
        public T doWith(DBObject object) {
            Object idField = object.get(MongoTemplate.ID_FIELD);
            if (!(idField instanceof DBObject)) {
                return super.doWith(object);
            }
            BasicDBObject toMap = new BasicDBObject();
            DBObject nested = (DBObject)idField;
            toMap.putAll((BSONObject)nested);
            for (String key : object.keySet()) {
                if (MongoTemplate.ID_FIELD.equals(key)) continue;
                toMap.put(key, object.get(key));
            }
            return super.doWith((DBObject)toMap);
        }
    }

    private class ReadDbObjectCallback<T>
    implements DbObjectCallback<T> {
        private final EntityReader<? super T, DBObject> reader;
        private final Class<T> type;
        private final String collectionName;

        public ReadDbObjectCallback(EntityReader<? super T, DBObject> reader, Class<T> type, String collectionName) {
            Assert.notNull(reader);
            Assert.notNull(type);
            this.reader = reader;
            this.type = type;
            this.collectionName = collectionName;
        }

        @Override
        public T doWith(DBObject object) {
            Object source;
            if (null != object) {
                MongoTemplate.this.maybeEmitEvent(new AfterLoadEvent<T>(object, this.type, this.collectionName));
            }
            if (null != (source = this.reader.read(this.type, (Object)object))) {
                MongoTemplate.this.maybeEmitEvent(new AfterConvertEvent<Object>(object, source, this.collectionName));
            }
            return (T)source;
        }
    }

    static interface DbObjectCallback<T> {
        public T doWith(DBObject var1);
    }

    private static class FindAndModifyCallback
    implements CollectionCallback<DBObject> {
        private final DBObject query;
        private final DBObject fields;
        private final DBObject sort;
        private final DBObject update;
        private final FindAndModifyOptions options;

        public FindAndModifyCallback(DBObject query, DBObject fields, DBObject sort, DBObject update, FindAndModifyOptions options) {
            this.query = query;
            this.fields = fields;
            this.sort = sort;
            this.update = update;
            this.options = options;
        }

        @Override
        public DBObject doInCollection(DBCollection collection) throws MongoException, DataAccessException {
            return collection.findAndModify(this.query, this.fields, this.sort, this.options.isRemove(), this.update, this.options.isReturnNew(), this.options.isUpsert());
        }
    }

    private static class FindAndRemoveCallback
    implements CollectionCallback<DBObject> {
        private final DBObject query;
        private final DBObject fields;
        private final DBObject sort;

        public FindAndRemoveCallback(DBObject query, DBObject fields, DBObject sort) {
            this.query = query;
            this.fields = fields;
            this.sort = sort;
        }

        @Override
        public DBObject doInCollection(DBCollection collection) throws MongoException, DataAccessException {
            return collection.findAndModify(this.query, this.fields, this.sort, true, null, false, false);
        }
    }

    private static class FindCallback
    implements CollectionCallback<DBCursor> {
        private final DBObject query;
        private final DBObject fields;

        public FindCallback(DBObject query) {
            this(query, null);
        }

        public FindCallback(DBObject query, DBObject fields) {
            this.query = query;
            this.fields = fields;
        }

        @Override
        public DBCursor doInCollection(DBCollection collection) throws MongoException, DataAccessException {
            if (this.fields == null || this.fields.toMap().isEmpty()) {
                return collection.find(this.query);
            }
            return collection.find(this.query, this.fields);
        }
    }

    private static class FindOneCallback
    implements CollectionCallback<DBObject> {
        private final DBObject query;
        private final DBObject fields;

        public FindOneCallback(DBObject query, DBObject fields) {
            this.query = query;
            this.fields = fields;
        }

        @Override
        public DBObject doInCollection(DBCollection collection) throws MongoException, DataAccessException {
            if (this.fields == null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(String.format("findOne using query: %s in db.collection: %s", SerializationUtils.serializeToJsonSafely(this.query), collection.getFullName()));
                }
                return collection.findOne(this.query);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("findOne using query: %s fields: %s in db.collection: %s", SerializationUtils.serializeToJsonSafely(this.query), this.fields, collection.getFullName()));
            }
            return collection.findOne(this.query, this.fields);
        }
    }
}

