/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.client;

import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.springframework.data.elasticsearch.client.ClientConfiguration;
import org.springframework.http.HttpHeaders;
import org.springframework.lang.Nullable;
import org.springframework.util.MultiValueMap;

class DefaultClientConfiguration
implements ClientConfiguration {
    private final List<InetSocketAddress> hosts;
    private final HttpHeaders headers;
    private final boolean useSsl;
    @Nullable
    private final SSLContext sslContext;
    private final Duration soTimeout;
    private final Duration connectTimeout;
    @Nullable
    private final HostnameVerifier hostnameVerifier;

    DefaultClientConfiguration(List<InetSocketAddress> hosts, HttpHeaders headers, boolean useSsl, @Nullable SSLContext sslContext, Duration soTimeout, Duration connectTimeout, @Nullable HostnameVerifier hostnameVerifier) {
        this.hosts = Collections.unmodifiableList(new ArrayList<InetSocketAddress>(hosts));
        this.headers = new HttpHeaders((MultiValueMap)headers);
        this.useSsl = useSsl;
        this.sslContext = sslContext;
        this.soTimeout = soTimeout;
        this.connectTimeout = connectTimeout;
        this.hostnameVerifier = hostnameVerifier;
    }

    @Override
    public List<InetSocketAddress> getEndpoints() {
        return this.hosts;
    }

    @Override
    public HttpHeaders getDefaultHeaders() {
        return this.headers;
    }

    @Override
    public boolean useSsl() {
        return this.useSsl;
    }

    @Override
    public Optional<SSLContext> getSslContext() {
        return Optional.ofNullable(this.sslContext);
    }

    @Override
    public Optional<HostnameVerifier> getHostNameVerifier() {
        return Optional.ofNullable(this.hostnameVerifier);
    }

    @Override
    public Duration getConnectTimeout() {
        return this.connectTimeout;
    }

    @Override
    public Duration getSocketTimeout() {
        return this.soTimeout;
    }
}

