/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.config;

import org.springframework.data.repository.config.CommonRepositoryConfigInformation;
import org.springframework.data.repository.config.SingleRepositoryConfigInformation;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ParentDelegatingRepositoryConfigInformation<T extends CommonRepositoryConfigInformation>
implements SingleRepositoryConfigInformation<T> {
    private final T parent;

    public ParentDelegatingRepositoryConfigInformation(T parent) {
        Assert.notNull(parent);
        this.parent = parent;
    }

    protected T getParent() {
        return this.parent;
    }

    @Override
    public String getBasePackage() {
        return this.parent.getBasePackage();
    }

    @Override
    public String getImplementationClassName() {
        return StringUtils.capitalize((String)this.getBeanId()) + this.getRepositoryImplementationSuffix();
    }

    @Override
    public String getImplementationBeanName() {
        return this.getBeanId() + this.getRepositoryImplementationSuffix();
    }

    @Override
    public boolean autodetectCustomImplementation() {
        return true;
    }

    @Override
    public String getCustomImplementationRef() {
        return this.getBeanId() + this.getRepositoryImplementationSuffix();
    }

    @Override
    public Element getSource() {
        return this.parent.getSource();
    }

    @Override
    public String getRepositoryImplementationSuffix() {
        return this.parent.getRepositoryImplementationSuffix();
    }

    @Override
    public String getRepositoryFactoryBeanClassName() {
        return this.parent.getRepositoryFactoryBeanClassName();
    }

    @Override
    public String getTransactionManagerRef() {
        return this.parent.getTransactionManagerRef();
    }

    @Override
    public QueryLookupStrategy.Key getQueryLookupStrategyKey() {
        return this.parent.getQueryLookupStrategyKey();
    }

    @Override
    public String getNamedQueriesLocation() {
        return this.parent.getNamedQueriesLocation();
    }
}

