/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mapping;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyPath
implements Iterable<PropertyPath> {
    private static final String DELIMITERS = "_\\.";
    private static final Pattern SPLITTER = Pattern.compile("(?:[%s]?([%s]*?[^%s]+))".replaceAll("%s", "_\\."));
    private static final String ERROR_TEMPLATE = "No property %s found for type %s";
    private final TypeInformation<?> owningType;
    private final String name;
    private final TypeInformation<?> type;
    private final boolean isCollection;
    private PropertyPath next;

    PropertyPath(String name, Class<?> owningType) {
        this(name, ClassTypeInformation.from(owningType));
    }

    PropertyPath(String name, TypeInformation<?> owningType) {
        Assert.hasText((String)name);
        Assert.notNull(owningType);
        String propertyName = StringUtils.uncapitalize((String)name);
        TypeInformation<?> type = owningType.getProperty(propertyName);
        if (type == null) {
            throw new IllegalArgumentException(String.format(ERROR_TEMPLATE, propertyName, owningType.getType()));
        }
        this.owningType = owningType;
        this.isCollection = type.isCollectionLike();
        this.type = type.getActualType();
        this.name = propertyName;
    }

    PropertyPath(String name, TypeInformation<?> owningType, String toTraverse) {
        this(name, owningType);
        if (StringUtils.hasText((String)toTraverse)) {
            this.next = PropertyPath.from(toTraverse, this.type);
        }
    }

    public TypeInformation<?> getOwningType() {
        return this.owningType;
    }

    public String getSegment() {
        return this.name;
    }

    public Class<?> getType() {
        return this.type.getType();
    }

    public PropertyPath next() {
        return this.next;
    }

    public boolean hasNext() {
        return this.next != null;
    }

    public String toDotPath() {
        if (this.hasNext()) {
            return this.getSegment() + "." + this.next().toDotPath();
        }
        return this.getSegment();
    }

    public boolean isCollection() {
        return this.isCollection;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        PropertyPath that = (PropertyPath)obj;
        return this.name.equals(that.name) && this.type.equals(that.type);
    }

    public int hashCode() {
        return this.name.hashCode() + this.type.hashCode();
    }

    @Override
    public Iterator<PropertyPath> iterator() {
        return new Iterator<PropertyPath>(){
            private PropertyPath current;
            {
                this.current = PropertyPath.this;
            }

            @Override
            public boolean hasNext() {
                return this.current != null;
            }

            @Override
            public PropertyPath next() {
                PropertyPath result = this.current;
                this.current = this.current.next();
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static PropertyPath from(String source, Class<?> type) {
        return PropertyPath.from(source, ClassTypeInformation.from(type));
    }

    public static PropertyPath from(String source, TypeInformation<?> type) {
        ArrayList<String> iteratorSource = new ArrayList<String>();
        Matcher matcher = SPLITTER.matcher("_" + source);
        while (matcher.find()) {
            iteratorSource.add(matcher.group(1));
        }
        Iterator parts = iteratorSource.iterator();
        PropertyPath result = null;
        PropertyPath current = null;
        while (parts.hasNext()) {
            if (result == null) {
                current = result = PropertyPath.create((String)parts.next(), type);
                continue;
            }
            current = PropertyPath.create((String)parts.next(), current);
        }
        return result;
    }

    private static PropertyPath create(String source, PropertyPath base) {
        PropertyPath propertyPath;
        base.next = propertyPath = PropertyPath.create(source, base.type);
        return propertyPath;
    }

    private static PropertyPath create(String source, TypeInformation<?> type) {
        return PropertyPath.create(source, type, "");
    }

    private static PropertyPath create(String source, TypeInformation<?> type, String addTail) {
        IllegalArgumentException exception = null;
        try {
            return new PropertyPath(source, type, addTail);
        }
        catch (IllegalArgumentException e) {
            exception = e;
            Pattern pattern = Pattern.compile("[A-Z]+[a-z]*$");
            Matcher matcher = pattern.matcher(source);
            if (matcher.find() && matcher.start() != 0) {
                int position = matcher.start();
                String head = source.substring(0, position);
                String tail = source.substring(position);
                return PropertyPath.create(head, type, tail + addTail);
            }
            throw exception;
        }
    }
}

