/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.convert;

import java.util.HashMap;
import java.util.Map;
import org.springframework.data.convert.TypeInformationMapper;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurableTypeInformationMapper
implements TypeInformationMapper {
    private final Map<TypeInformation<?>, Object> typeMap;

    public ConfigurableTypeInformationMapper(MappingContext<? extends PersistentEntity<?, ?>, ?> mappingContext) {
        Assert.notNull(mappingContext);
        this.typeMap = new HashMap();
        for (PersistentEntity<?, ?> entity : mappingContext.getPersistentEntities()) {
            Object alias = entity.getTypeAlias();
            if (alias == null) continue;
            this.typeMap.put(entity.getTypeInformation(), alias);
        }
    }

    public ConfigurableTypeInformationMapper(Map<? extends Class<?>, String> sourceTypeMap) {
        Assert.notNull(sourceTypeMap);
        this.typeMap = new HashMap(sourceTypeMap.size());
        for (Map.Entry<Class<?>, String> entry : sourceTypeMap.entrySet()) {
            TypeInformation<?> key = ClassTypeInformation.from(entry.getKey());
            String value = entry.getValue();
            if (this.typeMap.containsValue(value)) {
                throw new IllegalArgumentException(String.format("Detected mapping ambiguity! String %s cannot be mapped to more than one type!", value));
            }
            this.typeMap.put(key, value);
        }
    }

    @Override
    public Object createAliasFor(TypeInformation<?> type) {
        Object key = this.typeMap.get(type);
        return key == null ? null : key;
    }

    @Override
    public TypeInformation<?> resolveTypeFrom(Object alias) {
        for (Map.Entry<TypeInformation<?>, Object> entry : this.typeMap.entrySet()) {
            if (!entry.getValue().equals(alias)) continue;
            return entry.getKey();
        }
        return null;
    }
}

