/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.rabbit.provisioning;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.amqp.AmqpConnectException;
import org.springframework.amqp.core.AnonymousQueue;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.DirectExchange;
import org.springframework.amqp.core.Exchange;
import org.springframework.amqp.core.ExchangeBuilder;
import org.springframework.amqp.core.FanoutExchange;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.core.TopicExchange;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.cloud.stream.binder.ExtendedConsumerProperties;
import org.springframework.cloud.stream.binder.ExtendedProducerProperties;
import org.springframework.cloud.stream.binder.rabbit.properties.RabbitCommonProperties;
import org.springframework.cloud.stream.binder.rabbit.properties.RabbitConsumerProperties;
import org.springframework.cloud.stream.binder.rabbit.properties.RabbitProducerProperties;
import org.springframework.cloud.stream.provisioning.ConsumerDestination;
import org.springframework.cloud.stream.provisioning.ProducerDestination;
import org.springframework.cloud.stream.provisioning.ProvisioningException;
import org.springframework.cloud.stream.provisioning.ProvisioningProvider;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class RabbitExchangeQueueProvisioner
implements ProvisioningProvider<ExtendedConsumerProperties<RabbitConsumerProperties>, ExtendedProducerProperties<RabbitProducerProperties>> {
    private static final AnonymousQueue.Base64UrlNamingStrategy ANONYMOUS_GROUP_NAME_GENERATOR = new AnonymousQueue.Base64UrlNamingStrategy("anonymous.");
    private static final String GROUP_INDEX_DELIMITER = ".";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final RabbitAdmin rabbitAdmin;
    private final GenericApplicationContext autoDeclareContext = new GenericApplicationContext();

    public RabbitExchangeQueueProvisioner(ConnectionFactory connectionFactory) {
        this.rabbitAdmin = new RabbitAdmin(connectionFactory);
        this.autoDeclareContext.refresh();
        this.rabbitAdmin.setApplicationContext((ApplicationContext)this.autoDeclareContext);
        this.rabbitAdmin.setIgnoreDeclarationExceptions(true);
        this.rabbitAdmin.afterPropertiesSet();
    }

    public ProducerDestination provisionProducerDestination(String name, ExtendedProducerProperties<RabbitProducerProperties> producerProperties) {
        String exchangeName = RabbitExchangeQueueProvisioner.applyPrefix(((RabbitProducerProperties)producerProperties.getExtension()).getPrefix(), name);
        Exchange exchange = this.buildExchange((RabbitCommonProperties)producerProperties.getExtension(), exchangeName);
        if (((RabbitProducerProperties)producerProperties.getExtension()).isDeclareExchange()) {
            this.declareExchange(exchangeName, exchange);
        }
        Binding binding = null;
        for (String requiredGroupName : producerProperties.getRequiredGroups()) {
            String baseQueueName = exchangeName + GROUP_INDEX_DELIMITER + requiredGroupName;
            if (!producerProperties.isPartitioned()) {
                Queue queue = new Queue(baseQueueName, true, false, false, this.queueArgs(baseQueueName, (RabbitCommonProperties)producerProperties.getExtension(), false));
                this.declareQueue(baseQueueName, queue);
                this.autoBindDLQ(baseQueueName, baseQueueName, (RabbitCommonProperties)producerProperties.getExtension());
                if (!((RabbitProducerProperties)producerProperties.getExtension()).isBindQueue()) continue;
                binding = this.notPartitionedBinding(exchange, queue, (RabbitCommonProperties)producerProperties.getExtension());
                continue;
            }
            for (int i = 0; i < producerProperties.getPartitionCount(); ++i) {
                String partitionSuffix = "-" + i;
                String partitionQueueName = baseQueueName + partitionSuffix;
                Queue queue = new Queue(partitionQueueName, true, false, false, this.queueArgs(partitionQueueName, (RabbitCommonProperties)producerProperties.getExtension(), false));
                this.declareQueue(queue.getName(), queue);
                this.autoBindDLQ(baseQueueName, baseQueueName + partitionSuffix, (RabbitCommonProperties)producerProperties.getExtension());
                if (!((RabbitProducerProperties)producerProperties.getExtension()).isBindQueue()) continue;
                String prefix = ((RabbitProducerProperties)producerProperties.getExtension()).getPrefix();
                String destination = StringUtils.isEmpty((Object)prefix) ? exchangeName : exchangeName.substring(prefix.length());
                binding = this.partitionedBinding(destination, exchange, queue, (RabbitCommonProperties)producerProperties.getExtension(), i);
            }
        }
        return new RabbitProducerDestination(exchange, binding);
    }

    public ConsumerDestination provisionConsumerDestination(String name, String group, ExtendedConsumerProperties<RabbitConsumerProperties> properties) {
        Queue queue;
        boolean durable;
        String baseQueueName;
        boolean anonymous = !StringUtils.hasText((String)group);
        String string = baseQueueName = anonymous ? this.groupedName(name, ANONYMOUS_GROUP_NAME_GENERATOR.generateName()) : this.groupedName(name, group);
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("declaring queue for inbound: " + baseQueueName + ", bound to: " + name));
        }
        String prefix = ((RabbitConsumerProperties)properties.getExtension()).getPrefix();
        String exchangeName = RabbitExchangeQueueProvisioner.applyPrefix(prefix, name);
        Exchange exchange = this.buildExchange((RabbitCommonProperties)properties.getExtension(), exchangeName);
        if (((RabbitConsumerProperties)properties.getExtension()).isDeclareExchange()) {
            this.declareExchange(exchangeName, exchange);
        }
        String queueName = RabbitExchangeQueueProvisioner.applyPrefix(prefix, baseQueueName);
        boolean partitioned = !anonymous && properties.isPartitioned();
        boolean bl = durable = !anonymous && ((RabbitConsumerProperties)properties.getExtension()).isDurableSubscription();
        if (anonymous) {
            queue = new Queue(queueName, false, true, true, this.queueArgs(queueName, (RabbitCommonProperties)properties.getExtension(), false));
        } else {
            if (partitioned) {
                String partitionSuffix = "-" + properties.getInstanceIndex();
                queueName = queueName + partitionSuffix;
            }
            queue = durable ? new Queue(queueName, true, false, false, this.queueArgs(queueName, (RabbitCommonProperties)properties.getExtension(), false)) : new Queue(queueName, false, false, true, this.queueArgs(queueName, (RabbitCommonProperties)properties.getExtension(), false));
        }
        this.declareQueue(queueName, queue);
        Binding binding = null;
        if (((RabbitConsumerProperties)properties.getExtension()).isBindQueue()) {
            binding = this.declareConsumerBindings(name, properties, exchange, partitioned, queue);
        }
        if (durable) {
            this.autoBindDLQ(RabbitExchangeQueueProvisioner.applyPrefix(((RabbitConsumerProperties)properties.getExtension()).getPrefix(), baseQueueName), queueName, (RabbitCommonProperties)properties.getExtension());
        }
        return new RabbitConsumerDestination(queue, binding);
    }

    protected final String groupedName(String name, String group) {
        return name + GROUP_INDEX_DELIMITER + (StringUtils.hasText((String)group) ? group : "default");
    }

    private Binding partitionedBinding(String destination, Exchange exchange, Queue queue, RabbitCommonProperties extendedProperties, int index) {
        String bindingKey = extendedProperties.getBindingRoutingKey();
        if (bindingKey == null) {
            bindingKey = destination;
        }
        bindingKey = bindingKey + "-" + index;
        if (exchange instanceof TopicExchange) {
            Binding binding = BindingBuilder.bind((Queue)queue).to((TopicExchange)exchange).with(bindingKey);
            this.declareBinding(queue.getName(), binding);
            return binding;
        }
        if (exchange instanceof DirectExchange) {
            Binding binding = BindingBuilder.bind((Queue)queue).to((DirectExchange)exchange).with(bindingKey);
            this.declareBinding(queue.getName(), binding);
            return binding;
        }
        if (exchange instanceof FanoutExchange) {
            throw new ProvisioningException("A fanout exchange is not appropriate for partitioned apps");
        }
        throw new ProvisioningException("Cannot bind to a " + exchange.getType() + " exchange");
    }

    private Binding declareConsumerBindings(String name, ExtendedConsumerProperties<RabbitConsumerProperties> properties, Exchange exchange, boolean partitioned, Queue queue) {
        if (partitioned) {
            return this.partitionedBinding(name, exchange, queue, (RabbitCommonProperties)properties.getExtension(), properties.getInstanceIndex());
        }
        return this.notPartitionedBinding(exchange, queue, (RabbitCommonProperties)properties.getExtension());
    }

    private Binding notPartitionedBinding(Exchange exchange, Queue queue, RabbitCommonProperties extendedProperties) {
        String routingKey = extendedProperties.getBindingRoutingKey();
        if (routingKey == null) {
            routingKey = "#";
        }
        if (exchange instanceof TopicExchange) {
            Binding binding = BindingBuilder.bind((Queue)queue).to((TopicExchange)exchange).with(routingKey);
            this.declareBinding(queue.getName(), binding);
            return binding;
        }
        if (exchange instanceof DirectExchange) {
            Binding binding = BindingBuilder.bind((Queue)queue).to((DirectExchange)exchange).with(routingKey);
            this.declareBinding(queue.getName(), binding);
            return binding;
        }
        if (exchange instanceof FanoutExchange) {
            Binding binding = BindingBuilder.bind((Queue)queue).to((FanoutExchange)exchange);
            this.declareBinding(queue.getName(), binding);
            return binding;
        }
        throw new ProvisioningException("Cannot bind to a " + exchange.getType() + " exchange");
    }

    private void autoBindDLQ(String baseQueueName, String routingKey, RabbitCommonProperties properties) {
        boolean autoBindDlq = properties.isAutoBindDlq();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("autoBindDLQ=" + autoBindDlq + " for: " + baseQueueName));
        }
        if (autoBindDlq) {
            String dlqName = properties.getDeadLetterQueueName() == null ? RabbitExchangeQueueProvisioner.constructDLQName(baseQueueName) : properties.getDeadLetterQueueName();
            Queue dlq = new Queue(dlqName, true, false, false, this.queueArgs(dlqName, properties, true));
            this.declareQueue(dlqName, dlq);
            String dlxName = this.deadLetterExchangeName(properties);
            DirectExchange dlx = new DirectExchange(dlxName);
            this.declareExchange(dlxName, (Exchange)dlx);
            BindingBuilder.DirectExchangeRoutingKeyConfigurer bindingBuilder = BindingBuilder.bind((Queue)dlq).to(dlx);
            Binding dlqBinding = properties.getDeadLetterRoutingKey() == null ? bindingBuilder.with(routingKey) : bindingBuilder.with(properties.getDeadLetterRoutingKey());
            this.declareBinding(dlqName, dlqBinding);
            if (properties instanceof RabbitConsumerProperties && ((RabbitConsumerProperties)properties).isRepublishToDlq()) {
                this.declareBinding(dlqName, BindingBuilder.bind((Queue)dlq).to(dlx).with(baseQueueName));
            }
        }
    }

    public static String constructDLQName(String name) {
        return name + ".dlq";
    }

    private String deadLetterExchangeName(RabbitCommonProperties properties) {
        if (properties.getDeadLetterExchange() == null) {
            return properties.getPrefix() + "DLX";
        }
        return properties.getDeadLetterExchange();
    }

    private void declareQueue(String beanName, Queue queue) {
        block2: {
            try {
                this.rabbitAdmin.declareQueue(queue);
            }
            catch (AmqpConnectException e) {
                if (!this.logger.isDebugEnabled()) break block2;
                this.logger.debug((Object)("Declaration of queue: " + queue.getName() + " deferred - connection not available"));
            }
        }
        this.addToAutoDeclareContext(beanName, queue);
    }

    private Map<String, Object> queueArgs(String queueName, RabbitCommonProperties properties, boolean isDlq) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        if (!isDlq) {
            if (properties.isAutoBindDlq()) {
                String dlx = properties.getDeadLetterExchange() != null ? properties.getDeadLetterExchange() : RabbitExchangeQueueProvisioner.applyPrefix(properties.getPrefix(), "DLX");
                args.put("x-dead-letter-exchange", dlx);
                String dlRk = properties.getDeadLetterRoutingKey() != null ? properties.getDeadLetterRoutingKey() : queueName;
                args.put("x-dead-letter-routing-key", dlRk);
            }
            this.additionalArgs(args, properties.getExpires(), properties.getMaxLength(), properties.getMaxLengthBytes(), properties.getMaxPriority(), properties.getTtl());
        } else {
            if (properties.getDlqDeadLetterExchange() != null) {
                args.put("x-dead-letter-exchange", properties.getDlqDeadLetterExchange());
            }
            if (properties.getDlqDeadLetterRoutingKey() != null) {
                args.put("x-dead-letter-routing-key", properties.getDlqDeadLetterRoutingKey());
            }
            this.additionalArgs(args, properties.getDlqExpires(), properties.getDlqMaxLength(), properties.getDlqMaxLengthBytes(), properties.getDlqMaxPriority(), properties.getDlqTtl());
        }
        return args;
    }

    private void additionalArgs(Map<String, Object> args, Integer expires, Integer maxLength, Integer maxLengthBytes, Integer maxPriority, Integer ttl) {
        if (expires != null) {
            args.put("x-expires", expires);
        }
        if (maxLength != null) {
            args.put("x-max-length", maxLength);
        }
        if (maxLengthBytes != null) {
            args.put("x-max-length-bytes", maxLengthBytes);
        }
        if (maxPriority != null) {
            args.put("x-max-priority", maxPriority);
        }
        if (ttl != null) {
            args.put("x-message-ttl", ttl);
        }
    }

    public static String applyPrefix(String prefix, String name) {
        return prefix + name;
    }

    private Exchange buildExchange(RabbitCommonProperties properties, String exchangeName) {
        try {
            ExchangeBuilder builder = new ExchangeBuilder(exchangeName, properties.getExchangeType());
            if (properties.isExchangeDurable()) {
                builder.durable();
            }
            if (properties.isExchangeAutoDelete()) {
                builder.autoDelete();
            }
            if (properties.isDelayedExchange()) {
                builder.delayed();
            }
            return builder.build();
        }
        catch (Exception e) {
            throw new ProvisioningException("Failed to create exchange object", (Throwable)e);
        }
    }

    private void declareExchange(String rootName, Exchange exchange) {
        block2: {
            try {
                this.rabbitAdmin.declareExchange(exchange);
            }
            catch (AmqpConnectException e) {
                if (!this.logger.isDebugEnabled()) break block2;
                this.logger.debug((Object)("Declaration of exchange: " + exchange.getName() + " deferred - connection not available"));
            }
        }
        this.addToAutoDeclareContext(rootName + ".exchange", exchange);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToAutoDeclareContext(String name, Object bean) {
        GenericApplicationContext genericApplicationContext = this.autoDeclareContext;
        synchronized (genericApplicationContext) {
            if (!this.autoDeclareContext.containsBean(name)) {
                this.autoDeclareContext.getBeanFactory().registerSingleton(name, bean);
            }
        }
    }

    private void declareBinding(String rootName, Binding binding) {
        block2: {
            try {
                this.rabbitAdmin.declareBinding(binding);
            }
            catch (AmqpConnectException e) {
                if (!this.logger.isDebugEnabled()) break block2;
                this.logger.debug((Object)("Declaration of binding: " + rootName + ".binding deferred - connection not available"));
            }
        }
        this.addToAutoDeclareContext(rootName + ".binding", binding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanAutoDeclareContext(String name) {
        GenericApplicationContext genericApplicationContext = this.autoDeclareContext;
        synchronized (genericApplicationContext) {
            this.removeSingleton(name + ".binding");
            this.removeSingleton(name);
            String dlq = name + ".dlq";
            this.removeSingleton(dlq + ".binding");
            this.removeSingleton(dlq);
        }
    }

    private void removeSingleton(String name) {
        ConfigurableListableBeanFactory beanFactory;
        if (this.autoDeclareContext.containsBean(name) && (beanFactory = this.autoDeclareContext.getBeanFactory()) instanceof DefaultListableBeanFactory) {
            ((DefaultListableBeanFactory)beanFactory).destroySingleton(name);
        }
    }

    private static final class RabbitConsumerDestination
    implements ConsumerDestination {
        private final Queue queue;
        private final Binding binding;

        RabbitConsumerDestination(Queue queue, Binding binding) {
            Assert.notNull((Object)queue, (String)"queue must not be null");
            this.queue = queue;
            this.binding = binding;
        }

        public String toString() {
            return "RabbitConsumerDestination{queue=" + this.queue + ", binding=" + this.binding + '}';
        }

        public String getName() {
            return this.queue.getName();
        }
    }

    private static final class RabbitProducerDestination
    implements ProducerDestination {
        private final Exchange exchange;
        private final Binding binding;

        RabbitProducerDestination(Exchange exchange, Binding binding) {
            Assert.notNull((Object)exchange, (String)"exchange must not be null");
            this.exchange = exchange;
            this.binding = binding;
        }

        public String getName() {
            return this.exchange.getName();
        }

        public String getNameForPartition(int partition) {
            return this.exchange.getName();
        }

        public String toString() {
            return "RabbitProducerDestination{exchange=" + this.exchange + ", binding=" + this.binding + '}';
        }
    }
}

