/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.client.feign;

import feign.Request;
import java.nio.charset.Charset;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.springframework.cloud.sleuth.SpanTextMap;
import org.springframework.util.StringUtils;

class FeignRequestTextMap
implements SpanTextMap {
    private final AtomicReference<Request> delegate;

    FeignRequestTextMap(AtomicReference<Request> delegate) {
        this.delegate = delegate;
    }

    @Override
    public Iterator<Map.Entry<String, String>> iterator() {
        final Iterator iterator = this.delegate.get().headers().entrySet().iterator();
        return new Iterator<Map.Entry<String, String>>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public Map.Entry<String, String> next() {
                Map.Entry next = (Map.Entry)iterator.next();
                Collection value = (Collection)next.getValue();
                return new AbstractMap.SimpleEntry<String, String>((String)next.getKey(), value.isEmpty() ? "" : (String)value.iterator().next());
            }
        };
    }

    @Override
    public void put(String key, String value) {
        if (!StringUtils.hasText((String)value)) {
            return;
        }
        String method = this.delegate.get().method();
        String url = this.delegate.get().url();
        HashMap<String, Collection<String>> headers = new HashMap<String, Collection<String>>(this.delegate.get().headers());
        byte[] body = this.delegate.get().body();
        Charset charset = this.delegate.get().charset();
        this.addHeader(key, value, headers);
        this.delegate.set(Request.create((String)method, (String)url, headers, (byte[])body, (Charset)charset));
    }

    private void addHeader(String key, String value, Map<String, Collection<String>> headers) {
        if (!headers.containsKey(key)) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(value);
            headers.put(key, list);
        }
    }
}

