/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.client.feign;

import feign.Request;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.SpanInjector;
import org.springframework.util.StringUtils;

class FeignRequestInjector
implements SpanInjector<AtomicReference<Request>> {
    FeignRequestInjector() {
    }

    @Override
    public void inject(Span span, AtomicReference<Request> carrier) {
        String method = carrier.get().method();
        String url = carrier.get().url();
        HashMap<String, Collection<String>> headers = new HashMap<String, Collection<String>>(carrier.get().headers());
        byte[] body = carrier.get().body();
        Charset charset = carrier.get().charset();
        if (span == null) {
            this.setHeader(headers, "X-B3-Sampled", "0");
            carrier.set(Request.create((String)method, (String)url, headers, (byte[])body, (Charset)charset));
            return;
        }
        this.setHeader(headers, "X-B3-TraceId", Span.idToHex(span.getTraceId()));
        this.setHeader(headers, "X-Span-Name", span.getName());
        this.setHeader(headers, "X-B3-SpanId", Span.idToHex(span.getSpanId()));
        this.setHeader(headers, "X-B3-Sampled", span.isExportable() ? "1" : "0");
        Long parentId = this.getParentId(span);
        if (parentId != null) {
            this.setHeader(headers, "X-B3-ParentSpanId", Span.idToHex(parentId));
        }
        this.setHeader(headers, "X-Process-Id", span.getProcessId());
        carrier.set(Request.create((String)method, (String)url, headers, (byte[])body, (Charset)charset));
    }

    private Long getParentId(Span span) {
        return !span.getParents().isEmpty() ? span.getParents().get(0) : null;
    }

    protected void setHeader(Map<String, Collection<String>> headers, String name, String value) {
        if (StringUtils.hasText((String)value) && !headers.containsKey(name)) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(value);
            headers.put(name, list);
        }
    }
}

