/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.client;

import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.autoconfigure.security.oauth2.resource.UserInfoRestTemplateCustomizer;
import org.springframework.cloud.sleuth.instrument.web.client.RestTemplateInterceptorInjector;
import org.springframework.cloud.sleuth.instrument.web.client.TraceRestTemplateInterceptor;
import org.springframework.security.oauth2.client.OAuth2RestTemplate;
import org.springframework.web.client.RestTemplate;

class TraceUserInfoRestTemplateCustomizer
implements UserInfoRestTemplateCustomizer {
    private final BeanFactory beanFactory;
    private final Object delegate;

    TraceUserInfoRestTemplateCustomizer(BeanFactory beanFactory) {
        this(beanFactory, null);
    }

    TraceUserInfoRestTemplateCustomizer(BeanFactory beanFactory, Object bean) {
        this.beanFactory = beanFactory;
        this.delegate = bean;
    }

    public void customize(OAuth2RestTemplate template) {
        TraceRestTemplateInterceptor interceptor = (TraceRestTemplateInterceptor)this.beanFactory.getBean(TraceRestTemplateInterceptor.class);
        new RestTemplateInterceptorInjector(interceptor).inject((RestTemplate)template);
        if (this.delegate != null) {
            ((UserInfoRestTemplateCustomizer)this.delegate).customize(template);
        }
    }
}

