/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.regex.Pattern;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.cloud.sleuth.ErrorParser;
import org.springframework.cloud.sleuth.ExceptionMessageErrorParser;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.SpanReporter;
import org.springframework.cloud.sleuth.TraceKeys;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.web.HttpServletRequestTextMap;
import org.springframework.cloud.sleuth.instrument.web.HttpSpanExtractor;
import org.springframework.cloud.sleuth.instrument.web.HttpTraceKeysInjector;
import org.springframework.cloud.sleuth.instrument.web.ServletUtils;
import org.springframework.cloud.sleuth.instrument.web.SsLogSetter;
import org.springframework.cloud.sleuth.instrument.web.TraceHttpServletResponse;
import org.springframework.cloud.sleuth.instrument.web.TraceRequestAttributes;
import org.springframework.cloud.sleuth.instrument.web.TraceWebAutoConfiguration;
import org.springframework.cloud.sleuth.sampler.AlwaysSampler;
import org.springframework.cloud.sleuth.sampler.NeverSampler;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.async.WebAsyncUtils;
import org.springframework.web.filter.GenericFilterBean;
import org.springframework.web.util.UrlPathHelper;

@Order(value=-2147483643)
public class TraceFilter
extends GenericFilterBean {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private static final String HTTP_COMPONENT = "http";
    public static final int ORDER = -2147483643;
    protected static final String TRACE_REQUEST_ATTR = TraceFilter.class.getName() + ".TRACE";
    protected static final String TRACE_ERROR_HANDLED_REQUEST_ATTR = TraceFilter.class.getName() + ".ERROR_HANDLED";
    protected static final String TRACE_CLOSE_SPAN_REQUEST_ATTR = TraceFilter.class.getName() + ".CLOSE_SPAN";
    @Deprecated
    public static final String DEFAULT_SKIP_PATTERN = "/api-docs.*|/autoconfig|/configprops|/dump|/health|/info|/metrics.*|/mappings|/trace|/swagger.*|.*\\.png|.*\\.css|.*\\.js|.*\\.html|/favicon.ico|/hystrix.stream";
    private Tracer tracer;
    private TraceKeys traceKeys;
    private Pattern skipPattern;
    private SpanReporter spanReporter;
    private HttpSpanExtractor spanExtractor;
    private HttpTraceKeysInjector httpTraceKeysInjector;
    private ErrorParser errorParser;
    private BeanFactory beanFactory;
    private UrlPathHelper urlPathHelper = new UrlPathHelper();

    @Deprecated
    public TraceFilter(Tracer tracer, TraceKeys traceKeys, SpanReporter spanReporter, HttpSpanExtractor spanExtractor, HttpTraceKeysInjector httpTraceKeysInjector) {
        this(tracer, traceKeys, Pattern.compile(DEFAULT_SKIP_PATTERN), spanReporter, spanExtractor, httpTraceKeysInjector);
    }

    @Deprecated
    public TraceFilter(Tracer tracer, TraceKeys traceKeys, Pattern skipPattern, SpanReporter spanReporter, HttpSpanExtractor spanExtractor, HttpTraceKeysInjector httpTraceKeysInjector) {
        this.tracer = tracer;
        this.traceKeys = traceKeys;
        this.skipPattern = skipPattern;
        this.spanReporter = spanReporter;
        this.spanExtractor = spanExtractor;
        this.httpTraceKeysInjector = httpTraceKeysInjector;
        this.errorParser = new ExceptionMessageErrorParser();
    }

    public TraceFilter(BeanFactory beanFactory) {
        this(beanFactory, TraceFilter.skipPattern(beanFactory));
    }

    public TraceFilter(BeanFactory beanFactory, Pattern skipPattern) {
        this.beanFactory = beanFactory;
        this.skipPattern = skipPattern;
    }

    private static Pattern skipPattern(BeanFactory beanFactory) {
        block3: {
            try {
                TraceWebAutoConfiguration.SkipPatternProvider patternProvider = (TraceWebAutoConfiguration.SkipPatternProvider)beanFactory.getBean(TraceWebAutoConfiguration.SkipPatternProvider.class);
                if (patternProvider != null) {
                    return patternProvider.skipPattern();
                }
            }
            catch (NoSuchBeanDefinitionException e) {
                if (!log.isDebugEnabled()) break block3;
                log.debug((Object)"The default SkipPatternProvider implementation is missing, will fallback to a default value of patterns");
            }
        }
        return Pattern.compile(DEFAULT_SKIP_PATTERN);
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (!(servletRequest instanceof HttpServletRequest) || !(servletResponse instanceof HttpServletResponse)) {
            throw new ServletException("Filter just supports HTTP requests");
        }
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String uri = this.urlPathHelper.getPathWithinApplication(request);
        boolean skip = this.skipPattern.matcher(uri).matches() || "0".equals(ServletUtils.getHeader(request, response, "X-B3-Sampled"));
        Span spanFromRequest = this.getSpanFromAttribute(request);
        if (spanFromRequest != null) {
            this.continueSpan(request, spanFromRequest);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Received a request to uri [" + uri + "] that should not be sampled [" + skip + "]"));
        }
        if (!this.httpStatusSuccessful(response) && this.isSpanContinued(request)) {
            Span parentSpan = this.parentSpan(spanFromRequest);
            this.processErrorRequest(filterChain, request, (HttpServletResponse)new TraceHttpServletResponse(response, parentSpan), spanFromRequest);
            return;
        }
        String name = "http:" + uri;
        Throwable exception = null;
        try {
            spanFromRequest = this.createSpan(request, skip, spanFromRequest, name);
            filterChain.doFilter((ServletRequest)request, (ServletResponse)new TraceHttpServletResponse(response, spanFromRequest));
        }
        catch (Throwable e) {
            exception = e;
            this.errorParser().parseErrorTags(this.tracer().getCurrentSpan(), e);
            throw e;
        }
        finally {
            if (this.isAsyncStarted(request) || request.isAsyncStarted()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("The span " + spanFromRequest + " will get detached by a HandleInterceptor"));
                }
                return;
            }
            spanFromRequest = this.createSpanIfRequestNotHandled(request, spanFromRequest, name, skip);
            this.detachOrCloseSpans(request, response, spanFromRequest, exception);
        }
    }

    private Span parentSpan(Span span) {
        if (span == null) {
            return null;
        }
        if (span.hasSavedSpan()) {
            return span.getSavedSpan();
        }
        return span;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processErrorRequest(FilterChain filterChain, HttpServletRequest request, HttpServletResponse response, Span spanFromRequest) throws IOException, ServletException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("The span " + spanFromRequest + " was already detached once and we're processing an error"));
        }
        try {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            request.setAttribute(TRACE_ERROR_HANDLED_REQUEST_ATTR, (Object)true);
            this.addResponseTags(response, null);
            if (request.getAttribute(TraceRequestAttributes.ERROR_HANDLED_SPAN_REQUEST_ATTR) == null) {
                this.tracer().close(spanFromRequest);
            }
        }
    }

    private void continueSpan(HttpServletRequest request, Span spanFromRequest) {
        this.tracer().continueSpan(spanFromRequest);
        request.setAttribute(TraceRequestAttributes.SPAN_CONTINUED_REQUEST_ATTR, (Object)"true");
        if (log.isDebugEnabled()) {
            log.debug((Object)("There has already been a span in the request " + spanFromRequest));
        }
    }

    private Span createSpanIfRequestNotHandled(HttpServletRequest request, Span spanFromRequest, String name, boolean skip) {
        if (!this.requestHasAlreadyBeenHandled(request)) {
            spanFromRequest = this.tracer().createSpan(name);
            request.setAttribute(TRACE_REQUEST_ATTR, (Object)spanFromRequest);
            if (log.isDebugEnabled() && !skip) {
                log.debug((Object)("The request with uri [" + request.getRequestURI() + "] hasn't been handled by any of Sleuth's components. That means that most likely you're using custom HandlerMappings and didn't add Sleuth's TraceHandlerInterceptor. Sleuth will create a span to ensure that the graph of calls remains valid in Zipkin"));
            }
        }
        return spanFromRequest;
    }

    private boolean requestHasAlreadyBeenHandled(HttpServletRequest request) {
        return request.getAttribute(TraceRequestAttributes.HANDLED_SPAN_REQUEST_ATTR) != null;
    }

    private void detachOrCloseSpans(HttpServletRequest request, HttpServletResponse response, Span spanFromRequest, Throwable exception) {
        Span span = spanFromRequest;
        if (span != null) {
            this.addResponseTags(response, exception);
            if (span.hasSavedSpan() && this.requestHasAlreadyBeenHandled(request)) {
                this.recordParentSpan(span.getSavedSpan());
            } else if (!this.requestHasAlreadyBeenHandled(request)) {
                span = this.tracer().close(span);
            }
            this.recordParentSpan(span);
            if (this.httpStatusSuccessful(response) && this.tracer().isTracing()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Closing the span " + span + " since the response was successful"));
                }
                this.tracer().close(span);
                this.clearTraceAttribute(request);
            } else if (this.errorAlreadyHandled(request) && this.tracer().isTracing() && !this.shouldCloseSpan(request)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Won't detach the span " + span + " since error has already been handled"));
                }
            } else if (this.shouldCloseSpan(request) && this.tracer().isTracing() && this.stillTracingCurrentSapn(span)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Will close span " + span + " since some component marked it for closure"));
                }
                this.tracer().close(span);
                this.clearTraceAttribute(request);
            } else if (this.tracer().isTracing()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Detaching the span " + span + " since the response was unsuccessful"));
                }
                this.tracer().detach(span);
                this.clearTraceAttribute(request);
            }
        }
    }

    private boolean stillTracingCurrentSapn(Span span) {
        return this.tracer().getCurrentSpan().equals(span);
    }

    private void recordParentSpan(Span parent) {
        if (parent == null) {
            return;
        }
        if (parent.isRemote()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Trying to send the parent span " + parent + " to Zipkin"));
            }
            parent.stop();
            SsLogSetter.annotateWithServerSendIfLogIsNotAlreadyPresent(parent);
            this.spanReporter().report(parent);
        } else {
            SsLogSetter.annotateWithServerSendIfLogIsNotAlreadyPresent(parent);
        }
    }

    private boolean httpStatusSuccessful(HttpServletResponse response) {
        if (response.getStatus() == 0) {
            return false;
        }
        HttpStatus.Series httpStatusSeries = HttpStatus.Series.valueOf((int)response.getStatus());
        return httpStatusSeries == HttpStatus.Series.SUCCESSFUL || httpStatusSeries == HttpStatus.Series.REDIRECTION;
    }

    private Span getSpanFromAttribute(HttpServletRequest request) {
        return (Span)request.getAttribute(TRACE_REQUEST_ATTR);
    }

    private void clearTraceAttribute(HttpServletRequest request) {
        request.setAttribute(TRACE_REQUEST_ATTR, null);
    }

    private boolean errorAlreadyHandled(HttpServletRequest request) {
        return Boolean.valueOf(String.valueOf(request.getAttribute(TRACE_ERROR_HANDLED_REQUEST_ATTR)));
    }

    private boolean shouldCloseSpan(HttpServletRequest request) {
        return Boolean.valueOf(String.valueOf(request.getAttribute(TRACE_CLOSE_SPAN_REQUEST_ATTR)));
    }

    private boolean isSpanContinued(HttpServletRequest request) {
        return this.getSpanFromAttribute(request) != null;
    }

    private void addRequestTagsForParentSpan(HttpServletRequest request, Span spanFromRequest) {
        if (spanFromRequest.getName().contains("parent")) {
            this.addRequestTags(spanFromRequest, request);
        }
    }

    private Span createSpan(HttpServletRequest request, boolean skip, Span spanFromRequest, String name) {
        if (spanFromRequest != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Span has already been created - continuing with the previous one");
            }
            return spanFromRequest;
        }
        Span parent = this.spanExtractor().joinTrace(new HttpServletRequestTextMap(request));
        if (parent != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found a parent span " + parent + " in the request"));
            }
            this.addRequestTagsForParentSpan(request, parent);
            spanFromRequest = parent;
            this.tracer().continueSpan(spanFromRequest);
            if (parent.isRemote()) {
                parent.logEvent("sr");
            }
            request.setAttribute(TRACE_REQUEST_ATTR, (Object)spanFromRequest);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Parent span is " + parent + ""));
            }
        } else {
            String header;
            spanFromRequest = skip ? this.tracer().createSpan(name, NeverSampler.INSTANCE) : ("1".equals(header = request.getHeader("X-B3-Flags")) ? this.tracer().createSpan(name, new AlwaysSampler()) : this.tracer().createSpan(name));
            spanFromRequest.logEvent("sr");
            request.setAttribute(TRACE_REQUEST_ATTR, (Object)spanFromRequest);
            if (log.isDebugEnabled()) {
                log.debug((Object)"No parent span present - creating a new span");
            }
        }
        return spanFromRequest;
    }

    protected void addRequestTags(Span span, HttpServletRequest request) {
        String uri = this.urlPathHelper.getPathWithinApplication(request);
        this.keysInjector().addRequestTags(span, this.getFullUrl(request), request.getServerName(), uri, request.getMethod());
        for (String name : this.traceKeys().getHttp().getHeaders()) {
            Enumeration values = request.getHeaders(name);
            if (!values.hasMoreElements()) continue;
            String key = this.traceKeys().getHttp().getPrefix() + name.toLowerCase();
            ArrayList list = Collections.list(values);
            String value = list.size() == 1 ? (String)list.get(0) : StringUtils.collectionToDelimitedString(list, (String)",", (String)"'", (String)"'");
            this.keysInjector().tagSpan(span, key, value);
        }
    }

    protected void addResponseTags(HttpServletResponse response, Throwable e) {
        int httpStatus = response.getStatus();
        if (httpStatus == 200 && e != null) {
            this.tracer().addTag(this.traceKeys().getHttp().getStatusCode(), String.valueOf(500));
        } else if (httpStatus >= 100 && httpStatus < 200 || httpStatus > 399) {
            this.tracer().addTag(this.traceKeys().getHttp().getStatusCode(), String.valueOf(response.getStatus()));
        }
    }

    protected boolean isAsyncStarted(HttpServletRequest request) {
        return WebAsyncUtils.getAsyncManager((ServletRequest)request).isConcurrentHandlingStarted();
    }

    private String getFullUrl(HttpServletRequest request) {
        StringBuffer requestURI = request.getRequestURL();
        String queryString = request.getQueryString();
        if (queryString == null) {
            return requestURI.toString();
        }
        return requestURI.append('?').append(queryString).toString();
    }

    Tracer tracer() {
        if (this.tracer == null) {
            this.tracer = (Tracer)this.beanFactory.getBean(Tracer.class);
        }
        return this.tracer;
    }

    TraceKeys traceKeys() {
        if (this.traceKeys == null) {
            this.traceKeys = (TraceKeys)this.beanFactory.getBean(TraceKeys.class);
        }
        return this.traceKeys;
    }

    SpanReporter spanReporter() {
        if (this.spanReporter == null) {
            this.spanReporter = (SpanReporter)this.beanFactory.getBean(SpanReporter.class);
        }
        return this.spanReporter;
    }

    HttpSpanExtractor spanExtractor() {
        if (this.spanExtractor == null) {
            this.spanExtractor = (HttpSpanExtractor)this.beanFactory.getBean(HttpSpanExtractor.class);
        }
        return this.spanExtractor;
    }

    HttpTraceKeysInjector keysInjector() {
        if (this.httpTraceKeysInjector == null) {
            this.httpTraceKeysInjector = (HttpTraceKeysInjector)this.beanFactory.getBean(HttpTraceKeysInjector.class);
        }
        return this.httpTraceKeysInjector;
    }

    ErrorParser errorParser() {
        if (this.errorParser == null) {
            this.errorParser = (ErrorParser)this.beanFactory.getBean(ErrorParser.class);
        }
        return this.errorParser;
    }
}

