/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.cloud.sleuth.SpanTextMap;
import org.springframework.web.util.UrlPathHelper;

class HttpServletRequestTextMap
implements SpanTextMap {
    private final HttpServletRequest delegate;
    private final Map<String, String> additionalHeaders = new HashMap<String, String>();

    HttpServletRequestTextMap(HttpServletRequest delegate) {
        this.delegate = delegate;
        UrlPathHelper urlPathHelper = new UrlPathHelper();
        this.additionalHeaders.put("X-Span-Uri", urlPathHelper.getPathWithinApplication(delegate));
    }

    @Override
    public Iterator<Map.Entry<String, String>> iterator() {
        HashMap<String, String> map = new HashMap<String, String>();
        Enumeration headerNames = this.delegate.getHeaderNames();
        while (headerNames != null && headerNames.hasMoreElements()) {
            String name = (String)headerNames.nextElement();
            map.put(name, this.delegate.getHeader(name));
        }
        map.putAll(this.additionalHeaders);
        return map.entrySet().iterator();
    }

    @Override
    public void put(String key, String value) {
        this.additionalHeaders.put(key, value);
    }
}

