/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.messaging;

import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.sleuth.TraceKeys;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.messaging.HeaderBasedMessagingExtractor;
import org.springframework.cloud.sleuth.instrument.messaging.HeaderBasedMessagingInjector;
import org.springframework.cloud.sleuth.instrument.messaging.MessagingSpanTextMapExtractor;
import org.springframework.cloud.sleuth.instrument.messaging.MessagingSpanTextMapInjector;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.messaging.Message;

@Configuration
@ConditionalOnClass(value={Message.class})
@ConditionalOnBean(value={Tracer.class})
public class TraceSpanMessagingAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public MessagingSpanTextMapExtractor messagingSpanExtractor() {
        return new HeaderBasedMessagingExtractor();
    }

    @Bean
    @ConditionalOnMissingBean
    public MessagingSpanTextMapInjector messagingSpanInjector(TraceKeys traceKeys) {
        return new HeaderBasedMessagingInjector(traceKeys);
    }
}

