/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth;

import java.lang.invoke.MethodHandles;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.sleuth.ErrorParser;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.util.ExceptionUtils;

public class ExceptionMessageErrorParser
implements ErrorParser {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());

    @Override
    public void parseErrorTags(Span span, Throwable error) {
        if (span != null && span.isExportable()) {
            String errorMsg = ExceptionUtils.getExceptionMessage(error);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Adding an error tag [" + errorMsg + "] to span " + span));
            }
            span.tag("error", errorMsg);
        }
    }
}

