/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.ribbon.apache;

import com.netflix.client.RequestSpecificRetryHandler;
import com.netflix.client.RetryHandler;
import com.netflix.client.config.CommonClientConfigKey;
import com.netflix.client.config.IClientConfig;
import java.net.URI;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.InterceptorRetryPolicy;
import org.springframework.cloud.client.loadbalancer.LoadBalancedBackOffPolicyFactory;
import org.springframework.cloud.client.loadbalancer.LoadBalancedRetryContext;
import org.springframework.cloud.client.loadbalancer.LoadBalancedRetryListenerFactory;
import org.springframework.cloud.client.loadbalancer.LoadBalancedRetryPolicy;
import org.springframework.cloud.client.loadbalancer.LoadBalancedRetryPolicyFactory;
import org.springframework.cloud.client.loadbalancer.RibbonRecoveryCallback;
import org.springframework.cloud.client.loadbalancer.ServiceInstanceChooser;
import org.springframework.cloud.netflix.ribbon.RibbonLoadBalancerClient;
import org.springframework.cloud.netflix.ribbon.RibbonLoadBalancerContext;
import org.springframework.cloud.netflix.ribbon.RibbonStatsRecorder;
import org.springframework.cloud.netflix.ribbon.ServerIntrospector;
import org.springframework.cloud.netflix.ribbon.apache.HttpClientStatusCodeException;
import org.springframework.cloud.netflix.ribbon.apache.HttpClientUtils;
import org.springframework.cloud.netflix.ribbon.apache.RibbonApacheHttpRequest;
import org.springframework.cloud.netflix.ribbon.apache.RibbonApacheHttpResponse;
import org.springframework.cloud.netflix.ribbon.apache.RibbonLoadBalancingHttpClient;
import org.springframework.cloud.netflix.ribbon.support.ContextAwareRequest;
import org.springframework.http.HttpRequest;
import org.springframework.retry.RecoveryCallback;
import org.springframework.retry.RetryCallback;
import org.springframework.retry.RetryContext;
import org.springframework.retry.RetryListener;
import org.springframework.retry.backoff.BackOffPolicy;
import org.springframework.retry.backoff.NoBackOffPolicy;
import org.springframework.retry.policy.NeverRetryPolicy;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class RetryableRibbonLoadBalancingHttpClient
extends RibbonLoadBalancingHttpClient {
    private LoadBalancedRetryPolicyFactory loadBalancedRetryPolicyFactory = new LoadBalancedRetryPolicyFactory.NeverRetryFactory();
    private LoadBalancedBackOffPolicyFactory loadBalancedBackOffPolicyFactory = new LoadBalancedBackOffPolicyFactory.NoBackOffPolicyFactory();
    private LoadBalancedRetryListenerFactory loadBalancedRetryListenerFactory = new LoadBalancedRetryListenerFactory.DefaultRetryListenerFactory();
    private RibbonLoadBalancerContext ribbonLoadBalancerContext;
    private static final Log LOGGER = LogFactory.getLog(RetryableRibbonLoadBalancingHttpClient.class);

    @Deprecated
    public RetryableRibbonLoadBalancingHttpClient(IClientConfig config, ServerIntrospector serverIntrospector, LoadBalancedRetryPolicyFactory loadBalancedRetryPolicyFactory) {
        super(config, serverIntrospector);
        this.loadBalancedRetryPolicyFactory = loadBalancedRetryPolicyFactory;
    }

    @Deprecated
    public RetryableRibbonLoadBalancingHttpClient(CloseableHttpClient delegate, IClientConfig config, ServerIntrospector serverIntrospector, LoadBalancedRetryPolicyFactory loadBalancedRetryPolicyFactory) {
        super(delegate, config, serverIntrospector);
        this.loadBalancedRetryPolicyFactory = loadBalancedRetryPolicyFactory;
    }

    @Deprecated
    public RetryableRibbonLoadBalancingHttpClient(CloseableHttpClient delegate, IClientConfig config, ServerIntrospector serverIntrospector, LoadBalancedRetryPolicyFactory loadBalancedRetryPolicyFactory, LoadBalancedBackOffPolicyFactory loadBalancedBackOffPolicyFactory) {
        super(delegate, config, serverIntrospector);
        this.loadBalancedRetryPolicyFactory = loadBalancedRetryPolicyFactory;
        this.loadBalancedBackOffPolicyFactory = loadBalancedBackOffPolicyFactory;
    }

    public RetryableRibbonLoadBalancingHttpClient(CloseableHttpClient delegate, IClientConfig config, ServerIntrospector serverIntrospector, LoadBalancedRetryPolicyFactory loadBalancedRetryPolicyFactory, LoadBalancedBackOffPolicyFactory loadBalancedBackOffPolicyFactory, LoadBalancedRetryListenerFactory loadBalancedRetryListenerFactory) {
        super(delegate, config, serverIntrospector);
        this.loadBalancedRetryPolicyFactory = loadBalancedRetryPolicyFactory;
        this.loadBalancedBackOffPolicyFactory = loadBalancedBackOffPolicyFactory;
        this.loadBalancedRetryListenerFactory = loadBalancedRetryListenerFactory;
    }

    @Override
    public RibbonApacheHttpResponse execute(final RibbonApacheHttpRequest request, final IClientConfig configOverride) throws Exception {
        RequestConfig.Builder builder = RequestConfig.custom();
        IClientConfig config = configOverride != null ? configOverride : this.config;
        builder.setConnectTimeout(((Integer)config.get(CommonClientConfigKey.ConnectTimeout, (Object)this.connectTimeout)).intValue());
        builder.setSocketTimeout(((Integer)config.get(CommonClientConfigKey.ReadTimeout, (Object)this.readTimeout)).intValue());
        builder.setRedirectsEnabled(((Boolean)config.get(CommonClientConfigKey.FollowRedirects, (Object)this.followRedirects)).booleanValue());
        final RequestConfig requestConfig = builder.build();
        final LoadBalancedRetryPolicy retryPolicy = this.loadBalancedRetryPolicyFactory.create(this.getClientName(), (ServiceInstanceChooser)this);
        RetryCallback<RibbonApacheHttpResponse, Exception> retryCallback = new RetryCallback<RibbonApacheHttpResponse, Exception>(){

            public RibbonApacheHttpResponse doWithRetry(RetryContext context) throws Exception {
                RibbonApacheHttpRequest newRequest = request;
                RibbonStatsRecorder statsRecorder = null;
                if (context instanceof LoadBalancedRetryContext) {
                    ServiceInstance service = ((LoadBalancedRetryContext)context).getServiceInstance();
                    RetryableRibbonLoadBalancingHttpClient.this.validateServiceInstance(service);
                    newRequest = newRequest.withNewUri(UriComponentsBuilder.newInstance().host(service.getHost()).scheme(service.getUri().getScheme()).userInfo(newRequest.getURI().getUserInfo()).port(service.getPort()).path(newRequest.getURI().getPath()).query(newRequest.getURI().getQuery()).fragment(newRequest.getURI().getFragment()).build().encode().toUri());
                    if (RetryableRibbonLoadBalancingHttpClient.this.ribbonLoadBalancerContext == null) {
                        LOGGER.error((Object)"RibbonLoadBalancerContext is null. Unable to update load balancer stats");
                    } else if (service instanceof RibbonLoadBalancerClient.RibbonServer) {
                        statsRecorder = new RibbonStatsRecorder(RetryableRibbonLoadBalancingHttpClient.this.ribbonLoadBalancerContext, ((RibbonLoadBalancerClient.RibbonServer)service).getServer());
                    }
                }
                newRequest = RetryableRibbonLoadBalancingHttpClient.this.getSecureRequest(newRequest, configOverride);
                HttpUriRequest httpUriRequest = newRequest.toRequest(requestConfig);
                CloseableHttpResponse httpResponse = ((CloseableHttpClient)RetryableRibbonLoadBalancingHttpClient.this.delegate).execute(httpUriRequest);
                if (retryPolicy.retryableStatusCode(httpResponse.getStatusLine().getStatusCode())) {
                    throw new HttpClientStatusCodeException(RetryableRibbonLoadBalancingHttpClient.this.clientName, (HttpResponse)httpResponse, HttpClientUtils.createEntity((HttpResponse)httpResponse), httpUriRequest.getURI());
                }
                if (statsRecorder != null) {
                    statsRecorder.recordStats(httpResponse);
                }
                return new RibbonApacheHttpResponse((HttpResponse)httpResponse, httpUriRequest.getURI());
            }
        };
        RibbonRecoveryCallback<RibbonApacheHttpResponse, HttpResponse> recoveryCallback = new RibbonRecoveryCallback<RibbonApacheHttpResponse, HttpResponse>(){

            protected RibbonApacheHttpResponse createResponse(HttpResponse response, URI uri) {
                return new RibbonApacheHttpResponse(response, uri);
            }
        };
        return this.executeWithRetry(request, retryPolicy, retryCallback, (RecoveryCallback<RibbonApacheHttpResponse>)recoveryCallback);
    }

    @Override
    public boolean isClientRetryable(ContextAwareRequest request) {
        return request != null && this.isRequestRetryable(request);
    }

    private boolean isRequestRetryable(ContextAwareRequest request) {
        return request.getContext() == null ? true : BooleanUtils.toBooleanDefaultIfNull((Boolean)request.getContext().getRetryable(), (boolean)true);
    }

    private RibbonApacheHttpResponse executeWithRetry(RibbonApacheHttpRequest request, LoadBalancedRetryPolicy retryPolicy, RetryCallback<RibbonApacheHttpResponse, Exception> callback, RecoveryCallback<RibbonApacheHttpResponse> recoveryCallback) throws Exception {
        RetryTemplate retryTemplate = new RetryTemplate();
        boolean retryable = this.isRequestRetryable(request);
        retryTemplate.setRetryPolicy((org.springframework.retry.RetryPolicy)(retryPolicy == null || !retryable ? new NeverRetryPolicy() : new RetryPolicy(request, retryPolicy, this, this.getClientName())));
        BackOffPolicy backOffPolicy = this.loadBalancedBackOffPolicyFactory.createBackOffPolicy(this.getClientName());
        retryTemplate.setBackOffPolicy((BackOffPolicy)(backOffPolicy == null ? new NoBackOffPolicy() : backOffPolicy));
        RetryListener[] retryListeners = this.loadBalancedRetryListenerFactory.createRetryListeners(this.getClientName());
        if (retryListeners != null && retryListeners.length != 0) {
            retryTemplate.setListeners(retryListeners);
        }
        return (RibbonApacheHttpResponse)retryTemplate.execute(callback, recoveryCallback);
    }

    @Override
    public RequestSpecificRetryHandler getRequestSpecificRetryHandler(RibbonApacheHttpRequest request, IClientConfig requestConfig) {
        return new RequestSpecificRetryHandler(false, false, RetryHandler.DEFAULT, null);
    }

    public void setRibbonLoadBalancerContext(RibbonLoadBalancerContext ribbonLoadBalancerContext) {
        this.ribbonLoadBalancerContext = ribbonLoadBalancerContext;
    }

    static class RetryPolicy
    extends InterceptorRetryPolicy {
        public RetryPolicy(HttpRequest request, LoadBalancedRetryPolicy policy, ServiceInstanceChooser serviceInstanceChooser, String serviceName) {
            super(request, policy, serviceInstanceChooser, serviceName);
        }
    }
}

