/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.ribbon.support;

import com.netflix.client.AbstractLoadBalancerAwareClient;
import com.netflix.client.IResponse;
import com.netflix.client.RequestSpecificRetryHandler;
import com.netflix.client.RetryHandler;
import com.netflix.client.config.CommonClientConfigKey;
import com.netflix.client.config.DefaultClientConfigImpl;
import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.ILoadBalancer;
import com.netflix.loadbalancer.reactive.LoadBalancerCommand;
import org.springframework.cloud.netflix.ribbon.DefaultServerIntrospector;
import org.springframework.cloud.netflix.ribbon.ServerIntrospector;
import org.springframework.cloud.netflix.ribbon.support.ContextAwareRequest;

public abstract class AbstractLoadBalancingClient<S extends ContextAwareRequest, T extends IResponse, D>
extends AbstractLoadBalancerAwareClient<S, T> {
    protected int connectTimeout;
    protected int readTimeout;
    protected boolean secure;
    protected boolean followRedirects;
    protected boolean okToRetryOnAllOperations;
    protected final D delegate;
    protected final IClientConfig config;
    protected final ServerIntrospector serverIntrospector;

    public boolean isClientRetryable(ContextAwareRequest request) {
        return false;
    }

    @Deprecated
    public AbstractLoadBalancingClient() {
        super(null);
        this.config = new DefaultClientConfigImpl();
        this.delegate = this.createDelegate(this.config);
        this.serverIntrospector = new DefaultServerIntrospector();
        this.setRetryHandler(RetryHandler.DEFAULT);
        this.initWithNiwsConfig(this.config);
    }

    @Deprecated
    public AbstractLoadBalancingClient(ILoadBalancer lb) {
        super(lb);
        this.config = new DefaultClientConfigImpl();
        this.delegate = this.createDelegate(this.config);
        this.serverIntrospector = new DefaultServerIntrospector();
        this.setRetryHandler(RetryHandler.DEFAULT);
        this.initWithNiwsConfig(this.config);
    }

    protected AbstractLoadBalancingClient(IClientConfig config, ServerIntrospector serverIntrospector) {
        super(null);
        this.delegate = this.createDelegate(config);
        this.config = config;
        this.serverIntrospector = serverIntrospector;
        this.setRetryHandler(RetryHandler.DEFAULT);
        this.initWithNiwsConfig(config);
    }

    protected AbstractLoadBalancingClient(D delegate, IClientConfig config, ServerIntrospector serverIntrospector) {
        super(null);
        this.delegate = delegate;
        this.config = config;
        this.serverIntrospector = serverIntrospector;
        this.setRetryHandler(RetryHandler.DEFAULT);
        this.initWithNiwsConfig(config);
    }

    public void initWithNiwsConfig(IClientConfig clientConfig) {
        super.initWithNiwsConfig(clientConfig);
        this.connectTimeout = clientConfig.getPropertyAsInteger(CommonClientConfigKey.ConnectTimeout, 1000);
        this.readTimeout = clientConfig.getPropertyAsInteger(CommonClientConfigKey.ReadTimeout, 1000);
        this.secure = clientConfig.getPropertyAsBoolean(CommonClientConfigKey.IsSecure, false);
        this.followRedirects = clientConfig.getPropertyAsBoolean(CommonClientConfigKey.FollowRedirects, DefaultClientConfigImpl.DEFAULT_FOLLOW_REDIRECTS.booleanValue());
        this.okToRetryOnAllOperations = clientConfig.getPropertyAsBoolean(CommonClientConfigKey.OkToRetryOnAllOperations, DefaultClientConfigImpl.DEFAULT_OK_TO_RETRY_ON_ALL_OPERATIONS.booleanValue());
    }

    protected abstract D createDelegate(IClientConfig var1);

    public D getDelegate() {
        return this.delegate;
    }

    public RequestSpecificRetryHandler getRequestSpecificRetryHandler(S request, IClientConfig requestConfig) {
        if (this.okToRetryOnAllOperations) {
            return new RequestSpecificRetryHandler(true, true, this.getRetryHandler(), requestConfig);
        }
        if (!((ContextAwareRequest)((Object)request)).getContext().getMethod().equals("GET")) {
            return new RequestSpecificRetryHandler(true, false, this.getRetryHandler(), requestConfig);
        }
        return new RequestSpecificRetryHandler(true, true, this.getRetryHandler(), requestConfig);
    }

    protected boolean isSecure(IClientConfig config) {
        Boolean result;
        if (config != null && (result = (Boolean)config.get(CommonClientConfigKey.IsSecure)) != null) {
            return result;
        }
        return this.secure;
    }

    protected void customizeLoadBalancerCommandBuilder(S request, IClientConfig config, LoadBalancerCommand.Builder<T> builder) {
        if (request.getLoadBalancerKey() != null) {
            builder.withServerLocator(request.getLoadBalancerKey());
        }
    }
}

