/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.feign.ribbon;

import com.netflix.client.DefaultLoadBalancerRetryHandler;
import com.netflix.client.RequestSpecificRetryHandler;
import com.netflix.client.RetryHandler;
import com.netflix.client.config.CommonClientConfigKey;
import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.ILoadBalancer;
import com.netflix.loadbalancer.Server;
import feign.Request;
import feign.Response;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.LoadBalancedBackOffPolicyFactory;
import org.springframework.cloud.client.loadbalancer.LoadBalancedRetryContext;
import org.springframework.cloud.client.loadbalancer.LoadBalancedRetryListenerFactory;
import org.springframework.cloud.client.loadbalancer.LoadBalancedRetryPolicy;
import org.springframework.cloud.client.loadbalancer.LoadBalancedRetryPolicyFactory;
import org.springframework.cloud.client.loadbalancer.RibbonRecoveryCallback;
import org.springframework.cloud.client.loadbalancer.ServiceInstanceChooser;
import org.springframework.cloud.netflix.feign.ribbon.FeignLoadBalancer;
import org.springframework.cloud.netflix.feign.ribbon.FeignRetryPolicy;
import org.springframework.cloud.netflix.feign.ribbon.RibbonResponseStatusCodeException;
import org.springframework.cloud.netflix.ribbon.RibbonLoadBalancerClient;
import org.springframework.cloud.netflix.ribbon.ServerIntrospector;
import org.springframework.retry.RecoveryCallback;
import org.springframework.retry.RetryCallback;
import org.springframework.retry.RetryContext;
import org.springframework.retry.RetryListener;
import org.springframework.retry.RetryPolicy;
import org.springframework.retry.backoff.BackOffPolicy;
import org.springframework.retry.backoff.NoBackOffPolicy;
import org.springframework.retry.policy.NeverRetryPolicy;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.StreamUtils;

public class RetryableFeignLoadBalancer
extends FeignLoadBalancer
implements ServiceInstanceChooser {
    private final LoadBalancedRetryPolicyFactory loadBalancedRetryPolicyFactory;
    private final LoadBalancedBackOffPolicyFactory loadBalancedBackOffPolicyFactory;
    private final LoadBalancedRetryListenerFactory loadBalancedRetryListenerFactory;

    @Deprecated
    public RetryableFeignLoadBalancer(ILoadBalancer lb, IClientConfig clientConfig, ServerIntrospector serverIntrospector, LoadBalancedRetryPolicyFactory loadBalancedRetryPolicyFactory) {
        super(lb, clientConfig, serverIntrospector);
        this.loadBalancedRetryPolicyFactory = loadBalancedRetryPolicyFactory;
        this.setRetryHandler((RetryHandler)new DefaultLoadBalancerRetryHandler(clientConfig));
        this.loadBalancedBackOffPolicyFactory = new LoadBalancedBackOffPolicyFactory.NoBackOffPolicyFactory();
        this.loadBalancedRetryListenerFactory = new LoadBalancedRetryListenerFactory.DefaultRetryListenerFactory();
    }

    @Deprecated
    public RetryableFeignLoadBalancer(ILoadBalancer lb, IClientConfig clientConfig, ServerIntrospector serverIntrospector, LoadBalancedRetryPolicyFactory loadBalancedRetryPolicyFactory, LoadBalancedBackOffPolicyFactory loadBalancedBackOffPolicyFactory) {
        super(lb, clientConfig, serverIntrospector);
        this.loadBalancedRetryPolicyFactory = loadBalancedRetryPolicyFactory;
        this.setRetryHandler((RetryHandler)new DefaultLoadBalancerRetryHandler(clientConfig));
        this.loadBalancedBackOffPolicyFactory = loadBalancedBackOffPolicyFactory == null ? new LoadBalancedBackOffPolicyFactory.NoBackOffPolicyFactory() : loadBalancedBackOffPolicyFactory;
        this.loadBalancedRetryListenerFactory = new LoadBalancedRetryListenerFactory.DefaultRetryListenerFactory();
    }

    public RetryableFeignLoadBalancer(ILoadBalancer lb, IClientConfig clientConfig, ServerIntrospector serverIntrospector, LoadBalancedRetryPolicyFactory loadBalancedRetryPolicyFactory, LoadBalancedBackOffPolicyFactory loadBalancedBackOffPolicyFactory, LoadBalancedRetryListenerFactory loadBalancedRetryListenerFactory) {
        super(lb, clientConfig, serverIntrospector);
        this.loadBalancedRetryPolicyFactory = loadBalancedRetryPolicyFactory;
        this.setRetryHandler((RetryHandler)new DefaultLoadBalancerRetryHandler(clientConfig));
        this.loadBalancedBackOffPolicyFactory = loadBalancedBackOffPolicyFactory == null ? new LoadBalancedBackOffPolicyFactory.NoBackOffPolicyFactory() : loadBalancedBackOffPolicyFactory;
        this.loadBalancedRetryListenerFactory = loadBalancedRetryListenerFactory == null ? new LoadBalancedRetryListenerFactory.DefaultRetryListenerFactory() : loadBalancedRetryListenerFactory;
    }

    @Override
    public FeignLoadBalancer.RibbonResponse execute(final FeignLoadBalancer.RibbonRequest request, IClientConfig configOverride) throws IOException {
        final Request.Options options = configOverride != null ? new Request.Options(((Integer)configOverride.get(CommonClientConfigKey.ConnectTimeout, (Object)this.connectTimeout)).intValue(), ((Integer)configOverride.get(CommonClientConfigKey.ReadTimeout, (Object)this.readTimeout)).intValue()) : new Request.Options(this.connectTimeout, this.readTimeout);
        final LoadBalancedRetryPolicy retryPolicy = this.loadBalancedRetryPolicyFactory.create(this.getClientName(), (ServiceInstanceChooser)this);
        RetryTemplate retryTemplate = new RetryTemplate();
        BackOffPolicy backOffPolicy = this.loadBalancedBackOffPolicyFactory.createBackOffPolicy(this.getClientName());
        retryTemplate.setBackOffPolicy((BackOffPolicy)(backOffPolicy == null ? new NoBackOffPolicy() : backOffPolicy));
        RetryListener[] retryListeners = this.loadBalancedRetryListenerFactory.createRetryListeners(this.getClientName());
        if (retryListeners != null && retryListeners.length != 0) {
            retryTemplate.setListeners(retryListeners);
        }
        retryTemplate.setRetryPolicy((RetryPolicy)(retryPolicy == null ? new NeverRetryPolicy() : new FeignRetryPolicy(request.toHttpRequest(), retryPolicy, this, this.getClientName())));
        return (FeignLoadBalancer.RibbonResponse)retryTemplate.execute((RetryCallback)new RetryCallback<FeignLoadBalancer.RibbonResponse, IOException>(){

            public FeignLoadBalancer.RibbonResponse doWithRetry(RetryContext retryContext) throws IOException {
                Response response;
                ServiceInstance service;
                Request feignRequest = null;
                if (retryContext instanceof LoadBalancedRetryContext && (service = ((LoadBalancedRetryContext)retryContext).getServiceInstance()) != null) {
                    feignRequest = ((FeignLoadBalancer.RibbonRequest)request.replaceUri(RetryableFeignLoadBalancer.this.reconstructURIWithServer(new Server(service.getHost(), service.getPort()), request.getUri()))).toRequest();
                }
                if (feignRequest == null) {
                    feignRequest = request.toRequest();
                }
                if (retryPolicy.retryableStatusCode((response = request.client().execute(feignRequest, options)).status())) {
                    byte[] byteArray = StreamUtils.copyToByteArray((InputStream)response.body().asInputStream());
                    response.close();
                    throw new RibbonResponseStatusCodeException(RetryableFeignLoadBalancer.this.clientName, response, byteArray, request.getUri());
                }
                return new FeignLoadBalancer.RibbonResponse(request.getUri(), response);
            }
        }, (RecoveryCallback)new RibbonRecoveryCallback<FeignLoadBalancer.RibbonResponse, Response>(){

            protected FeignLoadBalancer.RibbonResponse createResponse(Response response, URI uri) {
                return new FeignLoadBalancer.RibbonResponse(uri, response);
            }
        });
    }

    @Override
    public RequestSpecificRetryHandler getRequestSpecificRetryHandler(FeignLoadBalancer.RibbonRequest request, IClientConfig requestConfig) {
        return new RequestSpecificRetryHandler(false, false, this.getRetryHandler(), requestConfig);
    }

    public ServiceInstance choose(String serviceId) {
        return new RibbonLoadBalancerClient.RibbonServer(serviceId, this.getLoadBalancer().chooseServer((Object)serviceId));
    }
}

