/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.zuul.filters.route.support;

import com.netflix.client.AbstractLoadBalancerAwareClient;
import com.netflix.client.ClientRequest;
import com.netflix.client.config.IClientConfig;
import com.netflix.client.config.IClientConfigKey;
import com.netflix.client.http.HttpResponse;
import com.netflix.config.DynamicIntProperty;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.hystrix.HystrixCommand;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandProperties;
import com.netflix.hystrix.HystrixThreadPoolKey;
import com.netflix.zuul.context.RequestContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.netflix.ribbon.RibbonHttpResponse;
import org.springframework.cloud.netflix.zuul.filters.ZuulProperties;
import org.springframework.cloud.netflix.zuul.filters.route.FallbackProvider;
import org.springframework.cloud.netflix.zuul.filters.route.RibbonCommand;
import org.springframework.cloud.netflix.zuul.filters.route.RibbonCommandContext;
import org.springframework.cloud.netflix.zuul.filters.route.ZuulFallbackProvider;
import org.springframework.http.client.ClientHttpResponse;

public abstract class AbstractRibbonCommand<LBC extends AbstractLoadBalancerAwareClient<RQ, RS>, RQ extends ClientRequest, RS extends HttpResponse>
extends HystrixCommand<ClientHttpResponse>
implements RibbonCommand {
    private static final Log LOGGER = LogFactory.getLog(AbstractRibbonCommand.class);
    protected final LBC client;
    protected RibbonCommandContext context;
    protected ZuulFallbackProvider zuulFallbackProvider;
    protected IClientConfig config;

    public AbstractRibbonCommand(LBC client, RibbonCommandContext context, ZuulProperties zuulProperties) {
        this("default", client, context, zuulProperties);
    }

    public AbstractRibbonCommand(String commandKey, LBC client, RibbonCommandContext context, ZuulProperties zuulProperties) {
        this(commandKey, client, context, zuulProperties, null);
    }

    public AbstractRibbonCommand(String commandKey, LBC client, RibbonCommandContext context, ZuulProperties zuulProperties, ZuulFallbackProvider fallbackProvider) {
        this(commandKey, client, context, zuulProperties, fallbackProvider, null);
    }

    public AbstractRibbonCommand(String commandKey, LBC client, RibbonCommandContext context, ZuulProperties zuulProperties, ZuulFallbackProvider fallbackProvider, IClientConfig config) {
        this(AbstractRibbonCommand.getSetter(commandKey, zuulProperties, config), client, context, fallbackProvider, config);
    }

    protected AbstractRibbonCommand(HystrixCommand.Setter setter, LBC client, RibbonCommandContext context, ZuulFallbackProvider fallbackProvider, IClientConfig config) {
        super(setter);
        this.client = client;
        this.context = context;
        this.zuulFallbackProvider = fallbackProvider;
        this.config = config;
    }

    protected static HystrixCommandProperties.Setter createSetter(IClientConfig config, String commandKey, ZuulProperties zuulProperties) {
        int ribbonReadTimeout;
        int ribbonConnectTimeout;
        int ribbonTimeout;
        DynamicPropertyFactory dynamicPropertyFactory = DynamicPropertyFactory.getInstance();
        int defaultHystrixTimeout = dynamicPropertyFactory.getIntProperty("hystrix.command.default.execution.isolation.thread.timeoutInMilliseconds", 0).get();
        int commandHystrixTimeout = dynamicPropertyFactory.getIntProperty("hystrix.command." + commandKey + ".execution.isolation.thread.timeoutInMilliseconds", 0).get();
        int hystrixTimeout = commandHystrixTimeout > 0 ? commandHystrixTimeout : (defaultHystrixTimeout > 0 ? defaultHystrixTimeout : ribbonTimeout);
        if (hystrixTimeout < (ribbonTimeout = (ribbonConnectTimeout = config == null ? 1000 : (Integer)config.get(IClientConfigKey.Keys.ConnectTimeout, (Object)1000)) + (ribbonReadTimeout = config == null ? 1000 : (Integer)config.get(IClientConfigKey.Keys.ReadTimeout, (Object)1000)))) {
            LOGGER.warn((Object)("The Hystrix timeout of " + hystrixTimeout + "ms for the command " + commandKey + " is set lower than the combination of the Ribbon read and connect timeout, " + ribbonTimeout + "ms."));
        }
        return HystrixCommandProperties.Setter().withExecutionIsolationStrategy(zuulProperties.getRibbonIsolationStrategy()).withExecutionTimeoutInMilliseconds(hystrixTimeout);
    }

    @Deprecated
    protected static HystrixCommand.Setter getSetter(String commandKey, ZuulProperties zuulProperties) {
        return AbstractRibbonCommand.getSetter(commandKey, zuulProperties, null);
    }

    protected static HystrixCommand.Setter getSetter(String commandKey, ZuulProperties zuulProperties, IClientConfig config) {
        HystrixCommand.Setter commandSetter = HystrixCommand.Setter.withGroupKey((HystrixCommandGroupKey)HystrixCommandGroupKey.Factory.asKey((String)"RibbonCommand")).andCommandKey(HystrixCommandKey.Factory.asKey((String)commandKey));
        HystrixCommandProperties.Setter setter = AbstractRibbonCommand.createSetter(config, commandKey, zuulProperties);
        if (zuulProperties.getRibbonIsolationStrategy() == HystrixCommandProperties.ExecutionIsolationStrategy.SEMAPHORE) {
            String name = "zuul.eureka." + commandKey + ".semaphore.maxSemaphores";
            DynamicIntProperty value = DynamicPropertyFactory.getInstance().getIntProperty(name, zuulProperties.getSemaphore().getMaxSemaphores());
            setter.withExecutionIsolationSemaphoreMaxConcurrentRequests(value.get());
        } else if (zuulProperties.getThreadPool().isUseSeparateThreadPools()) {
            String threadPoolKey = zuulProperties.getThreadPool().getThreadPoolKeyPrefix() + commandKey;
            commandSetter.andThreadPoolKey(HystrixThreadPoolKey.Factory.asKey((String)threadPoolKey));
        }
        return commandSetter.andCommandPropertiesDefaults(setter);
    }

    protected ClientHttpResponse run() throws Exception {
        RequestContext context = RequestContext.getCurrentContext();
        RQ request = this.createRequest();
        HttpResponse response = (HttpResponse)this.client.executeWithLoadBalancer(request, this.config);
        context.set("ribbonResponse", (Object)response);
        if (this.isResponseTimedOut() && response != null) {
            response.close();
        }
        return new RibbonHttpResponse(response);
    }

    protected ClientHttpResponse getFallback() {
        if (this.zuulFallbackProvider != null) {
            return this.getFallbackResponse();
        }
        return (ClientHttpResponse)super.getFallback();
    }

    protected ClientHttpResponse getFallbackResponse() {
        if (this.zuulFallbackProvider instanceof FallbackProvider) {
            Throwable cause = this.getFailedExecutionException();
            Throwable throwable = cause = cause == null ? this.getExecutionException() : cause;
            if (cause == null) {
                this.zuulFallbackProvider.fallbackResponse();
            } else {
                return ((FallbackProvider)this.zuulFallbackProvider).fallbackResponse(cause);
            }
        }
        return this.zuulFallbackProvider.fallbackResponse();
    }

    public LBC getClient() {
        return this.client;
    }

    public RibbonCommandContext getContext() {
        return this.context;
    }

    protected abstract RQ createRequest() throws Exception;
}

