/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.feign.ribbon;

import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.ILoadBalancer;
import java.util.Map;
import org.springframework.cloud.client.loadbalancer.LoadBalancedBackOffPolicyFactory;
import org.springframework.cloud.client.loadbalancer.LoadBalancedRetryPolicyFactory;
import org.springframework.cloud.netflix.feign.ribbon.FeignLoadBalancer;
import org.springframework.cloud.netflix.feign.ribbon.RetryableFeignLoadBalancer;
import org.springframework.cloud.netflix.ribbon.RibbonLoadBalancedRetryPolicyFactory;
import org.springframework.cloud.netflix.ribbon.ServerIntrospector;
import org.springframework.cloud.netflix.ribbon.SpringClientFactory;
import org.springframework.util.ConcurrentReferenceHashMap;

public class CachingSpringLoadBalancerFactory {
    private final SpringClientFactory factory;
    private final LoadBalancedRetryPolicyFactory loadBalancedRetryPolicyFactory;
    private final LoadBalancedBackOffPolicyFactory loadBalancedBackOffPolicyFactory;
    private boolean enableRetry = false;
    private volatile Map<String, FeignLoadBalancer> cache = new ConcurrentReferenceHashMap();

    public CachingSpringLoadBalancerFactory(SpringClientFactory factory) {
        this.factory = factory;
        this.loadBalancedRetryPolicyFactory = new RibbonLoadBalancedRetryPolicyFactory(factory);
        this.loadBalancedBackOffPolicyFactory = null;
    }

    @Deprecated
    public CachingSpringLoadBalancerFactory(SpringClientFactory factory, LoadBalancedRetryPolicyFactory loadBalancedRetryPolicyFactory) {
        this.factory = factory;
        this.loadBalancedRetryPolicyFactory = loadBalancedRetryPolicyFactory;
        this.loadBalancedBackOffPolicyFactory = null;
    }

    @Deprecated
    public CachingSpringLoadBalancerFactory(SpringClientFactory factory, LoadBalancedRetryPolicyFactory loadBalancedRetryPolicyFactory, boolean enableRetry) {
        this.factory = factory;
        this.loadBalancedRetryPolicyFactory = loadBalancedRetryPolicyFactory;
        this.enableRetry = enableRetry;
        this.loadBalancedBackOffPolicyFactory = null;
    }

    public CachingSpringLoadBalancerFactory(SpringClientFactory factory, LoadBalancedRetryPolicyFactory loadBalancedRetryPolicyFactory, LoadBalancedBackOffPolicyFactory loadBalancedBackOffPolicyFactory) {
        this.factory = factory;
        this.loadBalancedRetryPolicyFactory = loadBalancedRetryPolicyFactory;
        this.loadBalancedBackOffPolicyFactory = loadBalancedBackOffPolicyFactory;
        this.enableRetry = true;
    }

    public FeignLoadBalancer create(String clientName) {
        if (this.cache.containsKey(clientName)) {
            return this.cache.get(clientName);
        }
        IClientConfig config = this.factory.getClientConfig(clientName);
        ILoadBalancer lb = this.factory.getLoadBalancer(clientName);
        ServerIntrospector serverIntrospector = this.factory.getInstance(clientName, ServerIntrospector.class);
        FeignLoadBalancer client = this.enableRetry ? new RetryableFeignLoadBalancer(lb, config, serverIntrospector, this.loadBalancedRetryPolicyFactory, this.loadBalancedBackOffPolicyFactory) : new FeignLoadBalancer(lb, config, serverIntrospector);
        this.cache.put(clientName, client);
        return client;
    }
}

