/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.feign.encoding;

import java.util.Arrays;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="feign.compression.request")
public class FeignClientEncodingProperties {
    private String[] mimeTypes = new String[]{"text/xml", "application/xml", "application/json"};
    private int minRequestSize = 2048;

    public String[] getMimeTypes() {
        return this.mimeTypes;
    }

    public int getMinRequestSize() {
        return this.minRequestSize;
    }

    public void setMimeTypes(String[] mimeTypes) {
        this.mimeTypes = mimeTypes;
    }

    public void setMinRequestSize(int minRequestSize) {
        this.minRequestSize = minRequestSize;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FeignClientEncodingProperties)) {
            return false;
        }
        FeignClientEncodingProperties other = (FeignClientEncodingProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getMimeTypes(), other.getMimeTypes())) {
            return false;
        }
        return this.getMinRequestSize() == other.getMinRequestSize();
    }

    protected boolean canEqual(Object other) {
        return other instanceof FeignClientEncodingProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.deepHashCode(this.getMimeTypes());
        result = result * 59 + this.getMinRequestSize();
        return result;
    }

    public String toString() {
        return "FeignClientEncodingProperties(mimeTypes=" + Arrays.deepToString(this.getMimeTypes()) + ", minRequestSize=" + this.getMinRequestSize() + ")";
    }
}

