/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.feign.ribbon;

import feign.Client;
import feign.okhttp.OkHttpClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.netflix.feign.ribbon.CachingSpringLoadBalancerFactory;
import org.springframework.cloud.netflix.feign.ribbon.LoadBalancerFeignClient;
import org.springframework.cloud.netflix.ribbon.SpringClientFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={OkHttpClient.class})
@ConditionalOnProperty(value={"feign.okhttp.enabled"}, matchIfMissing=true)
class OkHttpFeignLoadBalancedConfiguration {
    @Autowired(required=false)
    private okhttp3.OkHttpClient okHttpClient;

    OkHttpFeignLoadBalancedConfiguration() {
    }

    @Bean
    @ConditionalOnMissingBean(value={Client.class})
    public Client feignClient(CachingSpringLoadBalancerFactory cachingFactory, SpringClientFactory clientFactory) {
        OkHttpClient delegate = this.okHttpClient != null ? new OkHttpClient(this.okHttpClient) : new OkHttpClient();
        return new LoadBalancerFeignClient((Client)delegate, cachingFactory, clientFactory);
    }
}

