/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.zuul.util;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

public class RequestContentDataExtractor {
    public static MultiValueMap<String, Object> extract(HttpServletRequest request) throws IOException {
        return request instanceof MultipartHttpServletRequest ? RequestContentDataExtractor.extractFromMultipartRequest((MultipartHttpServletRequest)request) : RequestContentDataExtractor.extractFromRequest(request);
    }

    private static MultiValueMap<String, Object> extractFromRequest(HttpServletRequest request) throws IOException {
        LinkedMultiValueMap builder = new LinkedMultiValueMap();
        Set<String> queryParams = RequestContentDataExtractor.findQueryParams(request);
        for (Map.Entry entry : request.getParameterMap().entrySet()) {
            String key = (String)entry.getKey();
            if (queryParams.contains(key)) continue;
            for (String value : (String[])entry.getValue()) {
                builder.add((Object)key, (Object)value);
            }
        }
        return builder;
    }

    private static MultiValueMap<String, Object> extractFromMultipartRequest(MultipartHttpServletRequest request) throws IOException {
        LinkedMultiValueMap builder = new LinkedMultiValueMap();
        Set<String> queryParams = RequestContentDataExtractor.findQueryParams((HttpServletRequest)request);
        for (Map.Entry entry : request.getParameterMap().entrySet()) {
            String key = (String)entry.getKey();
            if (queryParams.contains(key)) continue;
            for (String value : (String[])entry.getValue()) {
                HttpHeaders headers = new HttpHeaders();
                String type = request.getMultipartContentType(key);
                if (type != null) {
                    headers.setContentType(MediaType.valueOf((String)type));
                }
                builder.add((Object)key, (Object)new HttpEntity((Object)value, (MultiValueMap)headers));
            }
        }
        for (Map.Entry parts : request.getMultiFileMap().entrySet()) {
            for (MultipartFile file : (List)parts.getValue()) {
                HttpHeaders headers = new HttpHeaders();
                headers.setContentDispositionFormData(file.getName(), file.getOriginalFilename());
                if (file.getContentType() != null) {
                    headers.setContentType(MediaType.valueOf((String)file.getContentType()));
                }
                HttpEntity entity = new HttpEntity((Object)new InputStreamResource(file.getInputStream()), (MultiValueMap)headers);
                builder.add(parts.getKey(), (Object)entity);
            }
        }
        return builder;
    }

    private static Set<String> findQueryParams(HttpServletRequest request) {
        HashSet<String> result = new HashSet<String>();
        String query = request.getQueryString();
        if (query != null) {
            for (String value : StringUtils.tokenizeToStringArray((String)query, (String)"&")) {
                if (value.contains("=")) {
                    value = value.substring(0, value.indexOf("="));
                }
                result.add(value);
            }
        }
        return result;
    }
}

