/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.zuul.filters.post;

import com.netflix.zuul.ZuulFilter;
import com.netflix.zuul.context.RequestContext;
import com.netflix.zuul.exception.ZuulException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.netflix.zuul.util.ZuulRuntimeException;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class SendErrorFilter
extends ZuulFilter {
    private static final Log log = LogFactory.getLog(SendErrorFilter.class);
    protected static final String SEND_ERROR_FILTER_RAN = "sendErrorFilter.ran";
    @Value(value="${error.path:/error}")
    private String errorPath;

    public String filterType() {
        return "error";
    }

    public int filterOrder() {
        return 0;
    }

    public boolean shouldFilter() {
        RequestContext ctx = RequestContext.getCurrentContext();
        return ctx.getThrowable() != null && !ctx.getBoolean(SEND_ERROR_FILTER_RAN, false);
    }

    public Object run() {
        try {
            RequestDispatcher dispatcher;
            RequestContext ctx = RequestContext.getCurrentContext();
            ZuulException exception = this.findZuulException(ctx.getThrowable());
            HttpServletRequest request = ctx.getRequest();
            request.setAttribute("javax.servlet.error.status_code", (Object)exception.nStatusCode);
            log.warn((Object)"Error during filtering", (Throwable)exception);
            request.setAttribute("javax.servlet.error.exception", (Object)exception);
            if (StringUtils.hasText((String)exception.errorCause)) {
                request.setAttribute("javax.servlet.error.message", (Object)exception.errorCause);
            }
            if ((dispatcher = request.getRequestDispatcher(this.errorPath)) != null) {
                ctx.set(SEND_ERROR_FILTER_RAN, (Object)true);
                if (!ctx.getResponse().isCommitted()) {
                    dispatcher.forward((ServletRequest)request, (ServletResponse)ctx.getResponse());
                }
            }
        }
        catch (Exception ex) {
            ReflectionUtils.rethrowRuntimeException((Throwable)ex);
        }
        return null;
    }

    ZuulException findZuulException(Throwable throwable) {
        if (throwable.getCause() instanceof ZuulRuntimeException) {
            return (ZuulException)throwable.getCause().getCause();
        }
        if (throwable.getCause() instanceof ZuulException) {
            return (ZuulException)throwable.getCause();
        }
        if (throwable instanceof ZuulException) {
            return (ZuulException)throwable;
        }
        return new ZuulException(throwable, 500, null);
    }

    public void setErrorPath(String errorPath) {
        this.errorPath = errorPath;
    }
}

