/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.zuul.filters;

import com.netflix.hystrix.HystrixCommandProperties;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.netflix.zuul.filters.Route;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

@ConfigurationProperties(value="zuul")
public class ZuulProperties {
    public static final List<String> SECURITY_HEADERS = Arrays.asList("Pragma", "Cache-Control", "X-Frame-Options", "X-Content-Type-Options", "X-XSS-Protection", "Expires");
    private String prefix = "";
    private boolean stripPrefix = true;
    private Boolean retryable = false;
    private Map<String, ZuulRoute> routes = new LinkedHashMap<String, ZuulRoute>();
    private boolean addProxyHeaders = true;
    private boolean addHostHeader = false;
    private Set<String> ignoredServices = new LinkedHashSet<String>();
    private Set<String> ignoredPatterns = new LinkedHashSet<String>();
    private Set<String> ignoredHeaders = new LinkedHashSet<String>();
    private boolean ignoreSecurityHeaders = true;
    private boolean forceOriginalQueryStringEncoding = false;
    private String servletPath = "/zuul";
    private boolean ignoreLocalService = true;
    private Host host = new Host();
    private boolean traceRequestBody = true;
    private boolean removeSemicolonContent = true;
    private Set<String> sensitiveHeaders = new LinkedHashSet<String>(Arrays.asList("Cookie", "Set-Cookie", "Authorization"));
    private boolean sslHostnameValidationEnabled = true;
    private HystrixCommandProperties.ExecutionIsolationStrategy ribbonIsolationStrategy = HystrixCommandProperties.ExecutionIsolationStrategy.SEMAPHORE;
    private HystrixSemaphore semaphore = new HystrixSemaphore();

    public Set<String> getIgnoredHeaders() {
        LinkedHashSet<String> ignoredHeaders = new LinkedHashSet<String>(this.ignoredHeaders);
        if (ClassUtils.isPresent((String)"org.springframework.security.config.annotation.web.WebSecurityConfigurer", null) && Collections.disjoint(ignoredHeaders, SECURITY_HEADERS) && this.ignoreSecurityHeaders) {
            ignoredHeaders.addAll(SECURITY_HEADERS);
        }
        return ignoredHeaders;
    }

    public void setIgnoredHeaders(Set<String> ignoredHeaders) {
        this.ignoredHeaders.addAll(ignoredHeaders);
    }

    @PostConstruct
    public void init() {
        for (Map.Entry<String, ZuulRoute> entry : this.routes.entrySet()) {
            ZuulRoute value = entry.getValue();
            if (!StringUtils.hasText((String)value.getLocation())) {
                value.serviceId = entry.getKey();
            }
            if (!StringUtils.hasText((String)value.getId())) {
                value.id = entry.getKey();
            }
            if (StringUtils.hasText((String)value.getPath())) continue;
            value.path = "/" + entry.getKey() + "/**";
        }
    }

    public String getServletPattern() {
        String path = this.servletPath;
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if (!path.contains("*")) {
            path = path.endsWith("/") ? path + "*" : path + "/*";
        }
        return path;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public boolean isStripPrefix() {
        return this.stripPrefix;
    }

    public Boolean getRetryable() {
        return this.retryable;
    }

    public Map<String, ZuulRoute> getRoutes() {
        return this.routes;
    }

    public boolean isAddProxyHeaders() {
        return this.addProxyHeaders;
    }

    public boolean isAddHostHeader() {
        return this.addHostHeader;
    }

    public Set<String> getIgnoredServices() {
        return this.ignoredServices;
    }

    public Set<String> getIgnoredPatterns() {
        return this.ignoredPatterns;
    }

    public boolean isIgnoreSecurityHeaders() {
        return this.ignoreSecurityHeaders;
    }

    public boolean isForceOriginalQueryStringEncoding() {
        return this.forceOriginalQueryStringEncoding;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public boolean isIgnoreLocalService() {
        return this.ignoreLocalService;
    }

    public Host getHost() {
        return this.host;
    }

    public boolean isTraceRequestBody() {
        return this.traceRequestBody;
    }

    public boolean isRemoveSemicolonContent() {
        return this.removeSemicolonContent;
    }

    public Set<String> getSensitiveHeaders() {
        return this.sensitiveHeaders;
    }

    public boolean isSslHostnameValidationEnabled() {
        return this.sslHostnameValidationEnabled;
    }

    public HystrixCommandProperties.ExecutionIsolationStrategy getRibbonIsolationStrategy() {
        return this.ribbonIsolationStrategy;
    }

    public HystrixSemaphore getSemaphore() {
        return this.semaphore;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setStripPrefix(boolean stripPrefix) {
        this.stripPrefix = stripPrefix;
    }

    public void setRetryable(Boolean retryable) {
        this.retryable = retryable;
    }

    public void setRoutes(Map<String, ZuulRoute> routes) {
        this.routes = routes;
    }

    public void setAddProxyHeaders(boolean addProxyHeaders) {
        this.addProxyHeaders = addProxyHeaders;
    }

    public void setAddHostHeader(boolean addHostHeader) {
        this.addHostHeader = addHostHeader;
    }

    public void setIgnoredServices(Set<String> ignoredServices) {
        this.ignoredServices = ignoredServices;
    }

    public void setIgnoredPatterns(Set<String> ignoredPatterns) {
        this.ignoredPatterns = ignoredPatterns;
    }

    public void setIgnoreSecurityHeaders(boolean ignoreSecurityHeaders) {
        this.ignoreSecurityHeaders = ignoreSecurityHeaders;
    }

    public void setForceOriginalQueryStringEncoding(boolean forceOriginalQueryStringEncoding) {
        this.forceOriginalQueryStringEncoding = forceOriginalQueryStringEncoding;
    }

    public void setServletPath(String servletPath) {
        this.servletPath = servletPath;
    }

    public void setIgnoreLocalService(boolean ignoreLocalService) {
        this.ignoreLocalService = ignoreLocalService;
    }

    public void setHost(Host host) {
        this.host = host;
    }

    public void setTraceRequestBody(boolean traceRequestBody) {
        this.traceRequestBody = traceRequestBody;
    }

    public void setRemoveSemicolonContent(boolean removeSemicolonContent) {
        this.removeSemicolonContent = removeSemicolonContent;
    }

    public void setSensitiveHeaders(Set<String> sensitiveHeaders) {
        this.sensitiveHeaders = sensitiveHeaders;
    }

    public void setSslHostnameValidationEnabled(boolean sslHostnameValidationEnabled) {
        this.sslHostnameValidationEnabled = sslHostnameValidationEnabled;
    }

    public void setRibbonIsolationStrategy(HystrixCommandProperties.ExecutionIsolationStrategy ribbonIsolationStrategy) {
        this.ribbonIsolationStrategy = ribbonIsolationStrategy;
    }

    public void setSemaphore(HystrixSemaphore semaphore) {
        this.semaphore = semaphore;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ZuulProperties)) {
            return false;
        }
        ZuulProperties other = (ZuulProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$prefix = this.getPrefix();
        String other$prefix = other.getPrefix();
        if (this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix)) {
            return false;
        }
        if (this.isStripPrefix() != other.isStripPrefix()) {
            return false;
        }
        Boolean this$retryable = this.getRetryable();
        Boolean other$retryable = other.getRetryable();
        if (this$retryable == null ? other$retryable != null : !((Object)this$retryable).equals(other$retryable)) {
            return false;
        }
        Map<String, ZuulRoute> this$routes = this.getRoutes();
        Map<String, ZuulRoute> other$routes = other.getRoutes();
        if (this$routes == null ? other$routes != null : !((Object)this$routes).equals(other$routes)) {
            return false;
        }
        if (this.isAddProxyHeaders() != other.isAddProxyHeaders()) {
            return false;
        }
        if (this.isAddHostHeader() != other.isAddHostHeader()) {
            return false;
        }
        Set<String> this$ignoredServices = this.getIgnoredServices();
        Set<String> other$ignoredServices = other.getIgnoredServices();
        if (this$ignoredServices == null ? other$ignoredServices != null : !((Object)this$ignoredServices).equals(other$ignoredServices)) {
            return false;
        }
        Set<String> this$ignoredPatterns = this.getIgnoredPatterns();
        Set<String> other$ignoredPatterns = other.getIgnoredPatterns();
        if (this$ignoredPatterns == null ? other$ignoredPatterns != null : !((Object)this$ignoredPatterns).equals(other$ignoredPatterns)) {
            return false;
        }
        Set<String> this$ignoredHeaders = this.getIgnoredHeaders();
        Set<String> other$ignoredHeaders = other.getIgnoredHeaders();
        if (this$ignoredHeaders == null ? other$ignoredHeaders != null : !((Object)this$ignoredHeaders).equals(other$ignoredHeaders)) {
            return false;
        }
        if (this.isIgnoreSecurityHeaders() != other.isIgnoreSecurityHeaders()) {
            return false;
        }
        if (this.isForceOriginalQueryStringEncoding() != other.isForceOriginalQueryStringEncoding()) {
            return false;
        }
        String this$servletPath = this.getServletPath();
        String other$servletPath = other.getServletPath();
        if (this$servletPath == null ? other$servletPath != null : !this$servletPath.equals(other$servletPath)) {
            return false;
        }
        if (this.isIgnoreLocalService() != other.isIgnoreLocalService()) {
            return false;
        }
        Host this$host = this.getHost();
        Host other$host = other.getHost();
        if (this$host == null ? other$host != null : !((Object)this$host).equals(other$host)) {
            return false;
        }
        if (this.isTraceRequestBody() != other.isTraceRequestBody()) {
            return false;
        }
        if (this.isRemoveSemicolonContent() != other.isRemoveSemicolonContent()) {
            return false;
        }
        Set<String> this$sensitiveHeaders = this.getSensitiveHeaders();
        Set<String> other$sensitiveHeaders = other.getSensitiveHeaders();
        if (this$sensitiveHeaders == null ? other$sensitiveHeaders != null : !((Object)this$sensitiveHeaders).equals(other$sensitiveHeaders)) {
            return false;
        }
        if (this.isSslHostnameValidationEnabled() != other.isSslHostnameValidationEnabled()) {
            return false;
        }
        HystrixCommandProperties.ExecutionIsolationStrategy this$ribbonIsolationStrategy = this.getRibbonIsolationStrategy();
        HystrixCommandProperties.ExecutionIsolationStrategy other$ribbonIsolationStrategy = other.getRibbonIsolationStrategy();
        if (this$ribbonIsolationStrategy == null ? other$ribbonIsolationStrategy != null : !this$ribbonIsolationStrategy.equals(other$ribbonIsolationStrategy)) {
            return false;
        }
        HystrixSemaphore this$semaphore = this.getSemaphore();
        HystrixSemaphore other$semaphore = other.getSemaphore();
        return !(this$semaphore == null ? other$semaphore != null : !((Object)this$semaphore).equals(other$semaphore));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ZuulProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $prefix = this.getPrefix();
        result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
        result = result * 59 + (this.isStripPrefix() ? 79 : 97);
        Boolean $retryable = this.getRetryable();
        result = result * 59 + ($retryable == null ? 43 : ((Object)$retryable).hashCode());
        Map<String, ZuulRoute> $routes = this.getRoutes();
        result = result * 59 + ($routes == null ? 43 : ((Object)$routes).hashCode());
        result = result * 59 + (this.isAddProxyHeaders() ? 79 : 97);
        result = result * 59 + (this.isAddHostHeader() ? 79 : 97);
        Set<String> $ignoredServices = this.getIgnoredServices();
        result = result * 59 + ($ignoredServices == null ? 43 : ((Object)$ignoredServices).hashCode());
        Set<String> $ignoredPatterns = this.getIgnoredPatterns();
        result = result * 59 + ($ignoredPatterns == null ? 43 : ((Object)$ignoredPatterns).hashCode());
        Set<String> $ignoredHeaders = this.getIgnoredHeaders();
        result = result * 59 + ($ignoredHeaders == null ? 43 : ((Object)$ignoredHeaders).hashCode());
        result = result * 59 + (this.isIgnoreSecurityHeaders() ? 79 : 97);
        result = result * 59 + (this.isForceOriginalQueryStringEncoding() ? 79 : 97);
        String $servletPath = this.getServletPath();
        result = result * 59 + ($servletPath == null ? 43 : $servletPath.hashCode());
        result = result * 59 + (this.isIgnoreLocalService() ? 79 : 97);
        Host $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : ((Object)$host).hashCode());
        result = result * 59 + (this.isTraceRequestBody() ? 79 : 97);
        result = result * 59 + (this.isRemoveSemicolonContent() ? 79 : 97);
        Set<String> $sensitiveHeaders = this.getSensitiveHeaders();
        result = result * 59 + ($sensitiveHeaders == null ? 43 : ((Object)$sensitiveHeaders).hashCode());
        result = result * 59 + (this.isSslHostnameValidationEnabled() ? 79 : 97);
        HystrixCommandProperties.ExecutionIsolationStrategy $ribbonIsolationStrategy = this.getRibbonIsolationStrategy();
        result = result * 59 + ($ribbonIsolationStrategy == null ? 43 : $ribbonIsolationStrategy.hashCode());
        HystrixSemaphore $semaphore = this.getSemaphore();
        result = result * 59 + ($semaphore == null ? 43 : ((Object)$semaphore).hashCode());
        return result;
    }

    public String toString() {
        return "ZuulProperties(prefix=" + this.getPrefix() + ", stripPrefix=" + this.isStripPrefix() + ", retryable=" + this.getRetryable() + ", routes=" + this.getRoutes() + ", addProxyHeaders=" + this.isAddProxyHeaders() + ", addHostHeader=" + this.isAddHostHeader() + ", ignoredServices=" + this.getIgnoredServices() + ", ignoredPatterns=" + this.getIgnoredPatterns() + ", ignoredHeaders=" + this.getIgnoredHeaders() + ", ignoreSecurityHeaders=" + this.isIgnoreSecurityHeaders() + ", forceOriginalQueryStringEncoding=" + this.isForceOriginalQueryStringEncoding() + ", servletPath=" + this.getServletPath() + ", ignoreLocalService=" + this.isIgnoreLocalService() + ", host=" + this.getHost() + ", traceRequestBody=" + this.isTraceRequestBody() + ", removeSemicolonContent=" + this.isRemoveSemicolonContent() + ", sensitiveHeaders=" + this.getSensitiveHeaders() + ", sslHostnameValidationEnabled=" + this.isSslHostnameValidationEnabled() + ", ribbonIsolationStrategy=" + this.getRibbonIsolationStrategy() + ", semaphore=" + this.getSemaphore() + ")";
    }

    public static class HystrixSemaphore {
        private int maxSemaphores = 100;

        public int getMaxSemaphores() {
            return this.maxSemaphores;
        }

        public void setMaxSemaphores(int maxSemaphores) {
            this.maxSemaphores = maxSemaphores;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof HystrixSemaphore)) {
                return false;
            }
            HystrixSemaphore other = (HystrixSemaphore)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return this.getMaxSemaphores() == other.getMaxSemaphores();
        }

        protected boolean canEqual(Object other) {
            return other instanceof HystrixSemaphore;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getMaxSemaphores();
            return result;
        }

        public String toString() {
            return "ZuulProperties.HystrixSemaphore(maxSemaphores=" + this.getMaxSemaphores() + ")";
        }

        @ConstructorProperties(value={"maxSemaphores"})
        public HystrixSemaphore(int maxSemaphores) {
            this.maxSemaphores = maxSemaphores;
        }

        public HystrixSemaphore() {
        }
    }

    public static class Host {
        private int maxTotalConnections = 200;
        private int maxPerRouteConnections = 20;

        public int getMaxTotalConnections() {
            return this.maxTotalConnections;
        }

        public int getMaxPerRouteConnections() {
            return this.maxPerRouteConnections;
        }

        public void setMaxTotalConnections(int maxTotalConnections) {
            this.maxTotalConnections = maxTotalConnections;
        }

        public void setMaxPerRouteConnections(int maxPerRouteConnections) {
            this.maxPerRouteConnections = maxPerRouteConnections;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Host)) {
                return false;
            }
            Host other = (Host)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getMaxTotalConnections() != other.getMaxTotalConnections()) {
                return false;
            }
            return this.getMaxPerRouteConnections() == other.getMaxPerRouteConnections();
        }

        protected boolean canEqual(Object other) {
            return other instanceof Host;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getMaxTotalConnections();
            result = result * 59 + this.getMaxPerRouteConnections();
            return result;
        }

        public String toString() {
            return "ZuulProperties.Host(maxTotalConnections=" + this.getMaxTotalConnections() + ", maxPerRouteConnections=" + this.getMaxPerRouteConnections() + ")";
        }

        @ConstructorProperties(value={"maxTotalConnections", "maxPerRouteConnections"})
        public Host(int maxTotalConnections, int maxPerRouteConnections) {
            this.maxTotalConnections = maxTotalConnections;
            this.maxPerRouteConnections = maxPerRouteConnections;
        }

        public Host() {
        }
    }

    public static class ZuulRoute {
        private String id;
        private String path;
        private String serviceId;
        private String url;
        private boolean stripPrefix = true;
        private Boolean retryable;
        private Set<String> sensitiveHeaders = new LinkedHashSet<String>();
        private boolean customSensitiveHeaders = false;

        public ZuulRoute(String id, String path, String serviceId, String url, boolean stripPrefix, Boolean retryable, Set<String> sensitiveHeaders) {
            this.id = id;
            this.path = path;
            this.serviceId = serviceId;
            this.url = url;
            this.stripPrefix = stripPrefix;
            this.retryable = retryable;
            this.sensitiveHeaders = sensitiveHeaders;
            this.customSensitiveHeaders = sensitiveHeaders != null;
        }

        public ZuulRoute(String text) {
            String location = null;
            String path = text;
            if (text.contains("=")) {
                String[] values = StringUtils.trimArrayElements((String[])StringUtils.split((String)text, (String)"="));
                location = values[1];
                path = values[0];
            }
            this.id = this.extractId(path);
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            this.setLocation(location);
            this.path = path;
        }

        public ZuulRoute(String path, String location) {
            this.id = this.extractId(path);
            this.path = path;
            this.setLocation(location);
        }

        public String getLocation() {
            if (StringUtils.hasText((String)this.url)) {
                return this.url;
            }
            return this.serviceId;
        }

        public void setLocation(String location) {
            if (location != null && (location.startsWith("http:") || location.startsWith("https:"))) {
                this.url = location;
            } else {
                this.serviceId = location;
            }
        }

        private String extractId(String path) {
            path = path.startsWith("/") ? path.substring(1) : path;
            path = path.replace("/*", "").replace("*", "");
            return path;
        }

        public Route getRoute(String prefix) {
            return new Route(this.id, this.path, this.getLocation(), prefix, this.retryable, this.isCustomSensitiveHeaders() ? this.sensitiveHeaders : null);
        }

        public void setSensitiveHeaders(Set<String> headers) {
            this.customSensitiveHeaders = true;
            this.sensitiveHeaders = new LinkedHashSet<String>(headers);
        }

        public boolean isCustomSensitiveHeaders() {
            return this.customSensitiveHeaders;
        }

        public String getId() {
            return this.id;
        }

        public String getPath() {
            return this.path;
        }

        public String getServiceId() {
            return this.serviceId;
        }

        public String getUrl() {
            return this.url;
        }

        public boolean isStripPrefix() {
            return this.stripPrefix;
        }

        public Boolean getRetryable() {
            return this.retryable;
        }

        public Set<String> getSensitiveHeaders() {
            return this.sensitiveHeaders;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public void setServiceId(String serviceId) {
            this.serviceId = serviceId;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public void setStripPrefix(boolean stripPrefix) {
            this.stripPrefix = stripPrefix;
        }

        public void setRetryable(Boolean retryable) {
            this.retryable = retryable;
        }

        public void setCustomSensitiveHeaders(boolean customSensitiveHeaders) {
            this.customSensitiveHeaders = customSensitiveHeaders;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ZuulRoute)) {
                return false;
            }
            ZuulRoute other = (ZuulRoute)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$path = this.getPath();
            String other$path = other.getPath();
            if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
                return false;
            }
            String this$serviceId = this.getServiceId();
            String other$serviceId = other.getServiceId();
            if (this$serviceId == null ? other$serviceId != null : !this$serviceId.equals(other$serviceId)) {
                return false;
            }
            String this$url = this.getUrl();
            String other$url = other.getUrl();
            if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
                return false;
            }
            if (this.isStripPrefix() != other.isStripPrefix()) {
                return false;
            }
            Boolean this$retryable = this.getRetryable();
            Boolean other$retryable = other.getRetryable();
            if (this$retryable == null ? other$retryable != null : !((Object)this$retryable).equals(other$retryable)) {
                return false;
            }
            Set<String> this$sensitiveHeaders = this.getSensitiveHeaders();
            Set<String> other$sensitiveHeaders = other.getSensitiveHeaders();
            if (this$sensitiveHeaders == null ? other$sensitiveHeaders != null : !((Object)this$sensitiveHeaders).equals(other$sensitiveHeaders)) {
                return false;
            }
            return this.isCustomSensitiveHeaders() == other.isCustomSensitiveHeaders();
        }

        protected boolean canEqual(Object other) {
            return other instanceof ZuulRoute;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $path = this.getPath();
            result = result * 59 + ($path == null ? 43 : $path.hashCode());
            String $serviceId = this.getServiceId();
            result = result * 59 + ($serviceId == null ? 43 : $serviceId.hashCode());
            String $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : $url.hashCode());
            result = result * 59 + (this.isStripPrefix() ? 79 : 97);
            Boolean $retryable = this.getRetryable();
            result = result * 59 + ($retryable == null ? 43 : ((Object)$retryable).hashCode());
            Set<String> $sensitiveHeaders = this.getSensitiveHeaders();
            result = result * 59 + ($sensitiveHeaders == null ? 43 : ((Object)$sensitiveHeaders).hashCode());
            result = result * 59 + (this.isCustomSensitiveHeaders() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "ZuulProperties.ZuulRoute(id=" + this.getId() + ", path=" + this.getPath() + ", serviceId=" + this.getServiceId() + ", url=" + this.getUrl() + ", stripPrefix=" + this.isStripPrefix() + ", retryable=" + this.getRetryable() + ", sensitiveHeaders=" + this.getSensitiveHeaders() + ", customSensitiveHeaders=" + this.isCustomSensitiveHeaders() + ")";
        }

        public ZuulRoute() {
        }
    }
}

