/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.ribbon.apache;

import com.netflix.client.RequestSpecificRetryHandler;
import com.netflix.client.RetryHandler;
import com.netflix.client.config.CommonClientConfigKey;
import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.ILoadBalancer;
import com.netflix.loadbalancer.Server;
import java.net.URI;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClientBuilder;
import org.springframework.cloud.netflix.ribbon.RibbonUtils;
import org.springframework.cloud.netflix.ribbon.ServerIntrospector;
import org.springframework.cloud.netflix.ribbon.apache.RibbonApacheHttpRequest;
import org.springframework.cloud.netflix.ribbon.apache.RibbonApacheHttpResponse;
import org.springframework.cloud.netflix.ribbon.support.AbstractLoadBalancingClient;
import org.springframework.web.util.UriComponentsBuilder;

public class RibbonLoadBalancingHttpClient
extends AbstractLoadBalancingClient<RibbonApacheHttpRequest, RibbonApacheHttpResponse, HttpClient> {
    @Deprecated
    public RibbonLoadBalancingHttpClient() {
    }

    @Deprecated
    public RibbonLoadBalancingHttpClient(ILoadBalancer lb) {
        super(lb);
    }

    public RibbonLoadBalancingHttpClient(IClientConfig config, ServerIntrospector serverIntrospector) {
        super(config, serverIntrospector);
    }

    public RibbonLoadBalancingHttpClient(HttpClient delegate, IClientConfig config, ServerIntrospector serverIntrospector) {
        super(delegate, config, serverIntrospector);
    }

    @Override
    protected HttpClient createDelegate(IClientConfig config) {
        return HttpClientBuilder.create().setMaxConnTotal(config.getPropertyAsInteger(CommonClientConfigKey.MaxTotalConnections, 0)).setMaxConnPerRoute(config.getPropertyAsInteger(CommonClientConfigKey.MaxConnectionsPerHost, 0)).disableCookieManagement().useSystemProperties().build();
    }

    public RibbonApacheHttpResponse execute(RibbonApacheHttpRequest request, IClientConfig configOverride) throws Exception {
        RequestConfig.Builder builder = RequestConfig.custom();
        IClientConfig config = configOverride != null ? configOverride : this.config;
        builder.setConnectTimeout(((Integer)config.get(CommonClientConfigKey.ConnectTimeout, (Object)this.connectTimeout)).intValue());
        builder.setSocketTimeout(((Integer)config.get(CommonClientConfigKey.ReadTimeout, (Object)this.readTimeout)).intValue());
        builder.setRedirectsEnabled(((Boolean)config.get(CommonClientConfigKey.FollowRedirects, (Object)this.followRedirects)).booleanValue());
        RequestConfig requestConfig = builder.build();
        if (this.isSecure(configOverride)) {
            URI secureUri = UriComponentsBuilder.fromUri((URI)request.getUri()).scheme("https").build().toUri();
            request = request.withNewUri(secureUri);
        }
        HttpUriRequest httpUriRequest = request.toRequest(requestConfig);
        HttpResponse httpResponse = ((HttpClient)this.delegate).execute(httpUriRequest);
        return new RibbonApacheHttpResponse(httpResponse, httpUriRequest.getURI());
    }

    public URI reconstructURIWithServer(Server server, URI original) {
        URI uri = RibbonUtils.updateToHttpsIfNeeded(original, this.config, this.serverIntrospector, server);
        return super.reconstructURIWithServer(server, uri);
    }

    @Override
    public RequestSpecificRetryHandler getRequestSpecificRetryHandler(RibbonApacheHttpRequest request, IClientConfig requestConfig) {
        return new RequestSpecificRetryHandler(false, false, RetryHandler.DEFAULT, null);
    }
}

