/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.ribbon.okhttp;

import com.netflix.client.config.CommonClientConfigKey;
import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.ILoadBalancer;
import com.netflix.loadbalancer.Server;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.springframework.cloud.netflix.ribbon.RibbonUtils;
import org.springframework.cloud.netflix.ribbon.ServerIntrospector;
import org.springframework.cloud.netflix.ribbon.okhttp.OkHttpRibbonRequest;
import org.springframework.cloud.netflix.ribbon.okhttp.OkHttpRibbonResponse;
import org.springframework.cloud.netflix.ribbon.support.AbstractLoadBalancingClient;
import org.springframework.web.util.UriComponentsBuilder;

public class OkHttpLoadBalancingClient
extends AbstractLoadBalancingClient<OkHttpRibbonRequest, OkHttpRibbonResponse, OkHttpClient> {
    @Deprecated
    public OkHttpLoadBalancingClient() {
    }

    @Deprecated
    public OkHttpLoadBalancingClient(ILoadBalancer lb) {
        super(lb);
    }

    public OkHttpLoadBalancingClient(IClientConfig config, ServerIntrospector serverIntrospector) {
        super(config, serverIntrospector);
    }

    public OkHttpLoadBalancingClient(OkHttpClient delegate, IClientConfig config, ServerIntrospector serverIntrospector) {
        super(delegate, config, serverIntrospector);
    }

    @Override
    protected OkHttpClient createDelegate(IClientConfig config) {
        return new OkHttpClient();
    }

    public OkHttpRibbonResponse execute(OkHttpRibbonRequest ribbonRequest, IClientConfig configOverride) throws Exception {
        boolean secure = this.isSecure(configOverride);
        if (secure) {
            URI secureUri = UriComponentsBuilder.fromUri((URI)ribbonRequest.getUri()).scheme("https").build().toUri();
            ribbonRequest = ribbonRequest.withNewUri(secureUri);
        }
        OkHttpClient httpClient = this.getOkHttpClient(configOverride, secure);
        Request request = ribbonRequest.toRequest();
        Response response = httpClient.newCall(request).execute();
        return new OkHttpRibbonResponse(response, ribbonRequest.getUri());
    }

    OkHttpClient getOkHttpClient(IClientConfig configOverride, boolean secure) {
        OkHttpClient.Builder builder = ((OkHttpClient)this.delegate).newBuilder();
        if (configOverride != null) {
            builder.connectTimeout((long)((Integer)configOverride.get(CommonClientConfigKey.ConnectTimeout, (Object)this.connectTimeout)).intValue(), TimeUnit.MILLISECONDS);
            builder.readTimeout((long)((Integer)configOverride.get(CommonClientConfigKey.ReadTimeout, (Object)this.readTimeout)).intValue(), TimeUnit.MILLISECONDS);
            builder.followRedirects(((Boolean)configOverride.get(CommonClientConfigKey.FollowRedirects, (Object)this.followRedirects)).booleanValue());
            if (secure) {
                builder.followSslRedirects(((Boolean)configOverride.get(CommonClientConfigKey.FollowRedirects, (Object)this.followRedirects)).booleanValue());
            }
        } else {
            builder.connectTimeout((long)this.connectTimeout, TimeUnit.MILLISECONDS);
            builder.readTimeout((long)this.readTimeout, TimeUnit.MILLISECONDS);
            builder.followRedirects(this.followRedirects);
            if (secure) {
                builder.followSslRedirects(this.followRedirects);
            }
        }
        return builder.build();
    }

    public URI reconstructURIWithServer(Server server, URI original) {
        URI uri = RibbonUtils.updateToHttpsIfNeeded(original, this.config, this.serverIntrospector, server);
        return super.reconstructURIWithServer(server, uri);
    }
}

