/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.zuul.filters.route.support;

import com.netflix.client.AbstractLoadBalancerAwareClient;
import com.netflix.client.ClientRequest;
import com.netflix.client.http.HttpResponse;
import com.netflix.config.DynamicIntProperty;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.hystrix.HystrixCommand;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandProperties;
import com.netflix.zuul.context.RequestContext;
import org.springframework.cloud.netflix.ribbon.RibbonHttpResponse;
import org.springframework.cloud.netflix.zuul.filters.ZuulProperties;
import org.springframework.cloud.netflix.zuul.filters.route.RibbonCommand;
import org.springframework.cloud.netflix.zuul.filters.route.RibbonCommandContext;
import org.springframework.http.client.ClientHttpResponse;

public abstract class AbstractRibbonCommand<LBC extends AbstractLoadBalancerAwareClient<RQ, RS>, RQ extends ClientRequest, RS extends HttpResponse>
extends HystrixCommand<ClientHttpResponse>
implements RibbonCommand {
    protected final LBC client;
    protected RibbonCommandContext context;

    public AbstractRibbonCommand(LBC client, RibbonCommandContext context, ZuulProperties zuulProperties) {
        this("default", client, context, zuulProperties);
    }

    public AbstractRibbonCommand(String commandKey, LBC client, RibbonCommandContext context, ZuulProperties zuulProperties) {
        super(AbstractRibbonCommand.getSetter(commandKey, zuulProperties));
        this.client = client;
        this.context = context;
    }

    protected static HystrixCommand.Setter getSetter(String commandKey, ZuulProperties zuulProperties) {
        HystrixCommandProperties.Setter setter = HystrixCommandProperties.Setter().withExecutionIsolationStrategy(zuulProperties.getRibbonIsolationStrategy());
        if (zuulProperties.getRibbonIsolationStrategy() == HystrixCommandProperties.ExecutionIsolationStrategy.SEMAPHORE) {
            String name = "zuul.eureka." + commandKey + ".semaphore.maxSemaphores";
            DynamicIntProperty value = DynamicPropertyFactory.getInstance().getIntProperty(name, zuulProperties.getSemaphore().getMaxSemaphores());
            setter.withExecutionIsolationSemaphoreMaxConcurrentRequests(value.get());
        }
        return HystrixCommand.Setter.withGroupKey((HystrixCommandGroupKey)HystrixCommandGroupKey.Factory.asKey((String)"RibbonCommand")).andCommandKey(HystrixCommandKey.Factory.asKey((String)commandKey)).andCommandPropertiesDefaults(setter);
    }

    protected ClientHttpResponse run() throws Exception {
        RequestContext context = RequestContext.getCurrentContext();
        RQ request = this.createRequest();
        HttpResponse response = (HttpResponse)this.client.executeWithLoadBalancer(request);
        context.set("ribbonResponse", (Object)response);
        if (this.isResponseTimedOut() && response != null) {
            response.close();
        }
        return new RibbonHttpResponse(response);
    }

    public LBC getClient() {
        return this.client;
    }

    public RibbonCommandContext getContext() {
        return this.context;
    }

    protected abstract RQ createRequest() throws Exception;
}

