/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.zuul.filters.route.okhttp;

import java.beans.ConstructorProperties;
import org.springframework.cloud.netflix.ribbon.SpringClientFactory;
import org.springframework.cloud.netflix.ribbon.okhttp.OkHttpLoadBalancingClient;
import org.springframework.cloud.netflix.zuul.filters.ZuulProperties;
import org.springframework.cloud.netflix.zuul.filters.route.RibbonCommandContext;
import org.springframework.cloud.netflix.zuul.filters.route.RibbonCommandFactory;
import org.springframework.cloud.netflix.zuul.filters.route.okhttp.OkHttpRibbonCommand;

public class OkHttpRibbonCommandFactory
implements RibbonCommandFactory<OkHttpRibbonCommand> {
    private final SpringClientFactory clientFactory;
    private final ZuulProperties zuulProperties;

    @Override
    public OkHttpRibbonCommand create(RibbonCommandContext context) {
        String serviceId = context.getServiceId();
        OkHttpLoadBalancingClient client = this.clientFactory.getClient(serviceId, OkHttpLoadBalancingClient.class);
        client.setLoadBalancer(this.clientFactory.getLoadBalancer(serviceId));
        return new OkHttpRibbonCommand(serviceId, client, context, this.zuulProperties);
    }

    @ConstructorProperties(value={"clientFactory", "zuulProperties"})
    public OkHttpRibbonCommandFactory(SpringClientFactory clientFactory, ZuulProperties zuulProperties) {
        this.clientFactory = clientFactory;
        this.zuulProperties = zuulProperties;
    }
}

