/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.zuul.filters.route.apache;

import java.beans.ConstructorProperties;
import org.springframework.cloud.netflix.ribbon.SpringClientFactory;
import org.springframework.cloud.netflix.ribbon.apache.RibbonLoadBalancingHttpClient;
import org.springframework.cloud.netflix.zuul.filters.ZuulProperties;
import org.springframework.cloud.netflix.zuul.filters.route.RibbonCommandContext;
import org.springframework.cloud.netflix.zuul.filters.route.RibbonCommandFactory;
import org.springframework.cloud.netflix.zuul.filters.route.apache.HttpClientRibbonCommand;

public class HttpClientRibbonCommandFactory
implements RibbonCommandFactory<HttpClientRibbonCommand> {
    private final SpringClientFactory clientFactory;
    private final ZuulProperties zuulProperties;

    @Override
    public HttpClientRibbonCommand create(RibbonCommandContext context) {
        String serviceId = context.getServiceId();
        RibbonLoadBalancingHttpClient client = this.clientFactory.getClient(serviceId, RibbonLoadBalancingHttpClient.class);
        client.setLoadBalancer(this.clientFactory.getLoadBalancer(serviceId));
        return new HttpClientRibbonCommand(serviceId, client, context, this.zuulProperties);
    }

    @ConstructorProperties(value={"clientFactory", "zuulProperties"})
    public HttpClientRibbonCommandFactory(SpringClientFactory clientFactory, ZuulProperties zuulProperties) {
        this.clientFactory = clientFactory;
        this.zuulProperties = zuulProperties;
    }
}

