/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.zuul.filters.route;

import java.beans.ConstructorProperties;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;
import org.springframework.cloud.netflix.ribbon.support.RibbonRequestCustomizer;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ReflectionUtils;

public class RibbonCommandContext {
    @NonNull
    private final String serviceId;
    @NonNull
    private final String method;
    @NonNull
    private final String uri;
    private final Boolean retryable;
    @NonNull
    private final MultiValueMap<String, String> headers;
    @NonNull
    private final MultiValueMap<String, String> params;
    private final InputStream requestEntity;
    @NonNull
    private final List<RibbonRequestCustomizer> requestCustomizers;
    private Long contentLength;

    @Deprecated
    public RibbonCommandContext(String serviceId, String method, String uri, Boolean retryable, MultiValueMap<String, String> headers, MultiValueMap<String, String> params, InputStream requestEntity) {
        this(serviceId, method, uri, retryable, headers, params, requestEntity, new ArrayList<RibbonRequestCustomizer>(), null);
    }

    public URI uri() {
        try {
            return new URI(this.uri);
        }
        catch (URISyntaxException e) {
            ReflectionUtils.rethrowRuntimeException((Throwable)e);
            return null;
        }
    }

    @Deprecated
    public String getVerb() {
        return this.method;
    }

    @NonNull
    public String getServiceId() {
        return this.serviceId;
    }

    @NonNull
    public String getMethod() {
        return this.method;
    }

    @NonNull
    public String getUri() {
        return this.uri;
    }

    public Boolean getRetryable() {
        return this.retryable;
    }

    @NonNull
    public MultiValueMap<String, String> getHeaders() {
        return this.headers;
    }

    @NonNull
    public MultiValueMap<String, String> getParams() {
        return this.params;
    }

    public InputStream getRequestEntity() {
        return this.requestEntity;
    }

    @NonNull
    public List<RibbonRequestCustomizer> getRequestCustomizers() {
        return this.requestCustomizers;
    }

    public Long getContentLength() {
        return this.contentLength;
    }

    public void setContentLength(Long contentLength) {
        this.contentLength = contentLength;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RibbonCommandContext)) {
            return false;
        }
        RibbonCommandContext other = (RibbonCommandContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$serviceId = this.getServiceId();
        String other$serviceId = other.getServiceId();
        if (this$serviceId == null ? other$serviceId != null : !this$serviceId.equals(other$serviceId)) {
            return false;
        }
        String this$method = this.getMethod();
        String other$method = other.getMethod();
        if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
            return false;
        }
        String this$uri = this.getUri();
        String other$uri = other.getUri();
        if (this$uri == null ? other$uri != null : !this$uri.equals(other$uri)) {
            return false;
        }
        Boolean this$retryable = this.getRetryable();
        Boolean other$retryable = other.getRetryable();
        if (this$retryable == null ? other$retryable != null : !((Object)this$retryable).equals(other$retryable)) {
            return false;
        }
        MultiValueMap<String, String> this$headers = this.getHeaders();
        MultiValueMap<String, String> other$headers = other.getHeaders();
        if (this$headers == null ? other$headers != null : !this$headers.equals(other$headers)) {
            return false;
        }
        MultiValueMap<String, String> this$params = this.getParams();
        MultiValueMap<String, String> other$params = other.getParams();
        if (this$params == null ? other$params != null : !this$params.equals(other$params)) {
            return false;
        }
        InputStream this$requestEntity = this.getRequestEntity();
        InputStream other$requestEntity = other.getRequestEntity();
        if (this$requestEntity == null ? other$requestEntity != null : !this$requestEntity.equals(other$requestEntity)) {
            return false;
        }
        List<RibbonRequestCustomizer> this$requestCustomizers = this.getRequestCustomizers();
        List<RibbonRequestCustomizer> other$requestCustomizers = other.getRequestCustomizers();
        if (this$requestCustomizers == null ? other$requestCustomizers != null : !((Object)this$requestCustomizers).equals(other$requestCustomizers)) {
            return false;
        }
        Long this$contentLength = this.getContentLength();
        Long other$contentLength = other.getContentLength();
        return !(this$contentLength == null ? other$contentLength != null : !((Object)this$contentLength).equals(other$contentLength));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RibbonCommandContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $serviceId = this.getServiceId();
        result = result * 59 + ($serviceId == null ? 43 : $serviceId.hashCode());
        String $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : $method.hashCode());
        String $uri = this.getUri();
        result = result * 59 + ($uri == null ? 43 : $uri.hashCode());
        Boolean $retryable = this.getRetryable();
        result = result * 59 + ($retryable == null ? 43 : ((Object)$retryable).hashCode());
        MultiValueMap<String, String> $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : $headers.hashCode());
        MultiValueMap<String, String> $params = this.getParams();
        result = result * 59 + ($params == null ? 43 : $params.hashCode());
        InputStream $requestEntity = this.getRequestEntity();
        result = result * 59 + ($requestEntity == null ? 43 : $requestEntity.hashCode());
        List<RibbonRequestCustomizer> $requestCustomizers = this.getRequestCustomizers();
        result = result * 59 + ($requestCustomizers == null ? 43 : ((Object)$requestCustomizers).hashCode());
        Long $contentLength = this.getContentLength();
        result = result * 59 + ($contentLength == null ? 43 : ((Object)$contentLength).hashCode());
        return result;
    }

    public String toString() {
        return "RibbonCommandContext(serviceId=" + this.getServiceId() + ", method=" + this.getMethod() + ", uri=" + this.getUri() + ", retryable=" + this.getRetryable() + ", headers=" + this.getHeaders() + ", params=" + this.getParams() + ", requestEntity=" + this.getRequestEntity() + ", requestCustomizers=" + this.getRequestCustomizers() + ", contentLength=" + this.getContentLength() + ")";
    }

    @ConstructorProperties(value={"serviceId", "method", "uri", "retryable", "headers", "params", "requestEntity", "requestCustomizers"})
    public RibbonCommandContext(@NonNull String serviceId, @NonNull String method, @NonNull String uri, Boolean retryable, @NonNull MultiValueMap<String, String> headers, @NonNull MultiValueMap<String, String> params, InputStream requestEntity, @NonNull List<RibbonRequestCustomizer> requestCustomizers) {
        if (serviceId == null) {
            throw new NullPointerException("serviceId");
        }
        if (method == null) {
            throw new NullPointerException("method");
        }
        if (uri == null) {
            throw new NullPointerException("uri");
        }
        if (headers == null) {
            throw new NullPointerException("headers");
        }
        if (params == null) {
            throw new NullPointerException("params");
        }
        if (requestCustomizers == null) {
            throw new NullPointerException("requestCustomizers");
        }
        this.serviceId = serviceId;
        this.method = method;
        this.uri = uri;
        this.retryable = retryable;
        this.headers = headers;
        this.params = params;
        this.requestEntity = requestEntity;
        this.requestCustomizers = requestCustomizers;
    }

    @ConstructorProperties(value={"serviceId", "method", "uri", "retryable", "headers", "params", "requestEntity", "requestCustomizers", "contentLength"})
    public RibbonCommandContext(@NonNull String serviceId, @NonNull String method, @NonNull String uri, Boolean retryable, @NonNull MultiValueMap<String, String> headers, @NonNull MultiValueMap<String, String> params, InputStream requestEntity, @NonNull List<RibbonRequestCustomizer> requestCustomizers, Long contentLength) {
        if (serviceId == null) {
            throw new NullPointerException("serviceId");
        }
        if (method == null) {
            throw new NullPointerException("method");
        }
        if (uri == null) {
            throw new NullPointerException("uri");
        }
        if (headers == null) {
            throw new NullPointerException("headers");
        }
        if (params == null) {
            throw new NullPointerException("params");
        }
        if (requestCustomizers == null) {
            throw new NullPointerException("requestCustomizers");
        }
        this.serviceId = serviceId;
        this.method = method;
        this.uri = uri;
        this.retryable = retryable;
        this.headers = headers;
        this.params = params;
        this.requestEntity = requestEntity;
        this.requestCustomizers = requestCustomizers;
        this.contentLength = contentLength;
    }
}

