/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.zuul.filters.pre;

import com.netflix.zuul.ZuulFilter;
import com.netflix.zuul.context.RequestContext;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.netflix.zuul.filters.ProxyRequestHelper;
import org.springframework.cloud.netflix.zuul.filters.Route;
import org.springframework.cloud.netflix.zuul.filters.RouteLocator;
import org.springframework.cloud.netflix.zuul.filters.ZuulProperties;
import org.springframework.cloud.netflix.zuul.util.RequestUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UrlPathHelper;

public class PreDecorationFilter
extends ZuulFilter {
    private static final Log log = LogFactory.getLog(PreDecorationFilter.class);
    public static final int FILTER_ORDER = 5;
    private RouteLocator routeLocator;
    private String dispatcherServletPath;
    private ZuulProperties properties;
    private UrlPathHelper urlPathHelper = new UrlPathHelper();
    private ProxyRequestHelper proxyRequestHelper;

    public PreDecorationFilter(RouteLocator routeLocator, String dispatcherServletPath, ZuulProperties properties, ProxyRequestHelper proxyRequestHelper) {
        this.routeLocator = routeLocator;
        this.properties = properties;
        this.urlPathHelper.setRemoveSemicolonContent(properties.isRemoveSemicolonContent());
        this.dispatcherServletPath = dispatcherServletPath;
        this.proxyRequestHelper = proxyRequestHelper;
    }

    public int filterOrder() {
        return 5;
    }

    public String filterType() {
        return "pre";
    }

    public boolean shouldFilter() {
        RequestContext ctx = RequestContext.getCurrentContext();
        return !ctx.containsKey((Object)"forward.to") && !ctx.containsKey((Object)"serviceId");
    }

    public Object run() {
        RequestContext ctx = RequestContext.getCurrentContext();
        String requestURI = this.urlPathHelper.getPathWithinApplication(ctx.getRequest());
        Route route = this.routeLocator.getMatchingRoute(requestURI);
        if (route != null) {
            String location = route.getLocation();
            if (location != null) {
                ctx.put((Object)"requestURI", (Object)route.getPath());
                ctx.put((Object)"proxy", (Object)route.getId());
                if (!route.isCustomSensitiveHeaders()) {
                    this.proxyRequestHelper.addIgnoredHeaders(this.properties.getSensitiveHeaders().toArray(new String[0]));
                } else {
                    this.proxyRequestHelper.addIgnoredHeaders(route.getSensitiveHeaders().toArray(new String[0]));
                }
                if (route.getRetryable() != null) {
                    ctx.put((Object)"retryable", (Object)route.getRetryable());
                }
                if (location.startsWith("http:") || location.startsWith("https:")) {
                    ctx.setRouteHost(this.getUrl(location));
                    ctx.addOriginResponseHeader("X-Zuul-Service", location);
                } else {
                    if (location.startsWith("forward:")) {
                        ctx.set("forward.to", (Object)StringUtils.cleanPath((String)(location.substring("forward:".length()) + route.getPath())));
                        ctx.setRouteHost(null);
                        return null;
                    }
                    ctx.set("serviceId", (Object)location);
                    ctx.setRouteHost(null);
                    ctx.addOriginResponseHeader("X-Zuul-ServiceId", location);
                }
                if (this.properties.isAddProxyHeaders()) {
                    String prefix;
                    ctx.addZuulRequestHeader("X-Forwarded-Host", this.toHostHeader(ctx.getRequest()));
                    ctx.addZuulRequestHeader("X-Forwarded-Port", String.valueOf(ctx.getRequest().getServerPort()));
                    ctx.addZuulRequestHeader("X-Forwarded-Proto", ctx.getRequest().getScheme());
                    String forwardedPrefix = ctx.getRequest().getHeader("X-Forwarded-Prefix");
                    String contextPath = ctx.getRequest().getContextPath();
                    String string = StringUtils.hasLength((String)forwardedPrefix) ? forwardedPrefix : (prefix = StringUtils.hasLength((String)contextPath) ? contextPath : null);
                    if (StringUtils.hasText((String)route.getPrefix())) {
                        StringBuilder newPrefixBuilder = new StringBuilder();
                        if (prefix != null) {
                            if (prefix.endsWith("/") && route.getPrefix().startsWith("/")) {
                                newPrefixBuilder.append(prefix, 0, prefix.length() - 1);
                            } else {
                                newPrefixBuilder.append(prefix);
                            }
                        }
                        newPrefixBuilder.append(route.getPrefix());
                        prefix = newPrefixBuilder.toString();
                    }
                    if (prefix != null) {
                        ctx.addZuulRequestHeader("X-Forwarded-Prefix", prefix);
                    }
                    String xforwardedfor = ctx.getRequest().getHeader("X-Forwarded-For");
                    String remoteAddr = ctx.getRequest().getRemoteAddr();
                    if (xforwardedfor == null) {
                        xforwardedfor = remoteAddr;
                    } else if (!xforwardedfor.contains(remoteAddr)) {
                        xforwardedfor = xforwardedfor + ", " + remoteAddr;
                    }
                    ctx.addZuulRequestHeader("X-Forwarded-For", xforwardedfor);
                }
                if (this.properties.isAddHostHeader()) {
                    ctx.addZuulRequestHeader("Host", this.toHostHeader(ctx.getRequest()));
                }
            }
        } else {
            log.warn((Object)("No route found for uri: " + requestURI));
            String fallBackUri = requestURI;
            String fallbackPrefix = this.dispatcherServletPath;
            if (RequestUtils.isZuulServletRequest()) {
                log.debug((Object)("zuulServletPath=" + this.properties.getServletPath()));
                fallBackUri = fallBackUri.replaceFirst(this.properties.getServletPath(), "");
                log.debug((Object)("Replaced Zuul servlet path:" + fallBackUri));
            } else {
                log.debug((Object)("dispatcherServletPath=" + this.dispatcherServletPath));
                fallBackUri = fallBackUri.replaceFirst(this.dispatcherServletPath, "");
                log.debug((Object)("Replaced DispatcherServlet servlet path:" + fallBackUri));
            }
            if (!fallBackUri.startsWith("/")) {
                fallBackUri = "/" + fallBackUri;
            }
            String forwardURI = fallbackPrefix + fallBackUri;
            forwardURI = forwardURI.replaceAll("//", "/");
            ctx.set("forward.to", (Object)forwardURI);
        }
        return null;
    }

    private String toHostHeader(HttpServletRequest request) {
        int port = request.getServerPort();
        if (port == 80 && "http".equals(request.getScheme()) || port == 443 && "https".equals(request.getScheme())) {
            return request.getServerName();
        }
        return request.getServerName() + ":" + port;
    }

    private URL getUrl(String target) {
        try {
            return new URL(target);
        }
        catch (MalformedURLException ex) {
            throw new IllegalStateException("Target URL is malformed", ex);
        }
    }
}

