/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.ribbon.support;

import com.netflix.client.AbstractLoadBalancerAwareClient;
import com.netflix.client.IResponse;
import com.netflix.client.RequestSpecificRetryHandler;
import com.netflix.client.RetryHandler;
import com.netflix.client.config.CommonClientConfigKey;
import com.netflix.client.config.DefaultClientConfigImpl;
import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.ILoadBalancer;
import org.springframework.cloud.netflix.ribbon.support.ContextAwareRequest;

public abstract class AbstractLoadBalancingClient<S extends ContextAwareRequest, T extends IResponse>
extends AbstractLoadBalancerAwareClient<S, T> {
    protected int connectTimeout;
    protected int readTimeout;
    protected boolean secure;
    protected boolean followRedirects;
    protected boolean okToRetryOnAllOperations;

    public AbstractLoadBalancingClient() {
        super(null);
        this.setRetryHandler(RetryHandler.DEFAULT);
    }

    public AbstractLoadBalancingClient(ILoadBalancer lb) {
        super(lb);
        this.setRetryHandler(RetryHandler.DEFAULT);
    }

    public void initWithNiwsConfig(IClientConfig clientConfig) {
        super.initWithNiwsConfig(clientConfig);
        this.connectTimeout = clientConfig.getPropertyAsInteger(CommonClientConfigKey.ConnectTimeout, 2000);
        this.readTimeout = clientConfig.getPropertyAsInteger(CommonClientConfigKey.ReadTimeout, 5000);
        this.secure = clientConfig.getPropertyAsBoolean(CommonClientConfigKey.IsSecure, false);
        this.followRedirects = clientConfig.getPropertyAsBoolean(CommonClientConfigKey.FollowRedirects, DefaultClientConfigImpl.DEFAULT_FOLLOW_REDIRECTS.booleanValue());
        this.okToRetryOnAllOperations = clientConfig.getPropertyAsBoolean(CommonClientConfigKey.OkToRetryOnAllOperations, DefaultClientConfigImpl.DEFAULT_OK_TO_RETRY_ON_ALL_OPERATIONS.booleanValue());
    }

    public RequestSpecificRetryHandler getRequestSpecificRetryHandler(S request, IClientConfig requestConfig) {
        if (this.okToRetryOnAllOperations) {
            return new RequestSpecificRetryHandler(true, true, this.getRetryHandler(), requestConfig);
        }
        if (!((ContextAwareRequest)((Object)request)).getContext().getMethod().equals("GET")) {
            return new RequestSpecificRetryHandler(true, false, this.getRetryHandler(), requestConfig);
        }
        return new RequestSpecificRetryHandler(true, true, this.getRetryHandler(), requestConfig);
    }

    protected boolean isSecure(IClientConfig config) {
        return config != null ? (Boolean)config.get(CommonClientConfigKey.IsSecure) : this.secure;
    }
}

