/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.ribbon.okhttp;

import com.netflix.client.config.CommonClientConfigKey;
import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.ILoadBalancer;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.springframework.cloud.netflix.ribbon.okhttp.OkHttpRibbonRequest;
import org.springframework.cloud.netflix.ribbon.okhttp.OkHttpRibbonResponse;
import org.springframework.cloud.netflix.ribbon.support.AbstractLoadBalancingClient;
import org.springframework.web.util.UriComponentsBuilder;

public class OkHttpLoadBalancingClient
extends AbstractLoadBalancingClient<OkHttpRibbonRequest, OkHttpRibbonResponse> {
    private final OkHttpClient delegate = new OkHttpClient();

    public OkHttpLoadBalancingClient() {
    }

    public OkHttpLoadBalancingClient(ILoadBalancer lb) {
        super(lb);
    }

    public OkHttpRibbonResponse execute(OkHttpRibbonRequest ribbonRequest, IClientConfig configOverride) throws Exception {
        boolean secure = this.isSecure(configOverride);
        if (secure) {
            URI secureUri = UriComponentsBuilder.fromUri((URI)ribbonRequest.getUri()).scheme("https").build().toUri();
            ribbonRequest = ribbonRequest.withNewUri(secureUri);
        }
        OkHttpClient httpClient = this.getOkHttpClient(configOverride, secure);
        Request request = ribbonRequest.toRequest();
        Response response = httpClient.newCall(request).execute();
        return new OkHttpRibbonResponse(response, ribbonRequest.getUri());
    }

    OkHttpClient getOkHttpClient(IClientConfig configOverride, boolean secure) {
        OkHttpClient.Builder builder = this.delegate.newBuilder();
        if (configOverride != null) {
            builder.connectTimeout((long)((Integer)configOverride.get(CommonClientConfigKey.ConnectTimeout, (Object)this.connectTimeout)).intValue(), TimeUnit.MILLISECONDS);
            builder.readTimeout((long)((Integer)configOverride.get(CommonClientConfigKey.ReadTimeout, (Object)this.readTimeout)).intValue(), TimeUnit.MILLISECONDS);
            builder.followRedirects(((Boolean)configOverride.get(CommonClientConfigKey.FollowRedirects, (Object)this.followRedirects)).booleanValue());
            if (secure) {
                builder.followSslRedirects(((Boolean)configOverride.get(CommonClientConfigKey.FollowRedirects, (Object)this.followRedirects)).booleanValue());
            }
        } else {
            builder.connectTimeout((long)this.connectTimeout, TimeUnit.MILLISECONDS);
            builder.readTimeout((long)this.readTimeout, TimeUnit.MILLISECONDS);
            builder.followRedirects(this.followRedirects);
            if (secure) {
                builder.followSslRedirects(this.followRedirects);
            }
        }
        return builder.build();
    }
}

