/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.ribbon.apache;

import com.netflix.client.config.CommonClientConfigKey;
import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.ILoadBalancer;
import java.net.URI;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClientBuilder;
import org.springframework.cloud.netflix.ribbon.apache.RibbonApacheHttpRequest;
import org.springframework.cloud.netflix.ribbon.apache.RibbonApacheHttpResponse;
import org.springframework.cloud.netflix.ribbon.support.AbstractLoadBalancingClient;
import org.springframework.web.util.UriComponentsBuilder;

public class RibbonLoadBalancingHttpClient
extends AbstractLoadBalancingClient<RibbonApacheHttpRequest, RibbonApacheHttpResponse> {
    private final HttpClient delegate = HttpClientBuilder.create().disableCookieManagement().build();

    public RibbonLoadBalancingHttpClient() {
    }

    public RibbonLoadBalancingHttpClient(ILoadBalancer lb) {
        super(lb);
    }

    public RibbonApacheHttpResponse execute(RibbonApacheHttpRequest request, IClientConfig configOverride) throws Exception {
        RequestConfig.Builder builder = RequestConfig.custom();
        if (configOverride != null) {
            builder.setConnectTimeout(((Integer)configOverride.get(CommonClientConfigKey.ConnectTimeout, (Object)this.connectTimeout)).intValue());
            builder.setSocketTimeout(((Integer)configOverride.get(CommonClientConfigKey.ReadTimeout, (Object)this.readTimeout)).intValue());
            builder.setRedirectsEnabled(((Boolean)configOverride.get(CommonClientConfigKey.FollowRedirects, (Object)this.followRedirects)).booleanValue());
        } else {
            builder.setConnectTimeout(this.connectTimeout);
            builder.setSocketTimeout(this.readTimeout);
            builder.setRedirectsEnabled(this.followRedirects);
        }
        RequestConfig requestConfig = builder.build();
        if (this.isSecure(configOverride)) {
            URI secureUri = UriComponentsBuilder.fromUri((URI)request.getUri()).scheme("https").build().toUri();
            request = request.withNewUri(secureUri);
        }
        HttpUriRequest httpUriRequest = request.toRequest(requestConfig);
        HttpResponse httpResponse = this.delegate.execute(httpUriRequest);
        return new RibbonApacheHttpResponse(httpResponse, httpUriRequest.getURI());
    }
}

