/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.feign;

import feign.Feign;
import feign.Target;
import feign.hystrix.HystrixFeign;
import org.springframework.cloud.netflix.feign.FeignClientFactoryBean;
import org.springframework.cloud.netflix.feign.FeignContext;
import org.springframework.cloud.netflix.feign.Targeter;

class HystrixTargeter
implements Targeter {
    HystrixTargeter() {
    }

    @Override
    public <T> T target(FeignClientFactoryBean factory, Feign.Builder feign, FeignContext context, Target.HardCodedTarget<T> target) {
        if (factory.getFallback() == Void.TYPE || !(feign instanceof HystrixFeign.Builder)) {
            return (T)feign.target(target);
        }
        Object fallbackInstance = context.getInstance(factory.getName(), factory.getFallback());
        if (fallbackInstance == null) {
            throw new IllegalStateException(String.format("No fallback instance of type %s found for feign client %s", factory.getFallback(), factory.getName()));
        }
        if (!target.type().isAssignableFrom(factory.getFallback())) {
            throw new IllegalStateException(String.format("Incompatible fallback instance. Fallback of type %s is not assignable to %s for feign client %s", factory.getFallback(), target.type(), factory.getName()));
        }
        HystrixFeign.Builder builder = (HystrixFeign.Builder)feign;
        return (T)builder.target(target, fallbackInstance);
    }
}

