/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.metrics.atlas;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.dataformat.smile.SmileFactory;
import com.fasterxml.jackson.dataformat.smile.SmileGenerator;
import com.netflix.servo.Metric;
import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.publish.MetricObserver;
import com.netflix.servo.tag.BasicTag;
import com.netflix.servo.tag.Tag;
import com.netflix.servo.tag.TagList;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.netflix.metrics.atlas.AtlasMetricObserverConfigBean;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

public class AtlasMetricObserver
implements MetricObserver {
    private static final Log logger = LogFactory.getLog(AtlasMetricObserver.class);
    private static final SmileFactory smileFactory = new SmileFactory();
    private static final Tag atlasRateTag = new BasicTag("atlas.dstype", "rate");
    private static final Tag atlasCounterTag = new BasicTag("atlas.dstype", "counter");
    private static final Tag atlasGaugeTag = new BasicTag("atlas.dstype", "gauge");
    private static final Pattern validAtlasTag = Pattern.compile("[\\.\\-\\w]+");
    private AtlasMetricObserverConfigBean config;
    private RestTemplate restTemplate;
    private TagList commonTags;
    private String uri;

    public AtlasMetricObserver(AtlasMetricObserverConfigBean config, RestTemplate restTemplate, TagList commonTags) {
        this.config = config;
        this.commonTags = commonTags;
        this.restTemplate = restTemplate;
        this.uri = AtlasMetricObserver.normalizeAtlasUri(config.getUri());
        if (!AtlasMetricObserver.validTags(commonTags)) {
            throw new IllegalArgumentException("One or more atlas tags contain invalid characters, must match [\\.\\-\\w]+");
        }
    }

    public String getName() {
        return "atlas";
    }

    protected static boolean validTags(TagList tags) {
        for (Tag tag : tags) {
            if (!validAtlasTag.matcher(tag.getKey()).matches()) {
                logger.debug((Object)("Invalid tag key " + tag.getKey()));
                return false;
            }
            if (validAtlasTag.matcher(tag.getValue()).matches()) continue;
            logger.debug((Object)("Invalid tag value " + tag.getValue()));
            return false;
        }
        return true;
    }

    protected static String normalizeAtlasUri(String uri) {
        if (uri != null) {
            Matcher matcher = Pattern.compile("(.+?)(/api/v1/publish)?/?").matcher(uri);
            if (matcher.matches()) {
                return matcher.group(1) + "/api/v1/publish";
            }
            throw new IllegalStateException("netflix.atlas.uri is not a valid uri");
        }
        throw new IllegalStateException("netflix.atlas.uri was not found in your properties and is required to communicate with Atlas");
    }

    public void update(List<Metric> rawMetrics) {
        if (!this.config.isEnabled()) {
            logger.debug((Object)"Atlas metric observer disabled. Not sending metrics.");
            return;
        }
        if (rawMetrics.isEmpty()) {
            logger.debug((Object)"Metrics list is empty, no data being sent to server.");
            return;
        }
        List<Metric> metrics = AtlasMetricObserver.addTypeTagsAsNecessary(rawMetrics);
        for (int i = 0; i < metrics.size(); i += this.config.getBatchSize()) {
            List<Metric> batch = metrics.subList(i, Math.min(metrics.size(), this.config.getBatchSize() + i));
            logger.debug((Object)("Sending a metrics batch of size " + batch.size()));
            this.sendMetricsBatch(batch);
        }
    }

    private void sendMetricsBatch(List<Metric> metrics) {
        try {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            SmileGenerator gen = smileFactory.createGenerator((OutputStream)output, JsonEncoding.UTF8);
            gen.writeStartObject();
            this.writeCommonTags((JsonGenerator)gen);
            if (this.writeMetrics((JsonGenerator)gen, metrics) == 0) {
                return;
            }
            gen.writeEndObject();
            gen.flush();
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.valueOf((String)"application/x-jackson-smile"));
            HttpEntity entity = new HttpEntity((Object)output.toByteArray(), (MultiValueMap)headers);
            try {
                this.restTemplate.exchange(this.uri, HttpMethod.POST, entity, Map.class, new Object[0]);
            }
            catch (HttpClientErrorException e) {
                logger.error((Object)("Failed to write metrics to atlas: " + e.getResponseBodyAsString()), (Throwable)e);
            }
            catch (RestClientException e) {
                logger.error((Object)"Failed to write metrics to atlas", (Throwable)e);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeCommonTags(JsonGenerator gen) throws IOException {
        gen.writeObjectFieldStart("tags");
        for (Tag tag : this.commonTags) {
            gen.writeStringField(tag.getKey(), tag.getValue());
        }
        gen.writeEndObject();
    }

    private int writeMetrics(JsonGenerator gen, List<Metric> metrics) throws IOException {
        int totalMetricsInBatch = 0;
        gen.writeArrayFieldStart("metrics");
        for (Metric m : metrics) {
            if (!AtlasMetricObserver.validTags(m.getConfig().getTags()) || !Number.class.isAssignableFrom(m.getValue().getClass())) continue;
            gen.writeStartObject();
            gen.writeObjectFieldStart("tags");
            gen.writeStringField("name", m.getConfig().getName());
            for (Tag tag : m.getConfig().getTags()) {
                gen.writeStringField(tag.getKey(), tag.getValue());
            }
            gen.writeEndObject();
            gen.writeNumberField("start", m.getTimestamp());
            gen.writeNumberField("value", m.getNumberValue().doubleValue());
            gen.writeEndObject();
            ++totalMetricsInBatch;
        }
        gen.writeEndArray();
        return totalMetricsInBatch;
    }

    protected static List<Metric> addTypeTagsAsNecessary(List<Metric> metrics) {
        ArrayList<Metric> typedMetrics = new ArrayList<Metric>();
        for (Metric m : metrics) {
            String value = m.getConfig().getTags().getValue(DataSourceType.KEY);
            Metric transformed = DataSourceType.GAUGE.name().equals(value) || DataSourceType.RATE.name().equals(value) || DataSourceType.NORMALIZED.name().equals(value) ? new Metric(m.getConfig().withAdditionalTag(atlasGaugeTag), m.getTimestamp(), m.getValue()) : (DataSourceType.COUNTER.name().equals(value) ? new Metric(m.getConfig().withAdditionalTag(atlasCounterTag), m.getTimestamp(), m.getValue()) : new Metric(m.getConfig().withAdditionalTag(atlasRateTag), m.getTimestamp(), m.getValue()));
            typedMetrics.add(transformed);
        }
        return typedMetrics;
    }
}

