/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.cloud.gateway.event.PredicateArgsEvent;
import org.springframework.cloud.gateway.event.RefreshRoutesEvent;
import org.springframework.cloud.gateway.event.WeightDefinedEvent;
import org.springframework.cloud.gateway.route.RouteLocator;
import org.springframework.cloud.gateway.support.ConfigurationService;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.cloud.gateway.support.WeightConfig;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.SmartApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.core.style.ToStringCreator;
import org.springframework.validation.Validator;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public class WeightCalculatorWebFilter
implements WebFilter,
Ordered,
SmartApplicationListener {
    public static final int WEIGHT_CALC_FILTER_ORDER = 10001;
    private static final Log log = LogFactory.getLog(WeightCalculatorWebFilter.class);
    private final ObjectProvider<RouteLocator> routeLocator;
    private final ConfigurationService configurationService;
    private Random random = new Random();
    private int order = 10001;
    private Map<String, GroupWeightConfig> groupWeights = new ConcurrentHashMap<String, GroupWeightConfig>();

    WeightCalculatorWebFilter() {
        this.routeLocator = null;
        this.configurationService = new ConfigurationService();
    }

    @Deprecated
    public WeightCalculatorWebFilter(Validator validator) {
        this(validator, null);
    }

    @Deprecated
    public WeightCalculatorWebFilter(Validator validator, ObjectProvider<RouteLocator> routeLocator) {
        this.routeLocator = routeLocator;
        this.configurationService = new ConfigurationService();
        this.configurationService.setValidator(validator);
    }

    public WeightCalculatorWebFilter(ObjectProvider<RouteLocator> routeLocator, ConfigurationService configurationService) {
        this.routeLocator = routeLocator;
        this.configurationService = configurationService;
    }

    static Map<String, String> getWeights(ServerWebExchange exchange) {
        ConcurrentHashMap weights = (ConcurrentHashMap)exchange.getAttribute(ServerWebExchangeUtils.WEIGHT_ATTR);
        if (weights == null) {
            weights = new ConcurrentHashMap();
            exchange.getAttributes().put(ServerWebExchangeUtils.WEIGHT_ATTR, weights);
        }
        return weights;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public void setRandom(Random random) {
        this.random = random;
    }

    public boolean supportsEventType(Class<? extends ApplicationEvent> eventType) {
        return PredicateArgsEvent.class.isAssignableFrom(eventType) || WeightDefinedEvent.class.isAssignableFrom(eventType) || RefreshRoutesEvent.class.isAssignableFrom(eventType);
    }

    public boolean supportsSourceType(Class<?> sourceType) {
        return true;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof PredicateArgsEvent) {
            this.handle((PredicateArgsEvent)event);
        } else if (event instanceof WeightDefinedEvent) {
            this.addWeightConfig(((WeightDefinedEvent)event).getWeightConfig());
        } else if (event instanceof RefreshRoutesEvent && this.routeLocator != null) {
            this.routeLocator.ifAvailable(locator -> locator.getRoutes().subscribe());
        }
    }

    public void handle(PredicateArgsEvent event) {
        Map<String, Object> args = event.getArgs();
        if (args.isEmpty() || !this.hasRelevantKey(args)) {
            return;
        }
        WeightConfig config = new WeightConfig(event.getRouteId());
        ((ConfigurationService.InstanceBuilder)((ConfigurationService.InstanceBuilder)this.configurationService.with(config).name("weight")).normalizedProperties(args)).bind();
        this.addWeightConfig(config);
    }

    private boolean hasRelevantKey(Map<String, Object> args) {
        return args.keySet().stream().anyMatch(key -> key.startsWith("weight."));
    }

    void addWeightConfig(WeightConfig weightConfig) {
        String group = weightConfig.getGroup();
        GroupWeightConfig c = this.groupWeights.get(group);
        if (c == null) {
            c = new GroupWeightConfig(group);
            this.groupWeights.put(group, c);
        }
        GroupWeightConfig config = c;
        config.weights.put(weightConfig.getRouteId(), weightConfig.getWeight());
        int weightsSum = config.weights.values().stream().mapToInt(Integer::intValue).sum();
        AtomicInteger index = new AtomicInteger(0);
        config.weights.forEach((routeId, weight) -> {
            Double nomalizedWeight = (double)weight.intValue() / (double)weightsSum;
            config.normalizedWeights.put((String)routeId, nomalizedWeight);
            config.rangeIndexes.put(index.getAndIncrement(), (String)routeId);
        });
        config.ranges.clear();
        config.ranges.add(0.0);
        ArrayList<Double> values = new ArrayList<Double>(config.normalizedWeights.values());
        for (int i = 0; i < values.size(); ++i) {
            Double currentWeight = (Double)values.get(i);
            Double previousRange = config.ranges.get(i);
            Double range = previousRange + currentWeight;
            config.ranges.add(range);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Recalculated group weight config " + config));
        }
    }

    Map<String, GroupWeightConfig> getGroupWeights() {
        return this.groupWeights;
    }

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        Map<String, String> weights = WeightCalculatorWebFilter.getWeights(exchange);
        block0: for (String group : this.groupWeights.keySet()) {
            GroupWeightConfig config = this.groupWeights.get(group);
            if (config == null) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("No GroupWeightConfig found for group: " + group));
                continue;
            }
            double r = this.random.nextDouble();
            List<Double> ranges = config.ranges;
            if (log.isTraceEnabled()) {
                log.trace((Object)("Weight for group: " + group + ", ranges: " + ranges + ", r: " + r));
            }
            for (int i = 0; i < ranges.size() - 1; ++i) {
                if (!(r >= ranges.get(i)) || !(r < ranges.get(i + 1))) continue;
                String routeId = config.rangeIndexes.get(i);
                weights.put(group, routeId);
                continue block0;
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Weights attr: " + weights));
        }
        return chain.filter(exchange);
    }

    static class GroupWeightConfig {
        String group;
        LinkedHashMap<String, Integer> weights = new LinkedHashMap();
        LinkedHashMap<String, Double> normalizedWeights = new LinkedHashMap();
        LinkedHashMap<Integer, String> rangeIndexes = new LinkedHashMap();
        List<Double> ranges = new ArrayList<Double>();

        GroupWeightConfig(String group) {
            this.group = group;
        }

        public String toString() {
            return new ToStringCreator((Object)this).append("group", (Object)this.group).append("weights", this.weights).append("normalizedWeights", this.normalizedWeights).append("rangeIndexes", this.rangeIndexes).toString();
        }
    }
}

