/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.config;

import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.circuitbreaker.resilience4j.ReactiveResilience4JAutoConfiguration;
import org.springframework.cloud.circuitbreaker.resilience4j.ReactiveResilience4JCircuitBreakerFactory;
import org.springframework.cloud.client.circuitbreaker.ReactiveCircuitBreakerFactory;
import org.springframework.cloud.gateway.filter.factory.FallbackHeadersGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.SpringCloudCircuitBreakerHystrixFilterFactory;
import org.springframework.cloud.gateway.filter.factory.SpringCloudCircuitBreakerResilience4JFilterFactory;
import org.springframework.cloud.netflix.hystrix.HystrixCircuitBreakerAutoConfiguration;
import org.springframework.cloud.netflix.hystrix.ReactiveHystrixCircuitBreakerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.reactive.DispatcherHandler;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(name={"spring.cloud.gateway.enabled"}, matchIfMissing=true)
@AutoConfigureAfter(value={ReactiveResilience4JAutoConfiguration.class, HystrixCircuitBreakerAutoConfiguration.class})
@ConditionalOnClass(value={DispatcherHandler.class, ReactiveResilience4JAutoConfiguration.class, HystrixCircuitBreakerAutoConfiguration.class})
public class GatewayCircuitBreakerAutoConfiguration {

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={ReactiveCircuitBreakerFactory.class, ReactiveResilience4JCircuitBreakerFactory.class})
    protected static class Resilience4JConfiguration {
        protected Resilience4JConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={FallbackHeadersGatewayFilterFactory.class})
        public FallbackHeadersGatewayFilterFactory fallbackHeadersGatewayFilterFactory() {
            return new FallbackHeadersGatewayFilterFactory();
        }

        @Bean
        @ConditionalOnBean(value={ReactiveResilience4JCircuitBreakerFactory.class})
        public SpringCloudCircuitBreakerResilience4JFilterFactory springCloudCircuitBreakerResilience4JFilterFactory(ReactiveResilience4JCircuitBreakerFactory reactiveCircuitBreakerFactory, ObjectProvider<DispatcherHandler> dispatcherHandler) {
            return new SpringCloudCircuitBreakerResilience4JFilterFactory((ReactiveCircuitBreakerFactory)reactiveCircuitBreakerFactory, dispatcherHandler);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={ReactiveCircuitBreakerFactory.class, ReactiveHystrixCircuitBreakerFactory.class})
    protected static class SpringCloudCircuitBreakerHystrixConfiguration {
        protected SpringCloudCircuitBreakerHystrixConfiguration() {
        }

        @Bean
        @ConditionalOnBean(value={ReactiveHystrixCircuitBreakerFactory.class})
        public SpringCloudCircuitBreakerHystrixFilterFactory springCloudCircuitBreakerHystrixFilterFactory(ReactiveHystrixCircuitBreakerFactory reactiveCircuitBreakerFactory, ObjectProvider<DispatcherHandler> dispatcherHandler) {
            return new SpringCloudCircuitBreakerHystrixFilterFactory((ReactiveCircuitBreakerFactory)reactiveCircuitBreakerFactory, dispatcherHandler);
        }

        @Bean
        @ConditionalOnMissingBean(value={FallbackHeadersGatewayFilterFactory.class})
        public FallbackHeadersGatewayFilterFactory fallbackHeadersGatewayFilterFactory() {
            return new FallbackHeadersGatewayFilterFactory();
        }
    }
}

