/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.bootstrap.encrypt;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.context.environment.EnvironmentChangeEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.PropertySources;
import org.springframework.security.crypto.encrypt.TextEncryptor;

public class EnvironmentDecryptApplicationInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext>,
Ordered {
    public static final String DECRYPTED_PROPERTY_SOURCE_NAME = "decrypted";
    private int order = -2147483633;
    private static Log logger = LogFactory.getLog(EnvironmentDecryptApplicationInitializer.class);
    private TextEncryptor encryptor;
    private boolean failOnError = true;

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public EnvironmentDecryptApplicationInitializer(TextEncryptor encryptor) {
        this.encryptor = encryptor;
    }

    public int getOrder() {
        return this.order;
    }

    public void initialize(ConfigurableApplicationContext applicationContext) {
        ConfigurableEnvironment environment = applicationContext.getEnvironment();
        MapPropertySource decrypted = new MapPropertySource(DECRYPTED_PROPERTY_SOURCE_NAME, this.decrypt((PropertySources)environment.getPropertySources()));
        if (!((Map)decrypted.getSource()).isEmpty()) {
            this.insert(environment.getPropertySources(), decrypted);
            ApplicationContext parent = applicationContext.getParent();
            if (parent != null && parent.getEnvironment() instanceof ConfigurableEnvironment) {
                ConfigurableEnvironment mutable = (ConfigurableEnvironment)parent.getEnvironment();
                this.insert(mutable.getPropertySources(), decrypted);
                parent.publishEvent((ApplicationEvent)new EnvironmentChangeEvent(((Map)decrypted.getSource()).keySet()));
            }
        }
    }

    private void insert(MutablePropertySources propertySources, MapPropertySource propertySource) {
        if (propertySources.contains("bootstrap")) {
            propertySources.addAfter("bootstrap", (PropertySource)propertySource);
        } else {
            propertySources.addFirst((PropertySource)propertySource);
        }
    }

    public Map<String, Object> decrypt(PropertySources propertySources) {
        LinkedHashMap<String, Object> overrides = new LinkedHashMap<String, Object>();
        ArrayList<PropertySource> sources = new ArrayList<PropertySource>();
        for (PropertySource source : propertySources) {
            sources.add(0, source);
        }
        for (PropertySource source : sources) {
            this.decrypt(source, overrides);
        }
        return overrides;
    }

    private void decrypt(PropertySource<?> source, Map<String, Object> overrides) {
        block9: {
            block8: {
                if (!(source instanceof EnumerablePropertySource)) break block8;
                EnumerablePropertySource enumerable = (EnumerablePropertySource)source;
                for (String key : enumerable.getPropertyNames()) {
                    String value = source.getProperty(key).toString();
                    if (!value.startsWith("{cipher}")) continue;
                    value = value.substring("{cipher}".length());
                    try {
                        value = this.encryptor.decrypt(value);
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Decrypted: key=" + key));
                        }
                    }
                    catch (Exception e) {
                        String message = "Cannot decrypt: key=" + key;
                        if (this.failOnError) {
                            throw new IllegalStateException(message, e);
                        }
                        if (logger.isDebugEnabled()) {
                            logger.warn((Object)message, (Throwable)e);
                        } else {
                            logger.warn((Object)message);
                        }
                        value = "";
                    }
                    overrides.put(key, value);
                }
                break block9;
            }
            if (!(source instanceof CompositePropertySource)) break block9;
            for (PropertySource nested : ((CompositePropertySource)source).getPropertySources()) {
                this.decrypt(nested, overrides);
            }
        }
    }
}

