/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.ext;

import java.io.IOException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.core.JsonParser;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.core.JsonProcessingException;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.BeanDescription;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.DeserializationConfig;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.DeserializationContext;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.JavaType;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.JsonDeserializer;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.deser.Deserializers;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.deser.std.FromStringDeserializer;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;

public class CoreXMLDeserializers
extends Deserializers.Base {
    static final DatatypeFactory _dataTypeFactory;

    @Override
    public JsonDeserializer<?> findBeanDeserializer(JavaType javaType, DeserializationConfig deserializationConfig, BeanDescription beanDescription) {
        Class<?> clazz = javaType.getRawClass();
        if (clazz == QName.class) {
            return QNameDeserializer.instance;
        }
        if (clazz == XMLGregorianCalendar.class) {
            return GregorianCalendarDeserializer.instance;
        }
        if (clazz == Duration.class) {
            return DurationDeserializer.instance;
        }
        return null;
    }

    static {
        try {
            _dataTypeFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException datatypeConfigurationException) {
            throw new RuntimeException(datatypeConfigurationException);
        }
    }

    public static class QNameDeserializer
    extends FromStringDeserializer<QName> {
        private static final long serialVersionUID = 1L;
        public static final QNameDeserializer instance = new QNameDeserializer();

        public QNameDeserializer() {
            super(QName.class);
        }

        @Override
        protected QName _deserialize(String string, DeserializationContext deserializationContext) throws IllegalArgumentException {
            return QName.valueOf(string);
        }
    }

    public static class GregorianCalendarDeserializer
    extends StdScalarDeserializer<XMLGregorianCalendar> {
        private static final long serialVersionUID = 1L;
        public static final GregorianCalendarDeserializer instance = new GregorianCalendarDeserializer();

        public GregorianCalendarDeserializer() {
            super(XMLGregorianCalendar.class);
        }

        @Override
        public XMLGregorianCalendar deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            Date date = this._parseDate(jsonParser, deserializationContext);
            if (date == null) {
                return null;
            }
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTime(date);
            TimeZone timeZone = deserializationContext.getTimeZone();
            if (timeZone != null) {
                gregorianCalendar.setTimeZone(timeZone);
            }
            return _dataTypeFactory.newXMLGregorianCalendar(gregorianCalendar);
        }
    }

    public static class DurationDeserializer
    extends FromStringDeserializer<Duration> {
        private static final long serialVersionUID = 1L;
        public static final DurationDeserializer instance = new DurationDeserializer();

        public DurationDeserializer() {
            super(Duration.class);
        }

        @Override
        protected Duration _deserialize(String string, DeserializationContext deserializationContext) throws IllegalArgumentException {
            return _dataTypeFactory.newDuration(string);
        }
    }
}

