/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.config;

import java.util.Map;
import org.springframework.amqp.core.AnonymousQueue;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.rabbit.config.NamespaceUtils;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueueParser
extends AbstractSingleBeanDefinitionParser {
    private static final String ARGUMENTS_ELEMENT = "queue-arguments";
    private static final String DURABLE_ATTRIBUTE = "durable";
    private static final String EXCLUSIVE_ATTRIBUTE = "exclusive";
    private static final String AUTO_DELETE_ATTRIBUTE = "auto-delete";

    protected boolean shouldGenerateIdAsFallback() {
        return true;
    }

    protected Class<?> getBeanClass(Element element) {
        if (NamespaceUtils.isAttributeDefined(element, "name")) {
            return Queue.class;
        }
        return AnonymousQueue.class;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        Element argumentsElement;
        if (!NamespaceUtils.isAttributeDefined(element, "name") && !NamespaceUtils.isAttributeDefined(element, "id")) {
            parserContext.getReaderContext().error("Queue must have either id or name (or both)", (Object)element);
        }
        NamespaceUtils.addConstructorArgValueIfAttributeDefined(builder, element, "name");
        if (!NamespaceUtils.isAttributeDefined(element, "name")) {
            if (this.attributeHasIllegalOverride(element, DURABLE_ATTRIBUTE, "false") || this.attributeHasIllegalOverride(element, EXCLUSIVE_ATTRIBUTE, "true") || this.attributeHasIllegalOverride(element, AUTO_DELETE_ATTRIBUTE, "true")) {
                parserContext.getReaderContext().error("Anonymous queue cannot specify durable='true', exclusive='false' or auto-delete='false'", (Object)element);
                return;
            }
        } else {
            NamespaceUtils.addConstructorArgBooleanValueIfAttributeDefined(builder, element, DURABLE_ATTRIBUTE, false);
            NamespaceUtils.addConstructorArgBooleanValueIfAttributeDefined(builder, element, EXCLUSIVE_ATTRIBUTE, false);
            NamespaceUtils.addConstructorArgBooleanValueIfAttributeDefined(builder, element, AUTO_DELETE_ATTRIBUTE, false);
        }
        if ((argumentsElement = DomUtils.getChildElementByTagName((Element)element, (String)ARGUMENTS_ELEMENT)) != null) {
            Map map = parserContext.getDelegate().parseMapElement(argumentsElement, (BeanDefinition)builder.getRawBeanDefinition());
            builder.addConstructorArgValue((Object)map);
        }
    }

    private boolean attributeHasIllegalOverride(Element element, String name, String allowed) {
        return element.getAttributeNode(name) != null && element.getAttributeNode(name).getSpecified() && !allowed.equals(element.getAttribute(name));
    }
}

