/*
 * Decompiled with CFR 0.152.
 */
package org.skyscreamer.jsonassert;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;
import org.skyscreamer.jsonassert.FieldComparisonFailure;

public class JSONCompareResult {
    private boolean _success;
    private String _message;
    private String _field;
    private Object _expected;
    private Object _actual;
    private final List<FieldComparisonFailure> _fieldFailures = new ArrayList<FieldComparisonFailure>();

    public JSONCompareResult() {
        this(true, null);
    }

    private JSONCompareResult(boolean success, String message) {
        this._success = success;
        this._message = message == null ? "" : message;
    }

    public boolean passed() {
        return this._success;
    }

    public boolean failed() {
        return !this._success;
    }

    public String getMessage() {
        return this._message;
    }

    public List<FieldComparisonFailure> getFieldFailures() {
        return Collections.unmodifiableList(this._fieldFailures);
    }

    public Object getActual() {
        return this._actual;
    }

    public Object getExpected() {
        return this._expected;
    }

    public boolean isFailureOnField() {
        return !this._fieldFailures.isEmpty();
    }

    public String getField() {
        return this._field;
    }

    protected void fail(String message) {
        this._success = false;
        this._message = this._message.length() == 0 ? message : this._message + " ; " + message;
    }

    protected JSONCompareResult fail(String field, Object expected, Object actual) {
        this._fieldFailures.add(new FieldComparisonFailure(field, expected, actual));
        this._field = field;
        this._expected = expected;
        this._actual = actual;
        this.fail(this.formatFailureMessage(field, expected, actual));
        return this;
    }

    private String formatFailureMessage(String field, Object expected, Object actual) {
        StringBuffer message = new StringBuffer();
        message.append(field);
        message.append("\nExpected: ");
        message.append(JSONCompareResult.describe(expected));
        message.append("\n     got: ");
        message.append(JSONCompareResult.describe(actual));
        message.append("\n");
        return message.toString();
    }

    public JSONCompareResult missing(String field, Object expected) {
        this.fail(this.formatMissing(field, expected));
        return this;
    }

    private String formatMissing(String field, Object expected) {
        StringBuffer message = new StringBuffer();
        message.append(field);
        message.append("\nExpected: ");
        message.append(JSONCompareResult.describe(expected));
        message.append("\n     but none found\n");
        return message.toString();
    }

    public JSONCompareResult unexpected(String field, Object value) {
        this.fail(this.formatUnexpected(field, value));
        return this;
    }

    private String formatUnexpected(String field, Object value) {
        StringBuffer message = new StringBuffer();
        message.append(field);
        message.append("\nUnexpected: ");
        message.append(JSONCompareResult.describe(value));
        message.append("\n");
        return message.toString();
    }

    private static String describe(Object value) {
        if (value instanceof JSONArray) {
            return "a JSON array";
        }
        if (value instanceof JSONObject) {
            return "a JSON object";
        }
        return value.toString();
    }

    public String toString() {
        return this._message;
    }
}

